// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/channel/v1/service.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_CHANNEL_V1_CLOUD_CHANNEL_CLIENT_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_CHANNEL_V1_CLOUD_CHANNEL_CLIENT_H

#include "google/cloud/channel/v1/cloud_channel_connection.h"
#include "google/cloud/future.h"
#include "google/cloud/options.h"
#include "google/cloud/polling_policy.h"
#include "google/cloud/status_or.h"
#include "google/cloud/version.h"
#include <google/longrunning/operations.grpc.pb.h>
#include <memory>

namespace google {
namespace cloud {
namespace channel_v1 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

///
/// CloudChannelService lets Google cloud resellers and distributors manage
/// their customers, channel partners, entitlements, and reports.
///
/// Using this service:
/// 1. Resellers and distributors can manage a customer entity.
/// 2. Distributors can register an authorized reseller in their channel and
///    provide them with delegated admin access.
/// 3. Resellers and distributors can manage customer entitlements.
///
/// CloudChannelService exposes the following resources:
/// - [Customer][google.cloud.channel.v1.Customer]s: An entity-usually an
/// enterprise-managed by a reseller or distributor.
///
/// - [Entitlement][google.cloud.channel.v1.Entitlement]s: An entity that
/// provides a customer with the means to use a service. Entitlements are
/// created or updated as a result of a successful fulfillment.
///
/// - [ChannelPartnerLink][google.cloud.channel.v1.ChannelPartnerLink]s: An
/// entity that identifies links between distributors and their indirect
/// resellers in a channel.
///
/// @par Equality
///
/// Instances of this class created via copy-construction or copy-assignment
/// always compare equal. Instances created with equal
/// `std::shared_ptr<*Connection>` objects compare equal. Objects that compare
/// equal share the same underlying resources.
///
/// @par Performance
///
/// Creating a new instance of this class is a relatively expensive operation,
/// new objects establish new connections to the service. In contrast,
/// copy-construction, move-construction, and the corresponding assignment
/// operations are relatively efficient as the copies share all underlying
/// resources.
///
/// @par Thread Safety
///
/// Concurrent access to different instances of this class, even if they compare
/// equal, is guaranteed to work. Two or more threads operating on the same
/// instance of this class is not guaranteed to work. Since copy-construction
/// and move-construction is a relatively efficient operation, consider using
/// such a copy when using this class from multiple threads.
///
/// [google.cloud.channel.v1.ChannelPartnerLink]:
/// @googleapis_reference_link{google/cloud/channel/v1/channel_partner_links.proto#L66}
/// [google.cloud.channel.v1.Customer]:
/// @googleapis_reference_link{google/cloud/channel/v1/customers.proto#L31}
/// [google.cloud.channel.v1.Entitlement]:
/// @googleapis_reference_link{google/cloud/channel/v1/entitlements.proto#L32}
///
class CloudChannelServiceClient {
 public:
  explicit CloudChannelServiceClient(
      std::shared_ptr<CloudChannelServiceConnection> connection,
      Options opts = {});
  ~CloudChannelServiceClient();

  ///@{
  /// @name Copy and move support
  CloudChannelServiceClient(CloudChannelServiceClient const&) = default;
  CloudChannelServiceClient& operator=(CloudChannelServiceClient const&) =
      default;
  CloudChannelServiceClient(CloudChannelServiceClient&&) = default;
  CloudChannelServiceClient& operator=(CloudChannelServiceClient&&) = default;
  ///@}

  ///@{
  /// @name Equality
  friend bool operator==(CloudChannelServiceClient const& a,
                         CloudChannelServiceClient const& b) {
    return a.connection_ == b.connection_;
  }
  friend bool operator!=(CloudChannelServiceClient const& a,
                         CloudChannelServiceClient const& b) {
    return !(a == b);
  }
  ///@}

  // clang-format off
  ///
  /// List [Customer][google.cloud.channel.v1.Customer]s.
  ///
  /// Possible error codes:
  ///
  /// * PERMISSION_DENIED: The reseller account making the request is different
  /// from the reseller account in the API request.
  /// * INVALID_ARGUMENT: Required request parameters are missing or invalid.
  ///
  /// Return value:
  /// List of [Customer][google.cloud.channel.v1.Customer]s, or an empty list if
  /// there are no customers.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.channel.v1.ListCustomersRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.channel.v1.Customer], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.channel.v1.Customer]: @googleapis_reference_link{google/cloud/channel/v1/customers.proto#L31}
  /// [google.cloud.channel.v1.ListCustomersRequest]: @googleapis_reference_link{google/cloud/channel/v1/service.proto#L1508}
  ///
  // clang-format on
  StreamRange<google::cloud::channel::v1::Customer> ListCustomers(
      google::cloud::channel::v1::ListCustomersRequest request,
      Options opts = {});

  // clang-format off
  ///
  /// Returns the requested [Customer][google.cloud.channel.v1.Customer]
  /// resource.
  ///
  /// Possible error codes:
  ///
  /// * PERMISSION_DENIED: The reseller account making the request is different
  /// from the reseller account in the API request.
  /// * INVALID_ARGUMENT: Required request parameters are missing or invalid.
  /// * NOT_FOUND: The customer resource doesn't exist. Usually the result of an
  /// invalid name parameter.
  ///
  /// Return value:
  /// The [Customer][google.cloud.channel.v1.Customer] resource.
  ///
  /// @param name  Required. The resource name of the customer to retrieve.
  ///  Name uses the format: accounts/{account_id}/customers/{customer_id}
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.channel.v1.Customer])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.channel.v1.Customer]: @googleapis_reference_link{google/cloud/channel/v1/customers.proto#L31}
  /// [google.cloud.channel.v1.GetCustomerRequest]: @googleapis_reference_link{google/cloud/channel/v1/service.proto#L1548}
  ///
  // clang-format on
  StatusOr<google::cloud::channel::v1::Customer> GetCustomer(
      std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// Returns the requested [Customer][google.cloud.channel.v1.Customer]
  /// resource.
  ///
  /// Possible error codes:
  ///
  /// * PERMISSION_DENIED: The reseller account making the request is different
  /// from the reseller account in the API request.
  /// * INVALID_ARGUMENT: Required request parameters are missing or invalid.
  /// * NOT_FOUND: The customer resource doesn't exist. Usually the result of an
  /// invalid name parameter.
  ///
  /// Return value:
  /// The [Customer][google.cloud.channel.v1.Customer] resource.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.channel.v1.GetCustomerRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.channel.v1.Customer])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.channel.v1.Customer]: @googleapis_reference_link{google/cloud/channel/v1/customers.proto#L31}
  /// [google.cloud.channel.v1.GetCustomerRequest]: @googleapis_reference_link{google/cloud/channel/v1/service.proto#L1548}
  ///
  // clang-format on
  StatusOr<google::cloud::channel::v1::Customer> GetCustomer(
      google::cloud::channel::v1::GetCustomerRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// Confirms the existence of Cloud Identity accounts based on the domain and
  /// if the Cloud Identity accounts are owned by the reseller.
  ///
  /// Possible error codes:
  ///
  /// * PERMISSION_DENIED: The reseller account making the request is different
  /// from the reseller account in the API request.
  /// * INVALID_ARGUMENT: Required request parameters are missing or invalid.
  /// * INVALID_VALUE: Invalid domain value in the request.
  ///
  /// Return value:
  /// A list of
  /// [CloudIdentityCustomerAccount][google.cloud.channel.v1.CloudIdentityCustomerAccount]
  /// resources for the domain (may be empty)
  ///
  /// Note: in the v1alpha1 version of the API, a NOT_FOUND error returns if
  /// no
  /// [CloudIdentityCustomerAccount][google.cloud.channel.v1.CloudIdentityCustomerAccount]
  /// resources match the domain.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.channel.v1.CheckCloudIdentityAccountsExistRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.channel.v1.CheckCloudIdentityAccountsExistResponse])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.channel.v1.CheckCloudIdentityAccountsExistRequest]: @googleapis_reference_link{google/cloud/channel/v1/service.proto#L1470}
  /// [google.cloud.channel.v1.CheckCloudIdentityAccountsExistResponse]: @googleapis_reference_link{google/cloud/channel/v1/service.proto#L1501}
  /// [google.cloud.channel.v1.CloudIdentityCustomerAccount]: @googleapis_reference_link{google/cloud/channel/v1/service.proto#L1481}
  ///
  // clang-format on
  StatusOr<google::cloud::channel::v1::CheckCloudIdentityAccountsExistResponse>
  CheckCloudIdentityAccountsExist(
      google::cloud::channel::v1::CheckCloudIdentityAccountsExistRequest const&
          request,
      Options opts = {});

  // clang-format off
  ///
  /// Creates a new [Customer][google.cloud.channel.v1.Customer] resource under
  /// the reseller or distributor account.
  ///
  /// Possible error codes:
  ///
  /// * PERMISSION_DENIED:
  ///     * The reseller account making the request is different from the
  ///     reseller account in the API request.
  ///     * You are not authorized to create a customer. See
  ///     https://support.google.com/channelservices/answer/9759265
  /// * INVALID_ARGUMENT:
  ///     * Required request parameters are missing or invalid.
  ///     * Domain field value doesn't match the primary email domain.
  ///
  /// Return value:
  /// The newly created [Customer][google.cloud.channel.v1.Customer] resource.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.channel.v1.CreateCustomerRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.channel.v1.Customer])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.channel.v1.CreateCustomerRequest]: @googleapis_reference_link{google/cloud/channel/v1/service.proto#L1561}
  /// [google.cloud.channel.v1.Customer]: @googleapis_reference_link{google/cloud/channel/v1/customers.proto#L31}
  ///
  // clang-format on
  StatusOr<google::cloud::channel::v1::Customer> CreateCustomer(
      google::cloud::channel::v1::CreateCustomerRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// Updates an existing [Customer][google.cloud.channel.v1.Customer] resource
  /// for the reseller or distributor.
  ///
  /// Possible error codes:
  ///
  /// * PERMISSION_DENIED: The reseller account making the request is different
  /// from the reseller account in the API request.
  /// * INVALID_ARGUMENT: Required request parameters are missing or invalid.
  /// * NOT_FOUND: No [Customer][google.cloud.channel.v1.Customer] resource found
  /// for the name in the request.
  ///
  /// Return value:
  /// The updated [Customer][google.cloud.channel.v1.Customer] resource.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.channel.v1.UpdateCustomerRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.channel.v1.Customer])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.channel.v1.Customer]: @googleapis_reference_link{google/cloud/channel/v1/customers.proto#L31}
  /// [google.cloud.channel.v1.UpdateCustomerRequest]: @googleapis_reference_link{google/cloud/channel/v1/service.proto#L1572}
  ///
  // clang-format on
  StatusOr<google::cloud::channel::v1::Customer> UpdateCustomer(
      google::cloud::channel::v1::UpdateCustomerRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// Deletes the given [Customer][google.cloud.channel.v1.Customer] permanently.
  ///
  /// Possible error codes:
  ///
  /// * PERMISSION_DENIED: The account making the request does not own
  /// this customer.
  /// * INVALID_ARGUMENT: Required request parameters are missing or invalid.
  /// * FAILED_PRECONDITION: The customer has existing entitlements.
  /// * NOT_FOUND: No [Customer][google.cloud.channel.v1.Customer] resource found
  /// for the name in the request.
  ///
  /// @param name  Required. The resource name of the customer to delete.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [`Status`] object. If the request failed, the
  ///     status contains the details of the failure.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.channel.v1.Customer]: @googleapis_reference_link{google/cloud/channel/v1/customers.proto#L31}
  /// [google.cloud.channel.v1.DeleteCustomerRequest]: @googleapis_reference_link{google/cloud/channel/v1/service.proto#L1583}
  ///
  // clang-format on
  Status DeleteCustomer(std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// Deletes the given [Customer][google.cloud.channel.v1.Customer] permanently.
  ///
  /// Possible error codes:
  ///
  /// * PERMISSION_DENIED: The account making the request does not own
  /// this customer.
  /// * INVALID_ARGUMENT: Required request parameters are missing or invalid.
  /// * FAILED_PRECONDITION: The customer has existing entitlements.
  /// * NOT_FOUND: No [Customer][google.cloud.channel.v1.Customer] resource found
  /// for the name in the request.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.channel.v1.DeleteCustomerRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [`Status`] object. If the request failed, the
  ///     status contains the details of the failure.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.channel.v1.Customer]: @googleapis_reference_link{google/cloud/channel/v1/customers.proto#L31}
  /// [google.cloud.channel.v1.DeleteCustomerRequest]: @googleapis_reference_link{google/cloud/channel/v1/service.proto#L1583}
  ///
  // clang-format on
  Status DeleteCustomer(
      google::cloud::channel::v1::DeleteCustomerRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// Imports a [Customer][google.cloud.channel.v1.Customer] from the Cloud
  /// Identity associated with the provided Cloud Identity ID or domain before a
  /// TransferEntitlements call. If a linked Customer already exists and
  /// overwrite_if_exists is true, it will update that Customer's data.
  ///
  /// Possible error codes:
  ///
  /// * PERMISSION_DENIED:
  ///     * The reseller account making the request is different from the
  ///     reseller account in the API request.
  ///     * You are not authorized to import the customer. See
  ///     https://support.google.com/channelservices/answer/9759265
  /// * NOT_FOUND: Cloud Identity doesn't exist or was deleted.
  /// * INVALID_ARGUMENT: Required parameters are missing, or the auth_token is
  /// expired or invalid.
  /// * ALREADY_EXISTS: A customer already exists and has conflicting critical
  /// fields. Requires an overwrite.
  ///
  /// Return value:
  /// The [Customer][google.cloud.channel.v1.Customer].
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.channel.v1.ImportCustomerRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.channel.v1.Customer])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.channel.v1.Customer]: @googleapis_reference_link{google/cloud/channel/v1/customers.proto#L31}
  /// [google.cloud.channel.v1.ImportCustomerRequest]: @googleapis_reference_link{google/cloud/channel/v1/service.proto#L1595}
  ///
  // clang-format on
  StatusOr<google::cloud::channel::v1::Customer> ImportCustomer(
      google::cloud::channel::v1::ImportCustomerRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// Creates a Cloud Identity for the given customer using the customer's
  /// information, or the information provided here.
  ///
  /// Possible error codes:
  ///
  /// *  PERMISSION_DENIED:
  ///      * The customer doesn't belong to the reseller.
  ///      * You are not authorized to provision cloud identity id. See
  ///      https://support.google.com/channelservices/answer/9759265
  /// *  INVALID_ARGUMENT: Required request parameters are missing or invalid.
  /// *  NOT_FOUND: The customer was not found.
  /// *  ALREADY_EXISTS: The customer's primary email already exists. Retry
  ///    after changing the customer's primary contact email.
  /// * INTERNAL: Any non-user error related to a technical issue in the
  /// backend. Contact Cloud Channel support.
  /// * UNKNOWN: Any non-user error related to a technical issue in the backend.
  /// Contact Cloud Channel support.
  ///
  /// Return value:
  /// The ID of a long-running operation.
  ///
  /// To get the results of the operation, call the GetOperation method of
  /// CloudChannelOperationsService. The Operation metadata contains an
  /// instance of [OperationMetadata][google.cloud.channel.v1.OperationMetadata].
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.channel.v1.ProvisionCloudIdentityRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.channel.v1.Customer] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.channel.v1.Customer]: @googleapis_reference_link{google/cloud/channel/v1/customers.proto#L31}
  /// [google.cloud.channel.v1.OperationMetadata]: @googleapis_reference_link{google/cloud/channel/v1/operations.proto#L26}
  /// [google.cloud.channel.v1.ProvisionCloudIdentityRequest]: @googleapis_reference_link{google/cloud/channel/v1/service.proto#L1643}
  ///
  // clang-format on
  future<StatusOr<google::cloud::channel::v1::Customer>> ProvisionCloudIdentity(
      google::cloud::channel::v1::ProvisionCloudIdentityRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// Lists [Entitlement][google.cloud.channel.v1.Entitlement]s belonging to a
  /// customer.
  ///
  /// Possible error codes:
  ///
  /// * PERMISSION_DENIED: The customer doesn't belong to the reseller.
  /// * INVALID_ARGUMENT: Required request parameters are missing or invalid.
  ///
  /// Return value:
  /// A list of the customer's
  /// [Entitlement][google.cloud.channel.v1.Entitlement]s.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.channel.v1.ListEntitlementsRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.channel.v1.Entitlement], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.channel.v1.Entitlement]: @googleapis_reference_link{google/cloud/channel/v1/entitlements.proto#L32}
  /// [google.cloud.channel.v1.ListEntitlementsRequest]: @googleapis_reference_link{google/cloud/channel/v1/service.proto#L1665}
  ///
  // clang-format on
  StreamRange<google::cloud::channel::v1::Entitlement> ListEntitlements(
      google::cloud::channel::v1::ListEntitlementsRequest request,
      Options opts = {});

  // clang-format off
  ///
  /// List [TransferableSku][google.cloud.channel.v1.TransferableSku]s of a
  /// customer based on the Cloud Identity ID or Customer Name in the request.
  ///
  /// Use this method to list the entitlements information of an
  /// unowned customer. You should provide the customer's
  /// Cloud Identity ID or Customer Name.
  ///
  /// Possible error codes:
  ///
  /// * PERMISSION_DENIED:
  ///     * The customer doesn't belong to the reseller and has no auth token.
  ///     * The supplied auth token is invalid.
  ///     * The reseller account making the request is different
  ///     from the reseller account in the query.
  /// * INVALID_ARGUMENT: Required request parameters are missing or invalid.
  ///
  /// Return value:
  /// A list of the customer's
  /// [TransferableSku][google.cloud.channel.v1.TransferableSku].
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.channel.v1.ListTransferableSkusRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.channel.v1.TransferableSku], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.channel.v1.ListTransferableSkusRequest]: @googleapis_reference_link{google/cloud/channel/v1/service.proto#L1705}
  /// [google.cloud.channel.v1.TransferableSku]: @googleapis_reference_link{google/cloud/channel/v1/entitlements.proto#L238}
  ///
  // clang-format on
  StreamRange<google::cloud::channel::v1::TransferableSku> ListTransferableSkus(
      google::cloud::channel::v1::ListTransferableSkusRequest request,
      Options opts = {});

  // clang-format off
  ///
  /// List [TransferableOffer][google.cloud.channel.v1.TransferableOffer]s of a
  /// customer based on Cloud Identity ID or Customer Name in the request.
  ///
  /// Use this method when a reseller gets the entitlement information of an
  /// unowned customer. The reseller should provide the customer's
  /// Cloud Identity ID or Customer Name.
  ///
  /// Possible error codes:
  ///
  /// * PERMISSION_DENIED:
  ///     * The customer doesn't belong to the reseller and has no auth token.
  ///     * The customer provided incorrect reseller information when generating
  ///     auth token.
  ///     * The reseller account making the request is different
  ///     from the reseller account in the query.
  ///     * The reseller is not authorized to transact on this Product. See
  ///     https://support.google.com/channelservices/answer/9759265
  /// * INVALID_ARGUMENT: Required request parameters are missing or invalid.
  ///
  /// Return value:
  /// List of [TransferableOffer][google.cloud.channel.v1.TransferableOffer] for
  /// the given customer and SKU.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.channel.v1.ListTransferableOffersRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.channel.v1.TransferableOffer], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.channel.v1.ListTransferableOffersRequest]: @googleapis_reference_link{google/cloud/channel/v1/service.proto#L1766}
  /// [google.cloud.channel.v1.TransferableOffer]: @googleapis_reference_link{google/cloud/channel/v1/service.proto#L1827}
  ///
  // clang-format on
  StreamRange<google::cloud::channel::v1::TransferableOffer>
  ListTransferableOffers(
      google::cloud::channel::v1::ListTransferableOffersRequest request,
      Options opts = {});

  // clang-format off
  ///
  /// Returns the requested [Entitlement][google.cloud.channel.v1.Entitlement]
  /// resource.
  ///
  /// Possible error codes:
  ///
  /// * PERMISSION_DENIED: The customer doesn't belong to the reseller.
  /// * INVALID_ARGUMENT: Required request parameters are missing or invalid.
  /// * NOT_FOUND: The customer entitlement was not found.
  ///
  /// Return value:
  /// The requested [Entitlement][google.cloud.channel.v1.Entitlement] resource.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.channel.v1.GetEntitlementRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.channel.v1.Entitlement])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.channel.v1.Entitlement]: @googleapis_reference_link{google/cloud/channel/v1/entitlements.proto#L32}
  /// [google.cloud.channel.v1.GetEntitlementRequest]: @googleapis_reference_link{google/cloud/channel/v1/service.proto#L1834}
  ///
  // clang-format on
  StatusOr<google::cloud::channel::v1::Entitlement> GetEntitlement(
      google::cloud::channel::v1::GetEntitlementRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// Creates an entitlement for a customer.
  ///
  /// Possible error codes:
  ///
  /// * PERMISSION_DENIED:
  ///     * The customer doesn't belong to the reseller.
  ///     * The reseller is not authorized to transact on this Product. See
  ///     https://support.google.com/channelservices/answer/9759265
  /// * INVALID_ARGUMENT:
  ///     * Required request parameters are missing or invalid.
  ///     * There is already a customer entitlement for a SKU from the same
  ///     product family.
  /// * INVALID_VALUE: Make sure the OfferId is valid. If it is, contact
  /// Google Channel support for further troubleshooting.
  /// * NOT_FOUND: The customer or offer resource was not found.
  /// * ALREADY_EXISTS:
  ///     * The SKU was already purchased for the customer.
  ///     * The customer's primary email already exists. Retry
  ///     after changing the customer's primary contact email.
  /// * CONDITION_NOT_MET or FAILED_PRECONDITION:
  ///     * The domain required for purchasing a SKU has not been verified.
  ///     * A pre-requisite SKU required to purchase an Add-On SKU is missing.
  ///     For example, Google Workspace Business Starter is required to purchase
  ///     Vault or Drive.
  ///     * (Developer accounts only) Reseller and resold domain must meet the
  ///     following naming requirements:
  ///         * Domain names must start with goog-test.
  ///         * Domain names must include the reseller domain.
  /// * INTERNAL: Any non-user error related to a technical issue in the
  /// backend. Contact Cloud Channel support.
  /// * UNKNOWN: Any non-user error related to a technical issue in the backend.
  /// Contact Cloud Channel support.
  ///
  /// Return value:
  /// The ID of a long-running operation.
  ///
  /// To get the results of the operation, call the GetOperation method of
  /// CloudChannelOperationsService. The Operation metadata will contain an
  /// instance of [OperationMetadata][google.cloud.channel.v1.OperationMetadata].
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.channel.v1.CreateEntitlementRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.channel.v1.Entitlement] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.channel.v1.CreateEntitlementRequest]: @googleapis_reference_link{google/cloud/channel/v1/service.proto#L2246}
  /// [google.cloud.channel.v1.Entitlement]: @googleapis_reference_link{google/cloud/channel/v1/entitlements.proto#L32}
  /// [google.cloud.channel.v1.OperationMetadata]: @googleapis_reference_link{google/cloud/channel/v1/operations.proto#L26}
  ///
  // clang-format on
  future<StatusOr<google::cloud::channel::v1::Entitlement>> CreateEntitlement(
      google::cloud::channel::v1::CreateEntitlementRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// Change parameters of the entitlement.
  ///
  /// An entitlement update is a long-running operation and it updates the
  /// entitlement as a result of fulfillment.
  ///
  /// Possible error codes:
  ///
  /// * PERMISSION_DENIED: The customer doesn't belong to the reseller.
  /// * INVALID_ARGUMENT: Required request parameters are missing or invalid.
  /// For example, the number of seats being changed is greater than the allowed
  /// number of max seats, or decreasing seats for a commitment based plan.
  /// * NOT_FOUND: Entitlement resource not found.
  /// * INTERNAL: Any non-user error related to a technical issue in the
  /// backend. Contact Cloud Channel support.
  /// * UNKNOWN: Any non-user error related to a technical issue in the backend.
  /// Contact Cloud Channel support.
  ///
  /// Return value:
  /// The ID of a long-running operation.
  ///
  /// To get the results of the operation, call the GetOperation method of
  /// CloudChannelOperationsService. The Operation metadata will contain an
  /// instance of [OperationMetadata][google.cloud.channel.v1.OperationMetadata].
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.channel.v1.ChangeParametersRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.channel.v1.Entitlement] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.channel.v1.ChangeParametersRequest]: @googleapis_reference_link{google/cloud/channel/v1/service.proto#L2344}
  /// [google.cloud.channel.v1.Entitlement]: @googleapis_reference_link{google/cloud/channel/v1/entitlements.proto#L32}
  /// [google.cloud.channel.v1.OperationMetadata]: @googleapis_reference_link{google/cloud/channel/v1/operations.proto#L26}
  ///
  // clang-format on
  future<StatusOr<google::cloud::channel::v1::Entitlement>> ChangeParameters(
      google::cloud::channel::v1::ChangeParametersRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// Updates the renewal settings for an existing customer entitlement.
  ///
  /// An entitlement update is a long-running operation and it updates the
  /// entitlement as a result of fulfillment.
  ///
  /// Possible error codes:
  ///
  /// * PERMISSION_DENIED: The customer doesn't belong to the reseller.
  /// * INVALID_ARGUMENT: Required request parameters are missing or invalid.
  /// * NOT_FOUND: Entitlement resource not found.
  /// * NOT_COMMITMENT_PLAN: Renewal Settings are only applicable for a
  /// commitment plan. Can't enable or disable renewals for non-commitment plans.
  /// * INTERNAL: Any non-user error related to a technical issue in the
  /// backend. Contact Cloud Channel support.
  /// * UNKNOWN: Any non-user error related to a technical issue in the backend.
  ///   Contact Cloud Channel support.
  ///
  /// Return value:
  /// The ID of a long-running operation.
  ///
  /// To get the results of the operation, call the GetOperation method of
  /// CloudChannelOperationsService. The Operation metadata will contain an
  /// instance of [OperationMetadata][google.cloud.channel.v1.OperationMetadata].
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.channel.v1.ChangeRenewalSettingsRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.channel.v1.Entitlement] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.channel.v1.ChangeRenewalSettingsRequest]: @googleapis_reference_link{google/cloud/channel/v1/service.proto#L2378}
  /// [google.cloud.channel.v1.Entitlement]: @googleapis_reference_link{google/cloud/channel/v1/entitlements.proto#L32}
  /// [google.cloud.channel.v1.OperationMetadata]: @googleapis_reference_link{google/cloud/channel/v1/operations.proto#L26}
  ///
  // clang-format on
  future<StatusOr<google::cloud::channel::v1::Entitlement>>
  ChangeRenewalSettings(
      google::cloud::channel::v1::ChangeRenewalSettingsRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// Updates the Offer for an existing customer entitlement.
  ///
  /// An entitlement update is a long-running operation and it updates the
  /// entitlement as a result of fulfillment.
  ///
  /// Possible error codes:
  ///
  /// * PERMISSION_DENIED: The customer doesn't belong to the reseller.
  /// * INVALID_ARGUMENT: Required request parameters are missing or invalid.
  /// * NOT_FOUND: Offer or Entitlement resource not found.
  /// * INTERNAL: Any non-user error related to a technical issue in the
  /// backend. Contact Cloud Channel support.
  /// * UNKNOWN: Any non-user error related to a technical issue in the backend.
  /// Contact Cloud Channel support.
  ///
  /// Return value:
  /// The ID of a long-running operation.
  ///
  /// To get the results of the operation, call the GetOperation method of
  /// CloudChannelOperationsService. The Operation metadata will contain an
  /// instance of [OperationMetadata][google.cloud.channel.v1.OperationMetadata].
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.channel.v1.ChangeOfferRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.channel.v1.Entitlement] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.channel.v1.ChangeOfferRequest]: @googleapis_reference_link{google/cloud/channel/v1/service.proto#L2404}
  /// [google.cloud.channel.v1.Entitlement]: @googleapis_reference_link{google/cloud/channel/v1/entitlements.proto#L32}
  /// [google.cloud.channel.v1.OperationMetadata]: @googleapis_reference_link{google/cloud/channel/v1/operations.proto#L26}
  ///
  // clang-format on
  future<StatusOr<google::cloud::channel::v1::Entitlement>> ChangeOffer(
      google::cloud::channel::v1::ChangeOfferRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// Starts paid service for a trial entitlement.
  ///
  /// Starts paid service for a trial entitlement immediately. This method is
  /// only applicable if a plan is set up for a trial entitlement but has some
  /// trial days remaining.
  ///
  /// Possible error codes:
  ///
  /// * PERMISSION_DENIED: The customer doesn't belong to the reseller.
  /// * INVALID_ARGUMENT: Required request parameters are missing or invalid.
  /// * NOT_FOUND: Entitlement resource not found.
  /// * FAILED_PRECONDITION/NOT_IN_TRIAL: This method only works for
  /// entitlement on trial plans.
  /// * INTERNAL: Any non-user error related to a technical issue in the
  /// backend. Contact Cloud Channel support.
  /// * UNKNOWN: Any non-user error related to a technical issue in the backend.
  /// Contact Cloud Channel support.
  ///
  /// Return value:
  /// The ID of a long-running operation.
  ///
  /// To get the results of the operation, call the GetOperation method of
  /// CloudChannelOperationsService. The Operation metadata will contain an
  /// instance of [OperationMetadata][google.cloud.channel.v1.OperationMetadata].
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.channel.v1.StartPaidServiceRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.channel.v1.Entitlement] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.channel.v1.Entitlement]: @googleapis_reference_link{google/cloud/channel/v1/entitlements.proto#L32}
  /// [google.cloud.channel.v1.OperationMetadata]: @googleapis_reference_link{google/cloud/channel/v1/operations.proto#L26}
  /// [google.cloud.channel.v1.StartPaidServiceRequest]: @googleapis_reference_link{google/cloud/channel/v1/service.proto#L2452}
  ///
  // clang-format on
  future<StatusOr<google::cloud::channel::v1::Entitlement>> StartPaidService(
      google::cloud::channel::v1::StartPaidServiceRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// Suspends a previously fulfilled entitlement.
  ///
  /// An entitlement suspension is a long-running operation.
  ///
  /// Possible error codes:
  ///
  /// * PERMISSION_DENIED: The customer doesn't belong to the reseller.
  /// * INVALID_ARGUMENT: Required request parameters are missing or invalid.
  /// * NOT_FOUND: Entitlement resource not found.
  /// * NOT_ACTIVE: Entitlement is not active.
  /// * INTERNAL: Any non-user error related to a technical issue in the
  /// backend. Contact Cloud Channel support.
  /// * UNKNOWN: Any non-user error related to a technical issue in the backend.
  /// Contact Cloud Channel support.
  ///
  /// Return value:
  /// The ID of a long-running operation.
  ///
  /// To get the results of the operation, call the GetOperation method of
  /// CloudChannelOperationsService. The Operation metadata will contain an
  /// instance of [OperationMetadata][google.cloud.channel.v1.OperationMetadata].
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.channel.v1.SuspendEntitlementRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.channel.v1.Entitlement] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.channel.v1.Entitlement]: @googleapis_reference_link{google/cloud/channel/v1/entitlements.proto#L32}
  /// [google.cloud.channel.v1.OperationMetadata]: @googleapis_reference_link{google/cloud/channel/v1/operations.proto#L26}
  /// [google.cloud.channel.v1.SuspendEntitlementRequest]: @googleapis_reference_link{google/cloud/channel/v1/service.proto#L2498}
  ///
  // clang-format on
  future<StatusOr<google::cloud::channel::v1::Entitlement>> SuspendEntitlement(
      google::cloud::channel::v1::SuspendEntitlementRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// Cancels a previously fulfilled entitlement.
  ///
  /// An entitlement cancellation is a long-running operation.
  ///
  /// Possible error codes:
  ///
  /// * PERMISSION_DENIED: The reseller account making the request is different
  /// from the reseller account in the API request.
  /// * FAILED_PRECONDITION: There are Google Cloud projects linked to the
  /// Google Cloud entitlement's Cloud Billing subaccount.
  /// * INVALID_ARGUMENT: Required request parameters are missing or invalid.
  /// * NOT_FOUND: Entitlement resource not found.
  /// * DELETION_TYPE_NOT_ALLOWED: Cancel is only allowed for Google Workspace
  /// add-ons, or entitlements for Google Cloud's development platform.
  /// * INTERNAL: Any non-user error related to a technical issue in the
  /// backend. Contact Cloud Channel support.
  /// * UNKNOWN: Any non-user error related to a technical issue in the backend.
  /// Contact Cloud Channel support.
  ///
  /// Return value:
  /// The ID of a long-running operation.
  ///
  /// To get the results of the operation, call the GetOperation method of
  /// CloudChannelOperationsService. The response will contain
  /// google.protobuf.Empty on success. The Operation metadata will contain an
  /// instance of [OperationMetadata][google.cloud.channel.v1.OperationMetadata].
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.channel.v1.CancelEntitlementRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.channel.v1.OperationMetadata] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.channel.v1.CancelEntitlementRequest]: @googleapis_reference_link{google/cloud/channel/v1/service.proto#L2475}
  /// [google.cloud.channel.v1.OperationMetadata]: @googleapis_reference_link{google/cloud/channel/v1/operations.proto#L26}
  ///
  // clang-format on
  future<StatusOr<google::cloud::channel::v1::OperationMetadata>>
  CancelEntitlement(
      google::cloud::channel::v1::CancelEntitlementRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// Activates a previously suspended entitlement. Entitlements suspended for
  /// pending ToS acceptance can't be activated using this method.
  ///
  /// An entitlement activation is a long-running operation and it updates
  /// the state of the customer entitlement.
  ///
  /// Possible error codes:
  ///
  /// * PERMISSION_DENIED: The reseller account making the request is different
  /// from the reseller account in the API request.
  /// * INVALID_ARGUMENT: Required request parameters are missing or invalid.
  /// * NOT_FOUND: Entitlement resource not found.
  /// * SUSPENSION_NOT_RESELLER_INITIATED: Can only activate reseller-initiated
  /// suspensions and entitlements that have accepted the TOS.
  /// * NOT_SUSPENDED: Can only activate suspended entitlements not in an ACTIVE
  /// state.
  /// * INTERNAL: Any non-user error related to a technical issue in the
  /// backend. Contact Cloud Channel support.
  /// * UNKNOWN: Any non-user error related to a technical issue in the backend.
  /// Contact Cloud Channel support.
  ///
  /// Return value:
  /// The ID of a long-running operation.
  ///
  /// To get the results of the operation, call the GetOperation method of
  /// CloudChannelOperationsService. The Operation metadata will contain an
  /// instance of [OperationMetadata][google.cloud.channel.v1.OperationMetadata].
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.channel.v1.ActivateEntitlementRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.channel.v1.Entitlement] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.channel.v1.ActivateEntitlementRequest]: @googleapis_reference_link{google/cloud/channel/v1/service.proto#L2521}
  /// [google.cloud.channel.v1.Entitlement]: @googleapis_reference_link{google/cloud/channel/v1/entitlements.proto#L32}
  /// [google.cloud.channel.v1.OperationMetadata]: @googleapis_reference_link{google/cloud/channel/v1/operations.proto#L26}
  ///
  // clang-format on
  future<StatusOr<google::cloud::channel::v1::Entitlement>> ActivateEntitlement(
      google::cloud::channel::v1::ActivateEntitlementRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// Transfers customer entitlements to new reseller.
  ///
  /// Possible error codes:
  ///
  /// * PERMISSION_DENIED:
  ///     * The customer doesn't belong to the reseller.
  ///     * The reseller is not authorized to transact on this Product. See
  ///     https://support.google.com/channelservices/answer/9759265
  /// * INVALID_ARGUMENT: Required request parameters are missing or invalid.
  /// * NOT_FOUND: The customer or offer resource was not found.
  /// * ALREADY_EXISTS: The SKU was already transferred for the customer.
  /// * CONDITION_NOT_MET or FAILED_PRECONDITION:
  ///     * The SKU requires domain verification to transfer, but the domain is
  ///     not verified.
  ///     * An Add-On SKU (example, Vault or Drive) is missing the
  ///     pre-requisite SKU (example, G Suite Basic).
  ///     * (Developer accounts only) Reseller and resold domain must meet the
  ///     following naming requirements:
  ///         * Domain names must start with goog-test.
  ///         * Domain names must include the reseller domain.
  ///     * Specify all transferring entitlements.
  /// * INTERNAL: Any non-user error related to a technical issue in the
  /// backend. Contact Cloud Channel support.
  /// * UNKNOWN: Any non-user error related to a technical issue in the backend.
  /// Contact Cloud Channel support.
  ///
  /// Return value:
  /// The ID of a long-running operation.
  ///
  /// To get the results of the operation, call the GetOperation method of
  /// CloudChannelOperationsService. The Operation metadata will contain an
  /// instance of [OperationMetadata][google.cloud.channel.v1.OperationMetadata].
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.channel.v1.TransferEntitlementsRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.channel.v1.TransferEntitlementsResponse] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.channel.v1.OperationMetadata]: @googleapis_reference_link{google/cloud/channel/v1/operations.proto#L26}
  /// [google.cloud.channel.v1.TransferEntitlementsRequest]: @googleapis_reference_link{google/cloud/channel/v1/service.proto#L2277}
  /// [google.cloud.channel.v1.TransferEntitlementsResponse]: @googleapis_reference_link{google/cloud/channel/v1/service.proto#L2311}
  ///
  // clang-format on
  future<StatusOr<google::cloud::channel::v1::TransferEntitlementsResponse>>
  TransferEntitlements(
      google::cloud::channel::v1::TransferEntitlementsRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// Transfers customer entitlements from their current reseller to Google.
  ///
  /// Possible error codes:
  ///
  /// * PERMISSION_DENIED: The customer doesn't belong to the reseller.
  /// * INVALID_ARGUMENT: Required request parameters are missing or invalid.
  /// * NOT_FOUND: The customer or offer resource was not found.
  /// * ALREADY_EXISTS: The SKU was already transferred for the customer.
  /// * CONDITION_NOT_MET or FAILED_PRECONDITION:
  ///     * The SKU requires domain verification to transfer, but the domain is
  ///     not verified.
  ///     * An Add-On SKU (example, Vault or Drive) is missing the
  ///     pre-requisite SKU (example, G Suite Basic).
  ///     * (Developer accounts only) Reseller and resold domain must meet the
  ///     following naming requirements:
  ///         * Domain names must start with goog-test.
  ///         * Domain names must include the reseller domain.
  /// * INTERNAL: Any non-user error related to a technical issue in the
  /// backend. Contact Cloud Channel support.
  /// * UNKNOWN: Any non-user error related to a technical issue in the backend.
  /// Contact Cloud Channel support.
  ///
  /// Return value:
  /// The ID of a long-running operation.
  ///
  /// To get the results of the operation, call the GetOperation method of
  /// CloudChannelOperationsService. The response will contain
  /// google.protobuf.Empty on success. The Operation metadata will contain an
  /// instance of [OperationMetadata][google.cloud.channel.v1.OperationMetadata].
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.channel.v1.TransferEntitlementsToGoogleRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.channel.v1.OperationMetadata] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.channel.v1.OperationMetadata]: @googleapis_reference_link{google/cloud/channel/v1/operations.proto#L26}
  /// [google.cloud.channel.v1.TransferEntitlementsToGoogleRequest]: @googleapis_reference_link{google/cloud/channel/v1/service.proto#L2318}
  ///
  // clang-format on
  future<StatusOr<google::cloud::channel::v1::OperationMetadata>>
  TransferEntitlementsToGoogle(
      google::cloud::channel::v1::TransferEntitlementsToGoogleRequest const&
          request,
      Options opts = {});

  // clang-format off
  ///
  /// List [ChannelPartnerLink][google.cloud.channel.v1.ChannelPartnerLink]s
  /// belonging to a distributor. You must be a distributor to call this method.
  ///
  /// Possible error codes:
  ///
  /// * PERMISSION_DENIED: The reseller account making the request is different
  /// from the reseller account in the API request.
  /// * INVALID_ARGUMENT: Required request parameters are missing or invalid.
  ///
  /// Return value:
  /// The list of the distributor account's
  /// [ChannelPartnerLink][google.cloud.channel.v1.ChannelPartnerLink] resources.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.channel.v1.ListChannelPartnerLinksRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.channel.v1.ChannelPartnerLink], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.channel.v1.ChannelPartnerLink]: @googleapis_reference_link{google/cloud/channel/v1/channel_partner_links.proto#L66}
  /// [google.cloud.channel.v1.ListChannelPartnerLinksRequest]: @googleapis_reference_link{google/cloud/channel/v1/service.proto#L1848}
  ///
  // clang-format on
  StreamRange<google::cloud::channel::v1::ChannelPartnerLink>
  ListChannelPartnerLinks(
      google::cloud::channel::v1::ListChannelPartnerLinksRequest request,
      Options opts = {});

  // clang-format off
  ///
  /// Returns the requested
  /// [ChannelPartnerLink][google.cloud.channel.v1.ChannelPartnerLink] resource.
  /// You must be a distributor to call this method.
  ///
  /// Possible error codes:
  ///
  /// * PERMISSION_DENIED: The reseller account making the request is different
  /// from the reseller account in the API request.
  /// * INVALID_ARGUMENT: Required request parameters are missing or invalid.
  /// * NOT_FOUND: ChannelPartnerLink resource not found because of an
  /// invalid channel partner link name.
  ///
  /// Return value:
  /// The [ChannelPartnerLink][google.cloud.channel.v1.ChannelPartnerLink]
  /// resource.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.channel.v1.GetChannelPartnerLinkRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.channel.v1.ChannelPartnerLink])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.channel.v1.ChannelPartnerLink]: @googleapis_reference_link{google/cloud/channel/v1/channel_partner_links.proto#L66}
  /// [google.cloud.channel.v1.GetChannelPartnerLinkRequest]: @googleapis_reference_link{google/cloud/channel/v1/service.proto#L1885}
  ///
  // clang-format on
  StatusOr<google::cloud::channel::v1::ChannelPartnerLink>
  GetChannelPartnerLink(
      google::cloud::channel::v1::GetChannelPartnerLinkRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// Initiates a channel partner link between a distributor and a reseller, or
  /// between resellers in an n-tier reseller channel.
  /// Invited partners need to follow the invite_link_uri provided in the
  /// response to accept. After accepting the invitation, a link is set up
  /// between the two parties.
  /// You must be a distributor to call this method.
  ///
  /// Possible error codes:
  ///
  /// * PERMISSION_DENIED: The reseller account making the request is different
  /// from the reseller account in the API request.
  /// * INVALID_ARGUMENT: Required request parameters are missing or invalid.
  /// * ALREADY_EXISTS: The ChannelPartnerLink sent in the request already
  /// exists.
  /// * NOT_FOUND: No Cloud Identity customer exists for provided domain.
  /// * INTERNAL: Any non-user error related to a technical issue in the
  /// backend. Contact Cloud Channel support.
  /// * UNKNOWN: Any non-user error related to a technical issue in the backend.
  /// Contact Cloud Channel support.
  ///
  /// Return value:
  /// The new [ChannelPartnerLink][google.cloud.channel.v1.ChannelPartnerLink]
  /// resource.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.channel.v1.CreateChannelPartnerLinkRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.channel.v1.ChannelPartnerLink])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.channel.v1.ChannelPartnerLink]: @googleapis_reference_link{google/cloud/channel/v1/channel_partner_links.proto#L66}
  /// [google.cloud.channel.v1.CreateChannelPartnerLinkRequest]: @googleapis_reference_link{google/cloud/channel/v1/service.proto#L1897}
  ///
  // clang-format on
  StatusOr<google::cloud::channel::v1::ChannelPartnerLink>
  CreateChannelPartnerLink(
      google::cloud::channel::v1::CreateChannelPartnerLinkRequest const&
          request,
      Options opts = {});

  // clang-format off
  ///
  /// Updates a channel partner link. Distributors call this method to change a
  /// link's status. For example, to suspend a partner link.
  /// You must be a distributor to call this method.
  ///
  /// Possible error codes:
  ///
  /// * PERMISSION_DENIED: The reseller account making the request is different
  /// from the reseller account in the API request.
  /// * INVALID_ARGUMENT:
  ///     * Required request parameters are missing or invalid.
  ///     * Link state cannot change from invited to active or suspended.
  ///     * Cannot send reseller_cloud_identity_id, invite_url, or name in update
  ///     mask.
  /// * NOT_FOUND: ChannelPartnerLink resource not found.
  /// * INTERNAL: Any non-user error related to a technical issue in the
  /// backend. Contact Cloud Channel support.
  /// * UNKNOWN: Any non-user error related to a technical issue in the backend.
  /// Contact Cloud Channel support.
  ///
  /// Return value:
  /// The updated
  /// [ChannelPartnerLink][google.cloud.channel.v1.ChannelPartnerLink] resource.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.channel.v1.UpdateChannelPartnerLinkRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.channel.v1.ChannelPartnerLink])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.channel.v1.ChannelPartnerLink]: @googleapis_reference_link{google/cloud/channel/v1/channel_partner_links.proto#L66}
  /// [google.cloud.channel.v1.UpdateChannelPartnerLinkRequest]: @googleapis_reference_link{google/cloud/channel/v1/service.proto#L1912}
  ///
  // clang-format on
  StatusOr<google::cloud::channel::v1::ChannelPartnerLink>
  UpdateChannelPartnerLink(
      google::cloud::channel::v1::UpdateChannelPartnerLinkRequest const&
          request,
      Options opts = {});

  // clang-format off
  ///
  /// Gets information about how a Reseller modifies their bill before sending
  /// it to a Customer.
  ///
  /// Possible Error Codes:
  ///
  /// * PERMISSION_DENIED: If the account making the request and the account
  /// being queried are different.
  /// * NOT_FOUND: The
  /// [CustomerRepricingConfig][google.cloud.channel.v1.CustomerRepricingConfig]
  /// was not found.
  /// * INTERNAL: Any non-user error related to technical issues in the
  /// backend. In this case, contact Cloud Channel support.
  ///
  /// Return Value:
  /// If successful, the
  /// [CustomerRepricingConfig][google.cloud.channel.v1.CustomerRepricingConfig]
  /// resource, otherwise returns an error.
  ///
  /// @param name  Required. The resource name of the CustomerRepricingConfig.
  ///  Format:
  ///  accounts/{account_id}/customers/{customer_id}/customerRepricingConfigs/{id}.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.channel.v1.CustomerRepricingConfig])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.channel.v1.CustomerRepricingConfig]: @googleapis_reference_link{google/cloud/channel/v1/repricing.proto#L46}
  /// [google.cloud.channel.v1.GetCustomerRepricingConfigRequest]: @googleapis_reference_link{google/cloud/channel/v1/service.proto#L1932}
  ///
  // clang-format on
  StatusOr<google::cloud::channel::v1::CustomerRepricingConfig>
  GetCustomerRepricingConfig(std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// Gets information about how a Reseller modifies their bill before sending
  /// it to a Customer.
  ///
  /// Possible Error Codes:
  ///
  /// * PERMISSION_DENIED: If the account making the request and the account
  /// being queried are different.
  /// * NOT_FOUND: The
  /// [CustomerRepricingConfig][google.cloud.channel.v1.CustomerRepricingConfig]
  /// was not found.
  /// * INTERNAL: Any non-user error related to technical issues in the
  /// backend. In this case, contact Cloud Channel support.
  ///
  /// Return Value:
  /// If successful, the
  /// [CustomerRepricingConfig][google.cloud.channel.v1.CustomerRepricingConfig]
  /// resource, otherwise returns an error.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.channel.v1.GetCustomerRepricingConfigRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.channel.v1.CustomerRepricingConfig])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.channel.v1.CustomerRepricingConfig]: @googleapis_reference_link{google/cloud/channel/v1/repricing.proto#L46}
  /// [google.cloud.channel.v1.GetCustomerRepricingConfigRequest]: @googleapis_reference_link{google/cloud/channel/v1/service.proto#L1932}
  ///
  // clang-format on
  StatusOr<google::cloud::channel::v1::CustomerRepricingConfig>
  GetCustomerRepricingConfig(
      google::cloud::channel::v1::GetCustomerRepricingConfigRequest const&
          request,
      Options opts = {});

  // clang-format off
  ///
  /// Lists information about how a Reseller modifies their bill before sending
  /// it to a Customer.
  ///
  /// Possible Error Codes:
  ///
  /// * PERMISSION_DENIED: If the account making the request and the account
  /// being queried are different.
  /// * NOT_FOUND: The
  /// [CustomerRepricingConfig][google.cloud.channel.v1.CustomerRepricingConfig]
  /// specified does not exist or is not associated with the given account.
  /// * INTERNAL: Any non-user error related to technical issues in the
  /// backend. In this case, contact Cloud Channel support.
  ///
  /// Return Value:
  /// If successful, the
  /// [CustomerRepricingConfig][google.cloud.channel.v1.CustomerRepricingConfig]
  /// resources. The data for each resource is displayed in the ascending order
  /// of:
  ///
  /// * Customer ID
  /// * [RepricingConfig.EntitlementGranularity.entitlement][google.cloud.channel.v1.RepricingConfig.EntitlementGranularity.entitlement]
  /// * [RepricingConfig.effective_invoice_month][google.cloud.channel.v1.RepricingConfig.effective_invoice_month]
  /// * [CustomerRepricingConfig.update_time][google.cloud.channel.v1.CustomerRepricingConfig.update_time]
  ///
  /// If unsuccessful, returns an error.
  ///
  /// @param parent  Required. The resource name of the customer.
  ///  Parent uses the format: accounts/{account_id}/customers/{customer_id}.
  ///  Supports accounts/{account_id}/customers/- to retrieve configs for all
  ///  customers.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.channel.v1.CustomerRepricingConfig], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.channel.v1.CustomerRepricingConfig]: @googleapis_reference_link{google/cloud/channel/v1/repricing.proto#L46}
  /// [google.cloud.channel.v1.CustomerRepricingConfig.update_time]: @googleapis_reference_link{google/cloud/channel/v1/repricing.proto#L65}
  /// [google.cloud.channel.v1.ListCustomerRepricingConfigsRequest]: @googleapis_reference_link{google/cloud/channel/v1/service.proto#L1946}
  /// [google.cloud.channel.v1.RepricingConfig.EntitlementGranularity.entitlement]: @googleapis_reference_link{google/cloud/channel/v1/repricing.proto#L101}
  /// [google.cloud.channel.v1.RepricingConfig.effective_invoice_month]: @googleapis_reference_link{google/cloud/channel/v1/repricing.proto#L146}
  ///
  // clang-format on
  StreamRange<google::cloud::channel::v1::CustomerRepricingConfig>
  ListCustomerRepricingConfigs(std::string const& parent, Options opts = {});

  // clang-format off
  ///
  /// Lists information about how a Reseller modifies their bill before sending
  /// it to a Customer.
  ///
  /// Possible Error Codes:
  ///
  /// * PERMISSION_DENIED: If the account making the request and the account
  /// being queried are different.
  /// * NOT_FOUND: The
  /// [CustomerRepricingConfig][google.cloud.channel.v1.CustomerRepricingConfig]
  /// specified does not exist or is not associated with the given account.
  /// * INTERNAL: Any non-user error related to technical issues in the
  /// backend. In this case, contact Cloud Channel support.
  ///
  /// Return Value:
  /// If successful, the
  /// [CustomerRepricingConfig][google.cloud.channel.v1.CustomerRepricingConfig]
  /// resources. The data for each resource is displayed in the ascending order
  /// of:
  ///
  /// * Customer ID
  /// * [RepricingConfig.EntitlementGranularity.entitlement][google.cloud.channel.v1.RepricingConfig.EntitlementGranularity.entitlement]
  /// * [RepricingConfig.effective_invoice_month][google.cloud.channel.v1.RepricingConfig.effective_invoice_month]
  /// * [CustomerRepricingConfig.update_time][google.cloud.channel.v1.CustomerRepricingConfig.update_time]
  ///
  /// If unsuccessful, returns an error.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.channel.v1.ListCustomerRepricingConfigsRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.channel.v1.CustomerRepricingConfig], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.channel.v1.CustomerRepricingConfig]: @googleapis_reference_link{google/cloud/channel/v1/repricing.proto#L46}
  /// [google.cloud.channel.v1.CustomerRepricingConfig.update_time]: @googleapis_reference_link{google/cloud/channel/v1/repricing.proto#L65}
  /// [google.cloud.channel.v1.ListCustomerRepricingConfigsRequest]: @googleapis_reference_link{google/cloud/channel/v1/service.proto#L1946}
  /// [google.cloud.channel.v1.RepricingConfig.EntitlementGranularity.entitlement]: @googleapis_reference_link{google/cloud/channel/v1/repricing.proto#L101}
  /// [google.cloud.channel.v1.RepricingConfig.effective_invoice_month]: @googleapis_reference_link{google/cloud/channel/v1/repricing.proto#L146}
  ///
  // clang-format on
  StreamRange<google::cloud::channel::v1::CustomerRepricingConfig>
  ListCustomerRepricingConfigs(
      google::cloud::channel::v1::ListCustomerRepricingConfigsRequest request,
      Options opts = {});

  // clang-format off
  ///
  /// Creates a CustomerRepricingConfig. Call this method to set modifications
  /// for a specific customer's bill. You can only create configs if the
  /// [RepricingConfig.effective_invoice_month][google.cloud.channel.v1.RepricingConfig.effective_invoice_month]
  /// is a future month. If needed, you can create a config for the current
  /// month, with some restrictions.
  ///
  /// When creating a config for a future month, make sure there are no existing
  /// configs for that
  /// [RepricingConfig.effective_invoice_month][google.cloud.channel.v1.RepricingConfig.effective_invoice_month].
  ///
  /// The following restrictions are for creating configs in the current month.
  ///
  /// * This functionality is reserved for recovering from an erroneous config,
  /// and should not be used for regular business cases.
  /// * The new config will not modify exports used with other configs.
  /// Changes to the config may be immediate, but may take up to 24 hours.
  /// * There is a limit of ten configs for any
  /// [RepricingConfig.EntitlementGranularity.entitlement][google.cloud.channel.v1.RepricingConfig.EntitlementGranularity.entitlement],
  /// for any
  /// [RepricingConfig.effective_invoice_month][google.cloud.channel.v1.RepricingConfig.effective_invoice_month].
  /// * The contained
  /// [CustomerRepricingConfig.repricing_config][google.cloud.channel.v1.CustomerRepricingConfig.repricing_config]
  /// value must be different from the value used in the current config for a
  /// [RepricingConfig.EntitlementGranularity.entitlement][google.cloud.channel.v1.RepricingConfig.EntitlementGranularity.entitlement].
  ///
  /// Possible Error Codes:
  ///
  /// * PERMISSION_DENIED: If the account making the request and the account
  /// being queried are different.
  /// * INVALID_ARGUMENT: Missing or invalid required parameters in the
  /// request. Also displays if the updated config is for the current month or
  /// past months.
  /// * NOT_FOUND: The
  /// [CustomerRepricingConfig][google.cloud.channel.v1.CustomerRepricingConfig]
  /// specified does not exist or is not associated with the given account.
  /// * INTERNAL: Any non-user error related to technical issues in the
  /// backend. In this case, contact Cloud Channel support.
  ///
  /// Return Value:
  /// If successful, the updated
  /// [CustomerRepricingConfig][google.cloud.channel.v1.CustomerRepricingConfig]
  /// resource, otherwise returns an error.
  ///
  /// @param parent  Required. The resource name of the customer that will receive this
  ///  repricing config. Parent uses the format:
  ///  accounts/{account_id}/customers/{customer_id}
  /// @param customer_repricing_config  Required. The CustomerRepricingConfig object to update.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.channel.v1.CustomerRepricingConfig])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.channel.v1.CreateCustomerRepricingConfigRequest]: @googleapis_reference_link{google/cloud/channel/v1/service.proto#L1996}
  /// [google.cloud.channel.v1.CustomerRepricingConfig]: @googleapis_reference_link{google/cloud/channel/v1/repricing.proto#L46}
  /// [google.cloud.channel.v1.CustomerRepricingConfig.repricing_config]: @googleapis_reference_link{google/cloud/channel/v1/repricing.proto#L59}
  /// [google.cloud.channel.v1.RepricingConfig.EntitlementGranularity.entitlement]: @googleapis_reference_link{google/cloud/channel/v1/repricing.proto#L101}
  /// [google.cloud.channel.v1.RepricingConfig.effective_invoice_month]: @googleapis_reference_link{google/cloud/channel/v1/repricing.proto#L146}
  ///
  // clang-format on
  StatusOr<google::cloud::channel::v1::CustomerRepricingConfig>
  CreateCustomerRepricingConfig(
      std::string const& parent,
      google::cloud::channel::v1::CustomerRepricingConfig const&
          customer_repricing_config,
      Options opts = {});

  // clang-format off
  ///
  /// Creates a CustomerRepricingConfig. Call this method to set modifications
  /// for a specific customer's bill. You can only create configs if the
  /// [RepricingConfig.effective_invoice_month][google.cloud.channel.v1.RepricingConfig.effective_invoice_month]
  /// is a future month. If needed, you can create a config for the current
  /// month, with some restrictions.
  ///
  /// When creating a config for a future month, make sure there are no existing
  /// configs for that
  /// [RepricingConfig.effective_invoice_month][google.cloud.channel.v1.RepricingConfig.effective_invoice_month].
  ///
  /// The following restrictions are for creating configs in the current month.
  ///
  /// * This functionality is reserved for recovering from an erroneous config,
  /// and should not be used for regular business cases.
  /// * The new config will not modify exports used with other configs.
  /// Changes to the config may be immediate, but may take up to 24 hours.
  /// * There is a limit of ten configs for any
  /// [RepricingConfig.EntitlementGranularity.entitlement][google.cloud.channel.v1.RepricingConfig.EntitlementGranularity.entitlement],
  /// for any
  /// [RepricingConfig.effective_invoice_month][google.cloud.channel.v1.RepricingConfig.effective_invoice_month].
  /// * The contained
  /// [CustomerRepricingConfig.repricing_config][google.cloud.channel.v1.CustomerRepricingConfig.repricing_config]
  /// value must be different from the value used in the current config for a
  /// [RepricingConfig.EntitlementGranularity.entitlement][google.cloud.channel.v1.RepricingConfig.EntitlementGranularity.entitlement].
  ///
  /// Possible Error Codes:
  ///
  /// * PERMISSION_DENIED: If the account making the request and the account
  /// being queried are different.
  /// * INVALID_ARGUMENT: Missing or invalid required parameters in the
  /// request. Also displays if the updated config is for the current month or
  /// past months.
  /// * NOT_FOUND: The
  /// [CustomerRepricingConfig][google.cloud.channel.v1.CustomerRepricingConfig]
  /// specified does not exist or is not associated with the given account.
  /// * INTERNAL: Any non-user error related to technical issues in the
  /// backend. In this case, contact Cloud Channel support.
  ///
  /// Return Value:
  /// If successful, the updated
  /// [CustomerRepricingConfig][google.cloud.channel.v1.CustomerRepricingConfig]
  /// resource, otherwise returns an error.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.channel.v1.CreateCustomerRepricingConfigRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.channel.v1.CustomerRepricingConfig])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.channel.v1.CreateCustomerRepricingConfigRequest]: @googleapis_reference_link{google/cloud/channel/v1/service.proto#L1996}
  /// [google.cloud.channel.v1.CustomerRepricingConfig]: @googleapis_reference_link{google/cloud/channel/v1/repricing.proto#L46}
  /// [google.cloud.channel.v1.CustomerRepricingConfig.repricing_config]: @googleapis_reference_link{google/cloud/channel/v1/repricing.proto#L59}
  /// [google.cloud.channel.v1.RepricingConfig.EntitlementGranularity.entitlement]: @googleapis_reference_link{google/cloud/channel/v1/repricing.proto#L101}
  /// [google.cloud.channel.v1.RepricingConfig.effective_invoice_month]: @googleapis_reference_link{google/cloud/channel/v1/repricing.proto#L146}
  ///
  // clang-format on
  StatusOr<google::cloud::channel::v1::CustomerRepricingConfig>
  CreateCustomerRepricingConfig(
      google::cloud::channel::v1::CreateCustomerRepricingConfigRequest const&
          request,
      Options opts = {});

  // clang-format off
  ///
  /// Updates a CustomerRepricingConfig. Call this method to set modifications
  /// for a specific customer's bill. This method overwrites the existing
  /// CustomerRepricingConfig.
  ///
  /// You can only update configs if the
  /// [RepricingConfig.effective_invoice_month][google.cloud.channel.v1.RepricingConfig.effective_invoice_month]
  /// is a future month. To make changes to configs for the current month, use
  /// [CreateCustomerRepricingConfig][google.cloud.channel.v1.CloudChannelService.CreateCustomerRepricingConfig],
  /// taking note of its restrictions. You cannot update the
  /// [RepricingConfig.effective_invoice_month][google.cloud.channel.v1.RepricingConfig.effective_invoice_month].
  ///
  /// When updating a config in the future:
  ///
  /// * This config must already exist.
  ///
  /// Possible Error Codes:
  ///
  /// * PERMISSION_DENIED: If the account making the request and the account
  /// being queried are different.
  /// * INVALID_ARGUMENT: Missing or invalid required parameters in the
  /// request. Also displays if the updated config is for the current month or
  /// past months.
  /// * NOT_FOUND: The
  /// [CustomerRepricingConfig][google.cloud.channel.v1.CustomerRepricingConfig]
  /// specified does not exist or is not associated with the given account.
  /// * INTERNAL: Any non-user error related to technical issues in the
  /// backend. In this case, contact Cloud Channel support.
  ///
  /// Return Value:
  /// If successful, the updated
  /// [CustomerRepricingConfig][google.cloud.channel.v1.CustomerRepricingConfig]
  /// resource, otherwise returns an error.
  ///
  /// @param customer_repricing_config  Required. The CustomerRepricingConfig object to update.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.channel.v1.CustomerRepricingConfig])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.channel.v1.CloudChannelService.CreateCustomerRepricingConfig]: @googleapis_reference_link{google/cloud/channel/v1/service.proto#L953}
  /// [google.cloud.channel.v1.CustomerRepricingConfig]: @googleapis_reference_link{google/cloud/channel/v1/repricing.proto#L46}
  /// [google.cloud.channel.v1.RepricingConfig.effective_invoice_month]: @googleapis_reference_link{google/cloud/channel/v1/repricing.proto#L146}
  /// [google.cloud.channel.v1.UpdateCustomerRepricingConfigRequest]: @googleapis_reference_link{google/cloud/channel/v1/service.proto#L2014}
  ///
  // clang-format on
  StatusOr<google::cloud::channel::v1::CustomerRepricingConfig>
  UpdateCustomerRepricingConfig(
      google::cloud::channel::v1::CustomerRepricingConfig const&
          customer_repricing_config,
      Options opts = {});

  // clang-format off
  ///
  /// Updates a CustomerRepricingConfig. Call this method to set modifications
  /// for a specific customer's bill. This method overwrites the existing
  /// CustomerRepricingConfig.
  ///
  /// You can only update configs if the
  /// [RepricingConfig.effective_invoice_month][google.cloud.channel.v1.RepricingConfig.effective_invoice_month]
  /// is a future month. To make changes to configs for the current month, use
  /// [CreateCustomerRepricingConfig][google.cloud.channel.v1.CloudChannelService.CreateCustomerRepricingConfig],
  /// taking note of its restrictions. You cannot update the
  /// [RepricingConfig.effective_invoice_month][google.cloud.channel.v1.RepricingConfig.effective_invoice_month].
  ///
  /// When updating a config in the future:
  ///
  /// * This config must already exist.
  ///
  /// Possible Error Codes:
  ///
  /// * PERMISSION_DENIED: If the account making the request and the account
  /// being queried are different.
  /// * INVALID_ARGUMENT: Missing or invalid required parameters in the
  /// request. Also displays if the updated config is for the current month or
  /// past months.
  /// * NOT_FOUND: The
  /// [CustomerRepricingConfig][google.cloud.channel.v1.CustomerRepricingConfig]
  /// specified does not exist or is not associated with the given account.
  /// * INTERNAL: Any non-user error related to technical issues in the
  /// backend. In this case, contact Cloud Channel support.
  ///
  /// Return Value:
  /// If successful, the updated
  /// [CustomerRepricingConfig][google.cloud.channel.v1.CustomerRepricingConfig]
  /// resource, otherwise returns an error.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.channel.v1.UpdateCustomerRepricingConfigRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.channel.v1.CustomerRepricingConfig])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.channel.v1.CloudChannelService.CreateCustomerRepricingConfig]: @googleapis_reference_link{google/cloud/channel/v1/service.proto#L953}
  /// [google.cloud.channel.v1.CustomerRepricingConfig]: @googleapis_reference_link{google/cloud/channel/v1/repricing.proto#L46}
  /// [google.cloud.channel.v1.RepricingConfig.effective_invoice_month]: @googleapis_reference_link{google/cloud/channel/v1/repricing.proto#L146}
  /// [google.cloud.channel.v1.UpdateCustomerRepricingConfigRequest]: @googleapis_reference_link{google/cloud/channel/v1/service.proto#L2014}
  ///
  // clang-format on
  StatusOr<google::cloud::channel::v1::CustomerRepricingConfig>
  UpdateCustomerRepricingConfig(
      google::cloud::channel::v1::UpdateCustomerRepricingConfigRequest const&
          request,
      Options opts = {});

  // clang-format off
  ///
  /// Deletes the given
  /// [CustomerRepricingConfig][google.cloud.channel.v1.CustomerRepricingConfig]
  /// permanently. You can only delete configs if their
  /// [RepricingConfig.effective_invoice_month][google.cloud.channel.v1.RepricingConfig.effective_invoice_month]
  /// is set to a date after the current month.
  ///
  /// Possible error codes:
  ///
  /// * PERMISSION_DENIED: The account making the request does not own
  /// this customer.
  /// * INVALID_ARGUMENT: Required request parameters are missing or invalid.
  /// * FAILED_PRECONDITION: The
  /// [CustomerRepricingConfig][google.cloud.channel.v1.CustomerRepricingConfig]
  /// is active or in the past.
  /// * NOT_FOUND: No
  /// [CustomerRepricingConfig][google.cloud.channel.v1.CustomerRepricingConfig]
  /// found for the name in the request.
  ///
  /// @param name  Required. The resource name of the customer repricing config rule to
  ///  delete. Format:
  ///  accounts/{account_id}/customers/{customer_id}/customerRepricingConfigs/{id}.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [`Status`] object. If the request failed, the
  ///     status contains the details of the failure.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.channel.v1.CustomerRepricingConfig]: @googleapis_reference_link{google/cloud/channel/v1/repricing.proto#L46}
  /// [google.cloud.channel.v1.DeleteCustomerRepricingConfigRequest]: @googleapis_reference_link{google/cloud/channel/v1/service.proto#L2022}
  /// [google.cloud.channel.v1.RepricingConfig.effective_invoice_month]: @googleapis_reference_link{google/cloud/channel/v1/repricing.proto#L146}
  ///
  // clang-format on
  Status DeleteCustomerRepricingConfig(std::string const& name,
                                       Options opts = {});

  // clang-format off
  ///
  /// Deletes the given
  /// [CustomerRepricingConfig][google.cloud.channel.v1.CustomerRepricingConfig]
  /// permanently. You can only delete configs if their
  /// [RepricingConfig.effective_invoice_month][google.cloud.channel.v1.RepricingConfig.effective_invoice_month]
  /// is set to a date after the current month.
  ///
  /// Possible error codes:
  ///
  /// * PERMISSION_DENIED: The account making the request does not own
  /// this customer.
  /// * INVALID_ARGUMENT: Required request parameters are missing or invalid.
  /// * FAILED_PRECONDITION: The
  /// [CustomerRepricingConfig][google.cloud.channel.v1.CustomerRepricingConfig]
  /// is active or in the past.
  /// * NOT_FOUND: No
  /// [CustomerRepricingConfig][google.cloud.channel.v1.CustomerRepricingConfig]
  /// found for the name in the request.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.channel.v1.DeleteCustomerRepricingConfigRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [`Status`] object. If the request failed, the
  ///     status contains the details of the failure.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.channel.v1.CustomerRepricingConfig]: @googleapis_reference_link{google/cloud/channel/v1/repricing.proto#L46}
  /// [google.cloud.channel.v1.DeleteCustomerRepricingConfigRequest]: @googleapis_reference_link{google/cloud/channel/v1/service.proto#L2022}
  /// [google.cloud.channel.v1.RepricingConfig.effective_invoice_month]: @googleapis_reference_link{google/cloud/channel/v1/repricing.proto#L146}
  ///
  // clang-format on
  Status DeleteCustomerRepricingConfig(
      google::cloud::channel::v1::DeleteCustomerRepricingConfigRequest const&
          request,
      Options opts = {});

  // clang-format off
  ///
  /// Gets information about how a Distributor modifies their bill before sending
  /// it to a ChannelPartner.
  ///
  /// Possible Error Codes:
  ///
  /// * PERMISSION_DENIED: If the account making the request and the account
  /// being queried are different.
  /// * NOT_FOUND: The
  /// [ChannelPartnerRepricingConfig][google.cloud.channel.v1.ChannelPartnerRepricingConfig]
  /// was not found.
  /// * INTERNAL: Any non-user error related to technical issues in the
  /// backend. In this case, contact Cloud Channel support.
  ///
  /// Return Value:
  /// If successful, the
  /// [ChannelPartnerRepricingConfig][google.cloud.channel.v1.ChannelPartnerRepricingConfig]
  /// resource, otherwise returns an error.
  ///
  /// @param name  Required. The resource name of the ChannelPartnerRepricingConfig
  ///  Format:
  ///  accounts/{account_id}/channelPartnerLinks/{channel_partner_id}/channelPartnerRepricingConfigs/{id}.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.channel.v1.ChannelPartnerRepricingConfig])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.channel.v1.ChannelPartnerRepricingConfig]: @googleapis_reference_link{google/cloud/channel/v1/repricing.proto#L71}
  /// [google.cloud.channel.v1.GetChannelPartnerRepricingConfigRequest]: @googleapis_reference_link{google/cloud/channel/v1/service.proto#L2036}
  ///
  // clang-format on
  StatusOr<google::cloud::channel::v1::ChannelPartnerRepricingConfig>
  GetChannelPartnerRepricingConfig(std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// Gets information about how a Distributor modifies their bill before sending
  /// it to a ChannelPartner.
  ///
  /// Possible Error Codes:
  ///
  /// * PERMISSION_DENIED: If the account making the request and the account
  /// being queried are different.
  /// * NOT_FOUND: The
  /// [ChannelPartnerRepricingConfig][google.cloud.channel.v1.ChannelPartnerRepricingConfig]
  /// was not found.
  /// * INTERNAL: Any non-user error related to technical issues in the
  /// backend. In this case, contact Cloud Channel support.
  ///
  /// Return Value:
  /// If successful, the
  /// [ChannelPartnerRepricingConfig][google.cloud.channel.v1.ChannelPartnerRepricingConfig]
  /// resource, otherwise returns an error.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.channel.v1.GetChannelPartnerRepricingConfigRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.channel.v1.ChannelPartnerRepricingConfig])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.channel.v1.ChannelPartnerRepricingConfig]: @googleapis_reference_link{google/cloud/channel/v1/repricing.proto#L71}
  /// [google.cloud.channel.v1.GetChannelPartnerRepricingConfigRequest]: @googleapis_reference_link{google/cloud/channel/v1/service.proto#L2036}
  ///
  // clang-format on
  StatusOr<google::cloud::channel::v1::ChannelPartnerRepricingConfig>
  GetChannelPartnerRepricingConfig(
      google::cloud::channel::v1::GetChannelPartnerRepricingConfigRequest const&
          request,
      Options opts = {});

  // clang-format off
  ///
  /// Lists information about how a Reseller modifies their bill before sending
  /// it to a ChannelPartner.
  ///
  /// Possible Error Codes:
  ///
  /// * PERMISSION_DENIED: If the account making the request and the account
  /// being queried are different.
  /// * NOT_FOUND: The
  /// [ChannelPartnerRepricingConfig][google.cloud.channel.v1.ChannelPartnerRepricingConfig]
  /// specified does not exist or is not associated with the given account.
  /// * INTERNAL: Any non-user error related to technical issues in the
  /// backend. In this case, contact Cloud Channel support.
  ///
  /// Return Value:
  /// If successful, the
  /// [ChannelPartnerRepricingConfig][google.cloud.channel.v1.ChannelPartnerRepricingConfig]
  /// resources. The data for each resource is displayed in the ascending order
  /// of:
  ///
  /// * Channel Partner ID
  /// * [RepricingConfig.effective_invoice_month][google.cloud.channel.v1.RepricingConfig.effective_invoice_month]
  /// * [ChannelPartnerRepricingConfig.update_time][google.cloud.channel.v1.ChannelPartnerRepricingConfig.update_time]
  ///
  /// If unsuccessful, returns an error.
  ///
  /// @param parent  Required. The resource name of the account's
  ///  [ChannelPartnerLink][google.cloud.channel.v1.ChannelPartnerLink]. Parent
  ///  uses the format:
  ///  accounts/{account_id}/channelPartnerLinks/{channel_partner_id}.
  ///  Supports accounts/{account_id}/channelPartnerLinks/- to retrieve configs
  ///  for all channel partners.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.channel.v1.ChannelPartnerRepricingConfig], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.channel.v1.ChannelPartnerRepricingConfig]: @googleapis_reference_link{google/cloud/channel/v1/repricing.proto#L71}
  /// [google.cloud.channel.v1.ChannelPartnerRepricingConfig.update_time]: @googleapis_reference_link{google/cloud/channel/v1/repricing.proto#L90}
  /// [google.cloud.channel.v1.ListChannelPartnerRepricingConfigsRequest]: @googleapis_reference_link{google/cloud/channel/v1/service.proto#L2050}
  /// [google.cloud.channel.v1.RepricingConfig.effective_invoice_month]: @googleapis_reference_link{google/cloud/channel/v1/repricing.proto#L146}
  ///
  // clang-format on
  StreamRange<google::cloud::channel::v1::ChannelPartnerRepricingConfig>
  ListChannelPartnerRepricingConfigs(std::string const& parent,
                                     Options opts = {});

  // clang-format off
  ///
  /// Lists information about how a Reseller modifies their bill before sending
  /// it to a ChannelPartner.
  ///
  /// Possible Error Codes:
  ///
  /// * PERMISSION_DENIED: If the account making the request and the account
  /// being queried are different.
  /// * NOT_FOUND: The
  /// [ChannelPartnerRepricingConfig][google.cloud.channel.v1.ChannelPartnerRepricingConfig]
  /// specified does not exist or is not associated with the given account.
  /// * INTERNAL: Any non-user error related to technical issues in the
  /// backend. In this case, contact Cloud Channel support.
  ///
  /// Return Value:
  /// If successful, the
  /// [ChannelPartnerRepricingConfig][google.cloud.channel.v1.ChannelPartnerRepricingConfig]
  /// resources. The data for each resource is displayed in the ascending order
  /// of:
  ///
  /// * Channel Partner ID
  /// * [RepricingConfig.effective_invoice_month][google.cloud.channel.v1.RepricingConfig.effective_invoice_month]
  /// * [ChannelPartnerRepricingConfig.update_time][google.cloud.channel.v1.ChannelPartnerRepricingConfig.update_time]
  ///
  /// If unsuccessful, returns an error.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.channel.v1.ListChannelPartnerRepricingConfigsRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.channel.v1.ChannelPartnerRepricingConfig], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.channel.v1.ChannelPartnerRepricingConfig]: @googleapis_reference_link{google/cloud/channel/v1/repricing.proto#L71}
  /// [google.cloud.channel.v1.ChannelPartnerRepricingConfig.update_time]: @googleapis_reference_link{google/cloud/channel/v1/repricing.proto#L90}
  /// [google.cloud.channel.v1.ListChannelPartnerRepricingConfigsRequest]: @googleapis_reference_link{google/cloud/channel/v1/service.proto#L2050}
  /// [google.cloud.channel.v1.RepricingConfig.effective_invoice_month]: @googleapis_reference_link{google/cloud/channel/v1/repricing.proto#L146}
  ///
  // clang-format on
  StreamRange<google::cloud::channel::v1::ChannelPartnerRepricingConfig>
  ListChannelPartnerRepricingConfigs(
      google::cloud::channel::v1::ListChannelPartnerRepricingConfigsRequest
          request,
      Options opts = {});

  // clang-format off
  ///
  /// Creates a ChannelPartnerRepricingConfig. Call this method to set
  /// modifications for a specific ChannelPartner's bill. You can only create
  /// configs if the
  /// [RepricingConfig.effective_invoice_month][google.cloud.channel.v1.RepricingConfig.effective_invoice_month]
  /// is a future month. If needed, you can create a config for the current
  /// month, with some restrictions.
  ///
  /// When creating a config for a future month, make sure there are no existing
  /// configs for that
  /// [RepricingConfig.effective_invoice_month][google.cloud.channel.v1.RepricingConfig.effective_invoice_month].
  ///
  /// The following restrictions are for creating configs in the current month.
  ///
  /// * This functionality is reserved for recovering from an erroneous config,
  /// and should not be used for regular business cases.
  /// * The new config will not modify exports used with other configs.
  /// Changes to the config may be immediate, but may take up to 24 hours.
  /// * There is a limit of ten configs for any ChannelPartner or
  /// [RepricingConfig.EntitlementGranularity.entitlement][google.cloud.channel.v1.RepricingConfig.EntitlementGranularity.entitlement],
  /// for any
  /// [RepricingConfig.effective_invoice_month][google.cloud.channel.v1.RepricingConfig.effective_invoice_month].
  /// * The contained
  /// [ChannelPartnerRepricingConfig.repricing_config][google.cloud.channel.v1.ChannelPartnerRepricingConfig.repricing_config]
  /// value must be different from the value used in the current config for a
  /// ChannelPartner.
  ///
  /// Possible Error Codes:
  ///
  /// * PERMISSION_DENIED: If the account making the request and the account
  /// being queried are different.
  /// * INVALID_ARGUMENT: Missing or invalid required parameters in the
  /// request. Also displays if the updated config is for the current month or
  /// past months.
  /// * NOT_FOUND: The
  /// [ChannelPartnerRepricingConfig][google.cloud.channel.v1.ChannelPartnerRepricingConfig]
  /// specified does not exist or is not associated with the given account.
  /// * INTERNAL: Any non-user error related to technical issues in the
  /// backend. In this case, contact Cloud Channel support.
  ///
  /// Return Value:
  /// If successful, the updated
  /// [ChannelPartnerRepricingConfig][google.cloud.channel.v1.ChannelPartnerRepricingConfig]
  /// resource, otherwise returns an error.
  ///
  /// @param parent  Required. The resource name of the ChannelPartner that will receive the
  ///  repricing config. Parent uses the format:
  ///  accounts/{account_id}/channelPartnerLinks/{channel_partner_id}
  /// @param channel_partner_repricing_config  Required. The ChannelPartnerRepricingConfig object to update.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.channel.v1.ChannelPartnerRepricingConfig])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.channel.v1.ChannelPartnerRepricingConfig]: @googleapis_reference_link{google/cloud/channel/v1/repricing.proto#L71}
  /// [google.cloud.channel.v1.ChannelPartnerRepricingConfig.repricing_config]: @googleapis_reference_link{google/cloud/channel/v1/repricing.proto#L84}
  /// [google.cloud.channel.v1.CreateChannelPartnerRepricingConfigRequest]: @googleapis_reference_link{google/cloud/channel/v1/service.proto#L2104}
  /// [google.cloud.channel.v1.RepricingConfig.EntitlementGranularity.entitlement]: @googleapis_reference_link{google/cloud/channel/v1/repricing.proto#L101}
  /// [google.cloud.channel.v1.RepricingConfig.effective_invoice_month]: @googleapis_reference_link{google/cloud/channel/v1/repricing.proto#L146}
  ///
  // clang-format on
  StatusOr<google::cloud::channel::v1::ChannelPartnerRepricingConfig>
  CreateChannelPartnerRepricingConfig(
      std::string const& parent,
      google::cloud::channel::v1::ChannelPartnerRepricingConfig const&
          channel_partner_repricing_config,
      Options opts = {});

  // clang-format off
  ///
  /// Creates a ChannelPartnerRepricingConfig. Call this method to set
  /// modifications for a specific ChannelPartner's bill. You can only create
  /// configs if the
  /// [RepricingConfig.effective_invoice_month][google.cloud.channel.v1.RepricingConfig.effective_invoice_month]
  /// is a future month. If needed, you can create a config for the current
  /// month, with some restrictions.
  ///
  /// When creating a config for a future month, make sure there are no existing
  /// configs for that
  /// [RepricingConfig.effective_invoice_month][google.cloud.channel.v1.RepricingConfig.effective_invoice_month].
  ///
  /// The following restrictions are for creating configs in the current month.
  ///
  /// * This functionality is reserved for recovering from an erroneous config,
  /// and should not be used for regular business cases.
  /// * The new config will not modify exports used with other configs.
  /// Changes to the config may be immediate, but may take up to 24 hours.
  /// * There is a limit of ten configs for any ChannelPartner or
  /// [RepricingConfig.EntitlementGranularity.entitlement][google.cloud.channel.v1.RepricingConfig.EntitlementGranularity.entitlement],
  /// for any
  /// [RepricingConfig.effective_invoice_month][google.cloud.channel.v1.RepricingConfig.effective_invoice_month].
  /// * The contained
  /// [ChannelPartnerRepricingConfig.repricing_config][google.cloud.channel.v1.ChannelPartnerRepricingConfig.repricing_config]
  /// value must be different from the value used in the current config for a
  /// ChannelPartner.
  ///
  /// Possible Error Codes:
  ///
  /// * PERMISSION_DENIED: If the account making the request and the account
  /// being queried are different.
  /// * INVALID_ARGUMENT: Missing or invalid required parameters in the
  /// request. Also displays if the updated config is for the current month or
  /// past months.
  /// * NOT_FOUND: The
  /// [ChannelPartnerRepricingConfig][google.cloud.channel.v1.ChannelPartnerRepricingConfig]
  /// specified does not exist or is not associated with the given account.
  /// * INTERNAL: Any non-user error related to technical issues in the
  /// backend. In this case, contact Cloud Channel support.
  ///
  /// Return Value:
  /// If successful, the updated
  /// [ChannelPartnerRepricingConfig][google.cloud.channel.v1.ChannelPartnerRepricingConfig]
  /// resource, otherwise returns an error.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.channel.v1.CreateChannelPartnerRepricingConfigRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.channel.v1.ChannelPartnerRepricingConfig])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.channel.v1.ChannelPartnerRepricingConfig]: @googleapis_reference_link{google/cloud/channel/v1/repricing.proto#L71}
  /// [google.cloud.channel.v1.ChannelPartnerRepricingConfig.repricing_config]: @googleapis_reference_link{google/cloud/channel/v1/repricing.proto#L84}
  /// [google.cloud.channel.v1.CreateChannelPartnerRepricingConfigRequest]: @googleapis_reference_link{google/cloud/channel/v1/service.proto#L2104}
  /// [google.cloud.channel.v1.RepricingConfig.EntitlementGranularity.entitlement]: @googleapis_reference_link{google/cloud/channel/v1/repricing.proto#L101}
  /// [google.cloud.channel.v1.RepricingConfig.effective_invoice_month]: @googleapis_reference_link{google/cloud/channel/v1/repricing.proto#L146}
  ///
  // clang-format on
  StatusOr<google::cloud::channel::v1::ChannelPartnerRepricingConfig>
  CreateChannelPartnerRepricingConfig(
      google::cloud::channel::v1::
          CreateChannelPartnerRepricingConfigRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// Updates a ChannelPartnerRepricingConfig. Call this method to set
  /// modifications for a specific ChannelPartner's bill. This method overwrites
  /// the existing CustomerRepricingConfig.
  ///
  /// You can only update configs if the
  /// [RepricingConfig.effective_invoice_month][google.cloud.channel.v1.RepricingConfig.effective_invoice_month]
  /// is a future month. To make changes to configs for the current month, use
  /// [CreateChannelPartnerRepricingConfig][google.cloud.channel.v1.CloudChannelService.CreateChannelPartnerRepricingConfig],
  /// taking note of its restrictions. You cannot update the
  /// [RepricingConfig.effective_invoice_month][google.cloud.channel.v1.RepricingConfig.effective_invoice_month].
  ///
  /// When updating a config in the future:
  ///
  /// * This config must already exist.
  ///
  /// Possible Error Codes:
  ///
  /// * PERMISSION_DENIED: If the account making the request and the account
  /// being queried are different.
  /// * INVALID_ARGUMENT: Missing or invalid required parameters in the
  /// request. Also displays if the updated config is for the current month or
  /// past months.
  /// * NOT_FOUND: The
  /// [ChannelPartnerRepricingConfig][google.cloud.channel.v1.ChannelPartnerRepricingConfig]
  /// specified does not exist or is not associated with the given account.
  /// * INTERNAL: Any non-user error related to technical issues in the
  /// backend. In this case, contact Cloud Channel support.
  ///
  /// Return Value:
  /// If successful, the updated
  /// [ChannelPartnerRepricingConfig][google.cloud.channel.v1.ChannelPartnerRepricingConfig]
  /// resource, otherwise returns an error.
  ///
  /// @param channel_partner_repricing_config  Required. The ChannelPartnerRepricingConfig object to update.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.channel.v1.ChannelPartnerRepricingConfig])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.channel.v1.ChannelPartnerRepricingConfig]: @googleapis_reference_link{google/cloud/channel/v1/repricing.proto#L71}
  /// [google.cloud.channel.v1.CloudChannelService.CreateChannelPartnerRepricingConfig]: @googleapis_reference_link{google/cloud/channel/v1/service.proto#L1129}
  /// [google.cloud.channel.v1.RepricingConfig.effective_invoice_month]: @googleapis_reference_link{google/cloud/channel/v1/repricing.proto#L146}
  /// [google.cloud.channel.v1.UpdateChannelPartnerRepricingConfigRequest]: @googleapis_reference_link{google/cloud/channel/v1/service.proto#L2122}
  ///
  // clang-format on
  StatusOr<google::cloud::channel::v1::ChannelPartnerRepricingConfig>
  UpdateChannelPartnerRepricingConfig(
      google::cloud::channel::v1::ChannelPartnerRepricingConfig const&
          channel_partner_repricing_config,
      Options opts = {});

  // clang-format off
  ///
  /// Updates a ChannelPartnerRepricingConfig. Call this method to set
  /// modifications for a specific ChannelPartner's bill. This method overwrites
  /// the existing CustomerRepricingConfig.
  ///
  /// You can only update configs if the
  /// [RepricingConfig.effective_invoice_month][google.cloud.channel.v1.RepricingConfig.effective_invoice_month]
  /// is a future month. To make changes to configs for the current month, use
  /// [CreateChannelPartnerRepricingConfig][google.cloud.channel.v1.CloudChannelService.CreateChannelPartnerRepricingConfig],
  /// taking note of its restrictions. You cannot update the
  /// [RepricingConfig.effective_invoice_month][google.cloud.channel.v1.RepricingConfig.effective_invoice_month].
  ///
  /// When updating a config in the future:
  ///
  /// * This config must already exist.
  ///
  /// Possible Error Codes:
  ///
  /// * PERMISSION_DENIED: If the account making the request and the account
  /// being queried are different.
  /// * INVALID_ARGUMENT: Missing or invalid required parameters in the
  /// request. Also displays if the updated config is for the current month or
  /// past months.
  /// * NOT_FOUND: The
  /// [ChannelPartnerRepricingConfig][google.cloud.channel.v1.ChannelPartnerRepricingConfig]
  /// specified does not exist or is not associated with the given account.
  /// * INTERNAL: Any non-user error related to technical issues in the
  /// backend. In this case, contact Cloud Channel support.
  ///
  /// Return Value:
  /// If successful, the updated
  /// [ChannelPartnerRepricingConfig][google.cloud.channel.v1.ChannelPartnerRepricingConfig]
  /// resource, otherwise returns an error.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.channel.v1.UpdateChannelPartnerRepricingConfigRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.channel.v1.ChannelPartnerRepricingConfig])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.channel.v1.ChannelPartnerRepricingConfig]: @googleapis_reference_link{google/cloud/channel/v1/repricing.proto#L71}
  /// [google.cloud.channel.v1.CloudChannelService.CreateChannelPartnerRepricingConfig]: @googleapis_reference_link{google/cloud/channel/v1/service.proto#L1129}
  /// [google.cloud.channel.v1.RepricingConfig.effective_invoice_month]: @googleapis_reference_link{google/cloud/channel/v1/repricing.proto#L146}
  /// [google.cloud.channel.v1.UpdateChannelPartnerRepricingConfigRequest]: @googleapis_reference_link{google/cloud/channel/v1/service.proto#L2122}
  ///
  // clang-format on
  StatusOr<google::cloud::channel::v1::ChannelPartnerRepricingConfig>
  UpdateChannelPartnerRepricingConfig(
      google::cloud::channel::v1::
          UpdateChannelPartnerRepricingConfigRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// Deletes the given
  /// [ChannelPartnerRepricingConfig][google.cloud.channel.v1.ChannelPartnerRepricingConfig]
  /// permanently. You can only delete configs if their
  /// [RepricingConfig.effective_invoice_month][google.cloud.channel.v1.RepricingConfig.effective_invoice_month]
  /// is set to a date after the current month.
  ///
  /// Possible error codes:
  ///
  /// * PERMISSION_DENIED: The account making the request does not own
  /// this customer.
  /// * INVALID_ARGUMENT: Required request parameters are missing or invalid.
  /// * FAILED_PRECONDITION: The
  /// [ChannelPartnerRepricingConfig][google.cloud.channel.v1.ChannelPartnerRepricingConfig]
  /// is active or in the past.
  /// * NOT_FOUND: No
  /// [ChannelPartnerRepricingConfig][google.cloud.channel.v1.ChannelPartnerRepricingConfig]
  /// found for the name in the request.
  ///
  /// @param name  Required. The resource name of the channel partner repricing config rule to
  ///  delete.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [`Status`] object. If the request failed, the
  ///     status contains the details of the failure.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.channel.v1.ChannelPartnerRepricingConfig]: @googleapis_reference_link{google/cloud/channel/v1/repricing.proto#L71}
  /// [google.cloud.channel.v1.DeleteChannelPartnerRepricingConfigRequest]: @googleapis_reference_link{google/cloud/channel/v1/service.proto#L2129}
  /// [google.cloud.channel.v1.RepricingConfig.effective_invoice_month]: @googleapis_reference_link{google/cloud/channel/v1/repricing.proto#L146}
  ///
  // clang-format on
  Status DeleteChannelPartnerRepricingConfig(std::string const& name,
                                             Options opts = {});

  // clang-format off
  ///
  /// Deletes the given
  /// [ChannelPartnerRepricingConfig][google.cloud.channel.v1.ChannelPartnerRepricingConfig]
  /// permanently. You can only delete configs if their
  /// [RepricingConfig.effective_invoice_month][google.cloud.channel.v1.RepricingConfig.effective_invoice_month]
  /// is set to a date after the current month.
  ///
  /// Possible error codes:
  ///
  /// * PERMISSION_DENIED: The account making the request does not own
  /// this customer.
  /// * INVALID_ARGUMENT: Required request parameters are missing or invalid.
  /// * FAILED_PRECONDITION: The
  /// [ChannelPartnerRepricingConfig][google.cloud.channel.v1.ChannelPartnerRepricingConfig]
  /// is active or in the past.
  /// * NOT_FOUND: No
  /// [ChannelPartnerRepricingConfig][google.cloud.channel.v1.ChannelPartnerRepricingConfig]
  /// found for the name in the request.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.channel.v1.DeleteChannelPartnerRepricingConfigRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [`Status`] object. If the request failed, the
  ///     status contains the details of the failure.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.channel.v1.ChannelPartnerRepricingConfig]: @googleapis_reference_link{google/cloud/channel/v1/repricing.proto#L71}
  /// [google.cloud.channel.v1.DeleteChannelPartnerRepricingConfigRequest]: @googleapis_reference_link{google/cloud/channel/v1/service.proto#L2129}
  /// [google.cloud.channel.v1.RepricingConfig.effective_invoice_month]: @googleapis_reference_link{google/cloud/channel/v1/repricing.proto#L146}
  ///
  // clang-format on
  Status DeleteChannelPartnerRepricingConfig(
      google::cloud::channel::v1::
          DeleteChannelPartnerRepricingConfigRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// Lists the Rebilling supported SKU groups the account is authorized to
  /// sell.
  /// Reference: https://cloud.google.com/skus/sku-groups
  ///
  /// Possible Error Codes:
  ///
  /// * PERMISSION_DENIED: If the account making the request and the account
  /// being queried are different, or the account doesn't exist.
  /// * INTERNAL: Any non-user error related to technical issues in the
  /// backend. In this case, contact Cloud Channel support.
  ///
  /// Return Value:
  /// If successful, the [SkuGroup][google.cloud.channel.v1.SkuGroup] resources.
  /// The data for each resource is displayed in the alphabetical order of SKU
  /// group display name.
  /// The data for each resource is displayed in the ascending order of
  /// [SkuGroup.display_name][google.cloud.channel.v1.SkuGroup.display_name]
  ///
  /// If unsuccessful, returns an error.
  ///
  /// @param parent  Required. The resource name of the account from which to list SKU groups.
  ///  Parent uses the format: accounts/{account}.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.channel.v1.SkuGroup], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.channel.v1.ListSkuGroupsRequest]: @googleapis_reference_link{google/cloud/channel/v1/service.proto#L2141}
  /// [google.cloud.channel.v1.SkuGroup]: @googleapis_reference_link{google/cloud/channel/v1/service.proto#L2207}
  /// [google.cloud.channel.v1.SkuGroup.display_name]: @googleapis_reference_link{google/cloud/channel/v1/service.proto#L2220}
  ///
  // clang-format on
  StreamRange<google::cloud::channel::v1::SkuGroup> ListSkuGroups(
      std::string const& parent, Options opts = {});

  // clang-format off
  ///
  /// Lists the Rebilling supported SKU groups the account is authorized to
  /// sell.
  /// Reference: https://cloud.google.com/skus/sku-groups
  ///
  /// Possible Error Codes:
  ///
  /// * PERMISSION_DENIED: If the account making the request and the account
  /// being queried are different, or the account doesn't exist.
  /// * INTERNAL: Any non-user error related to technical issues in the
  /// backend. In this case, contact Cloud Channel support.
  ///
  /// Return Value:
  /// If successful, the [SkuGroup][google.cloud.channel.v1.SkuGroup] resources.
  /// The data for each resource is displayed in the alphabetical order of SKU
  /// group display name.
  /// The data for each resource is displayed in the ascending order of
  /// [SkuGroup.display_name][google.cloud.channel.v1.SkuGroup.display_name]
  ///
  /// If unsuccessful, returns an error.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.channel.v1.ListSkuGroupsRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.channel.v1.SkuGroup], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.channel.v1.ListSkuGroupsRequest]: @googleapis_reference_link{google/cloud/channel/v1/service.proto#L2141}
  /// [google.cloud.channel.v1.SkuGroup]: @googleapis_reference_link{google/cloud/channel/v1/service.proto#L2207}
  /// [google.cloud.channel.v1.SkuGroup.display_name]: @googleapis_reference_link{google/cloud/channel/v1/service.proto#L2220}
  ///
  // clang-format on
  StreamRange<google::cloud::channel::v1::SkuGroup> ListSkuGroups(
      google::cloud::channel::v1::ListSkuGroupsRequest request,
      Options opts = {});

  // clang-format off
  ///
  /// Lists the Billable SKUs in a given SKU group.
  ///
  /// Possible error codes:
  /// PERMISSION_DENIED: If the account making the request and the account
  /// being queried for are different, or the account doesn't exist.
  /// INVALID_ARGUMENT: Missing or invalid required parameters in the
  /// request.
  /// INTERNAL: Any non-user error related to technical issue in the
  /// backend. In this case, contact cloud channel support.
  ///
  /// Return Value:
  /// If successful, the [BillableSku][google.cloud.channel.v1.BillableSku]
  /// resources. The data for each resource is displayed in the ascending order
  /// of:
  ///
  /// * [BillableSku.service_display_name][google.cloud.channel.v1.BillableSku.service_display_name]
  /// * [BillableSku.sku_display_name][google.cloud.channel.v1.BillableSku.sku_display_name]
  ///
  /// If unsuccessful, returns an error.
  ///
  /// @param parent  Required. Resource name of the SKU group.
  ///  Format: accounts/{account}/skuGroups/{sku_group}.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.channel.v1.BillableSku], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.channel.v1.BillableSku]: @googleapis_reference_link{google/cloud/channel/v1/service.proto#L2224}
  /// [google.cloud.channel.v1.BillableSku.service_display_name]: @googleapis_reference_link{google/cloud/channel/v1/service.proto#L2241}
  /// [google.cloud.channel.v1.BillableSku.sku_display_name]: @googleapis_reference_link{google/cloud/channel/v1/service.proto#L2232}
  /// [google.cloud.channel.v1.ListSkuGroupBillableSkusRequest]: @googleapis_reference_link{google/cloud/channel/v1/service.proto#L2161}
  ///
  // clang-format on
  StreamRange<google::cloud::channel::v1::BillableSku> ListSkuGroupBillableSkus(
      std::string const& parent, Options opts = {});

  // clang-format off
  ///
  /// Lists the Billable SKUs in a given SKU group.
  ///
  /// Possible error codes:
  /// PERMISSION_DENIED: If the account making the request and the account
  /// being queried for are different, or the account doesn't exist.
  /// INVALID_ARGUMENT: Missing or invalid required parameters in the
  /// request.
  /// INTERNAL: Any non-user error related to technical issue in the
  /// backend. In this case, contact cloud channel support.
  ///
  /// Return Value:
  /// If successful, the [BillableSku][google.cloud.channel.v1.BillableSku]
  /// resources. The data for each resource is displayed in the ascending order
  /// of:
  ///
  /// * [BillableSku.service_display_name][google.cloud.channel.v1.BillableSku.service_display_name]
  /// * [BillableSku.sku_display_name][google.cloud.channel.v1.BillableSku.sku_display_name]
  ///
  /// If unsuccessful, returns an error.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.channel.v1.ListSkuGroupBillableSkusRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.channel.v1.BillableSku], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.channel.v1.BillableSku]: @googleapis_reference_link{google/cloud/channel/v1/service.proto#L2224}
  /// [google.cloud.channel.v1.BillableSku.service_display_name]: @googleapis_reference_link{google/cloud/channel/v1/service.proto#L2241}
  /// [google.cloud.channel.v1.BillableSku.sku_display_name]: @googleapis_reference_link{google/cloud/channel/v1/service.proto#L2232}
  /// [google.cloud.channel.v1.ListSkuGroupBillableSkusRequest]: @googleapis_reference_link{google/cloud/channel/v1/service.proto#L2161}
  ///
  // clang-format on
  StreamRange<google::cloud::channel::v1::BillableSku> ListSkuGroupBillableSkus(
      google::cloud::channel::v1::ListSkuGroupBillableSkusRequest request,
      Options opts = {});

  // clang-format off
  ///
  /// Returns the requested [Offer][google.cloud.channel.v1.Offer] resource.
  ///
  /// Possible error codes:
  ///
  /// * PERMISSION_DENIED: The entitlement doesn't belong to the reseller.
  /// * INVALID_ARGUMENT: Required request parameters are missing or invalid.
  /// * NOT_FOUND: Entitlement or offer was not found.
  ///
  /// Return value:
  /// The [Offer][google.cloud.channel.v1.Offer] resource.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.channel.v1.LookupOfferRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.channel.v1.Offer])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.channel.v1.LookupOfferRequest]: @googleapis_reference_link{google/cloud/channel/v1/service.proto#L2543}
  /// [google.cloud.channel.v1.Offer]: @googleapis_reference_link{google/cloud/channel/v1/offers.proto#L129}
  ///
  // clang-format on
  StatusOr<google::cloud::channel::v1::Offer> LookupOffer(
      google::cloud::channel::v1::LookupOfferRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// Lists the Products the reseller is authorized to sell.
  ///
  /// Possible error codes:
  ///
  /// * INVALID_ARGUMENT: Required request parameters are missing or invalid.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.channel.v1.ListProductsRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.channel.v1.Product], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.channel.v1.ListProductsRequest]: @googleapis_reference_link{google/cloud/channel/v1/service.proto#L2556}
  /// [google.cloud.channel.v1.Product]: @googleapis_reference_link{google/cloud/channel/v1/products.proto#L37}
  ///
  // clang-format on
  StreamRange<google::cloud::channel::v1::Product> ListProducts(
      google::cloud::channel::v1::ListProductsRequest request,
      Options opts = {});

  // clang-format off
  ///
  /// Lists the SKUs for a product the reseller is authorized to sell.
  ///
  /// Possible error codes:
  ///
  /// * INVALID_ARGUMENT: Required request parameters are missing or invalid.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.channel.v1.ListSkusRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.channel.v1.Sku], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.channel.v1.ListSkusRequest]: @googleapis_reference_link{google/cloud/channel/v1/service.proto#L2585}
  /// [google.cloud.channel.v1.Sku]: @googleapis_reference_link{google/cloud/channel/v1/products.proto#L55}
  ///
  // clang-format on
  StreamRange<google::cloud::channel::v1::Sku> ListSkus(
      google::cloud::channel::v1::ListSkusRequest request, Options opts = {});

  // clang-format off
  ///
  /// Lists the Offers the reseller can sell.
  ///
  /// Possible error codes:
  ///
  /// * INVALID_ARGUMENT: Required request parameters are missing or invalid.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.channel.v1.ListOffersRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.channel.v1.Offer], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.channel.v1.ListOffersRequest]: @googleapis_reference_link{google/cloud/channel/v1/service.proto#L2625}
  /// [google.cloud.channel.v1.Offer]: @googleapis_reference_link{google/cloud/channel/v1/offers.proto#L129}
  ///
  // clang-format on
  StreamRange<google::cloud::channel::v1::Offer> ListOffers(
      google::cloud::channel::v1::ListOffersRequest request, Options opts = {});

  // clang-format off
  ///
  /// Lists the following:
  ///
  /// * SKUs that you can purchase for a customer
  /// * SKUs that you can upgrade or downgrade for an entitlement.
  ///
  /// Possible error codes:
  ///
  /// * PERMISSION_DENIED: The customer doesn't belong to the reseller.
  /// * INVALID_ARGUMENT: Required request parameters are missing or invalid.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.channel.v1.ListPurchasableSkusRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.channel.v1.PurchasableSku], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.channel.v1.ListPurchasableSkusRequest]: @googleapis_reference_link{google/cloud/channel/v1/service.proto#L2667}
  /// [google.cloud.channel.v1.PurchasableSku]: @googleapis_reference_link{google/cloud/channel/v1/service.proto#L2745}
  ///
  // clang-format on
  StreamRange<google::cloud::channel::v1::PurchasableSku> ListPurchasableSkus(
      google::cloud::channel::v1::ListPurchasableSkusRequest request,
      Options opts = {});

  // clang-format off
  ///
  /// Lists the following:
  ///
  /// * Offers that you can purchase for a customer.
  /// * Offers that you can change for an entitlement.
  ///
  /// Possible error codes:
  ///
  /// * PERMISSION_DENIED:
  ///     * The customer doesn't belong to the reseller
  ///     * The reseller is not authorized to transact on this Product. See
  ///     https://support.google.com/channelservices/answer/9759265
  /// * INVALID_ARGUMENT: Required request parameters are missing or invalid.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.channel.v1.ListPurchasableOffersRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.channel.v1.PurchasableOffer], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.channel.v1.ListPurchasableOffersRequest]: @googleapis_reference_link{google/cloud/channel/v1/service.proto#L2751}
  /// [google.cloud.channel.v1.PurchasableOffer]: @googleapis_reference_link{google/cloud/channel/v1/service.proto#L2827}
  ///
  // clang-format on
  StreamRange<google::cloud::channel::v1::PurchasableOffer>
  ListPurchasableOffers(
      google::cloud::channel::v1::ListPurchasableOffersRequest request,
      Options opts = {});

  // clang-format off
  ///
  /// Lists the billing accounts that are eligible to purchase particular SKUs
  /// for a given customer.
  ///
  /// Possible error codes:
  ///
  /// * PERMISSION_DENIED: The customer doesn't belong to the reseller.
  /// * INVALID_ARGUMENT: Required request parameters are missing or invalid.
  ///
  /// Return value:
  /// Based on the provided list of SKUs, returns a list of SKU groups that must
  /// be purchased using the same billing account and the billing accounts
  /// eligible to purchase each SKU group.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.channel.v1.QueryEligibleBillingAccountsRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.channel.v1.QueryEligibleBillingAccountsResponse])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.channel.v1.QueryEligibleBillingAccountsRequest]: @googleapis_reference_link{google/cloud/channel/v1/service.proto#L2833}
  /// [google.cloud.channel.v1.QueryEligibleBillingAccountsResponse]: @googleapis_reference_link{google/cloud/channel/v1/service.proto#L2849}
  ///
  // clang-format on
  StatusOr<google::cloud::channel::v1::QueryEligibleBillingAccountsResponse>
  QueryEligibleBillingAccounts(
      google::cloud::channel::v1::QueryEligibleBillingAccountsRequest const&
          request,
      Options opts = {});

  // clang-format off
  ///
  /// Registers a service account with subscriber privileges on the Cloud Pub/Sub
  /// topic for this Channel Services account. After you create a
  /// subscriber, you get the events through
  /// [SubscriberEvent][google.cloud.channel.v1.SubscriberEvent]
  ///
  /// Possible error codes:
  ///
  /// * PERMISSION_DENIED: The reseller account making the request and the
  /// provided reseller account are different, or the impersonated user
  /// is not a super admin.
  /// * INVALID_ARGUMENT: Required request parameters are missing or invalid.
  /// * INTERNAL: Any non-user error related to a technical issue in the
  /// backend. Contact Cloud Channel support.
  /// * UNKNOWN: Any non-user error related to a technical issue in the backend.
  /// Contact Cloud Channel support.
  ///
  /// Return value:
  /// The topic name with the registered service email address.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.channel.v1.RegisterSubscriberRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.channel.v1.RegisterSubscriberResponse])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.channel.v1.RegisterSubscriberRequest]: @googleapis_reference_link{google/cloud/channel/v1/service.proto#L2875}
  /// [google.cloud.channel.v1.RegisterSubscriberResponse]: @googleapis_reference_link{google/cloud/channel/v1/service.proto#L2885}
  ///
  // clang-format on
  StatusOr<google::cloud::channel::v1::RegisterSubscriberResponse>
  RegisterSubscriber(
      google::cloud::channel::v1::RegisterSubscriberRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// Unregisters a service account with subscriber privileges on the Cloud
  /// Pub/Sub topic created for this Channel Services account. If there are no
  /// service accounts left with subscriber privileges, this deletes the topic.
  /// You can call ListSubscribers to check for these accounts.
  ///
  /// Possible error codes:
  ///
  /// * PERMISSION_DENIED: The reseller account making the request and the
  /// provided reseller account are different, or the impersonated user
  /// is not a super admin.
  /// * INVALID_ARGUMENT: Required request parameters are missing or invalid.
  /// * NOT_FOUND: The topic resource doesn't exist.
  /// * INTERNAL: Any non-user error related to a technical issue in the
  /// backend. Contact Cloud Channel support.
  /// * UNKNOWN: Any non-user error related to a technical issue in the backend.
  /// Contact Cloud Channel support.
  ///
  /// Return value:
  /// The topic name that unregistered the service email address.
  /// Returns a success response if the service email address wasn't registered
  /// with the topic.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.channel.v1.UnregisterSubscriberRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.channel.v1.UnregisterSubscriberResponse])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.channel.v1.UnregisterSubscriberRequest]: @googleapis_reference_link{google/cloud/channel/v1/service.proto#L2891}
  /// [google.cloud.channel.v1.UnregisterSubscriberResponse]: @googleapis_reference_link{google/cloud/channel/v1/service.proto#L2901}
  ///
  // clang-format on
  StatusOr<google::cloud::channel::v1::UnregisterSubscriberResponse>
  UnregisterSubscriber(
      google::cloud::channel::v1::UnregisterSubscriberRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// Lists service accounts with subscriber privileges on the Cloud Pub/Sub
  /// topic created for this Channel Services account.
  ///
  /// Possible error codes:
  ///
  /// * PERMISSION_DENIED: The reseller account making the request and the
  /// provided reseller account are different, or the impersonated user
  /// is not a super admin.
  /// * INVALID_ARGUMENT: Required request parameters are missing or invalid.
  /// * NOT_FOUND: The topic resource doesn't exist.
  /// * INTERNAL: Any non-user error related to a technical issue in the
  /// backend. Contact Cloud Channel support.
  /// * UNKNOWN: Any non-user error related to a technical issue in the backend.
  /// Contact Cloud Channel support.
  ///
  /// Return value:
  /// A list of service email addresses.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.channel.v1.ListSubscribersRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains a
  ///     [`std::string`].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.channel.v1.ListSubscribersRequest]: @googleapis_reference_link{google/cloud/channel/v1/service.proto#L2907}
  ///
  // clang-format on
  StreamRange<std::string> ListSubscribers(
      google::cloud::channel::v1::ListSubscribersRequest request,
      Options opts = {});

  // clang-format off
  ///
  /// List entitlement history.
  ///
  /// Possible error codes:
  ///
  /// * PERMISSION_DENIED: The reseller account making the request and the
  /// provided reseller account are different.
  /// * INVALID_ARGUMENT: Missing or invalid required fields in the request.
  /// * NOT_FOUND: The parent resource doesn't exist. Usually the result of an
  /// invalid name parameter.
  /// * INTERNAL: Any non-user error related to a technical issue in the backend.
  /// In this case, contact CloudChannel support.
  /// * UNKNOWN: Any non-user error related to a technical issue in the backend.
  /// In this case, contact Cloud Channel support.
  ///
  /// Return value:
  /// List of [EntitlementChange][google.cloud.channel.v1.EntitlementChange]s.
  ///
  /// @param parent  Required. The resource name of the entitlement for which to list
  ///  entitlement changes. The `-` wildcard may be used to match entitlements
  ///  across a customer. Formats:
  ///  @n
  ///    * accounts/{account_id}/customers/{customer_id}/entitlements/{entitlement_id}
  ///    * accounts/{account_id}/customers/{customer_id}/entitlements/-
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.channel.v1.EntitlementChange], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.channel.v1.EntitlementChange]: @googleapis_reference_link{google/cloud/channel/v1/entitlement_changes.proto#L30}
  /// [google.cloud.channel.v1.ListEntitlementChangesRequest]: @googleapis_reference_link{google/cloud/channel/v1/service.proto#L2940}
  ///
  // clang-format on
  StreamRange<google::cloud::channel::v1::EntitlementChange>
  ListEntitlementChanges(std::string const& parent, Options opts = {});

  // clang-format off
  ///
  /// List entitlement history.
  ///
  /// Possible error codes:
  ///
  /// * PERMISSION_DENIED: The reseller account making the request and the
  /// provided reseller account are different.
  /// * INVALID_ARGUMENT: Missing or invalid required fields in the request.
  /// * NOT_FOUND: The parent resource doesn't exist. Usually the result of an
  /// invalid name parameter.
  /// * INTERNAL: Any non-user error related to a technical issue in the backend.
  /// In this case, contact CloudChannel support.
  /// * UNKNOWN: Any non-user error related to a technical issue in the backend.
  /// In this case, contact Cloud Channel support.
  ///
  /// Return value:
  /// List of [EntitlementChange][google.cloud.channel.v1.EntitlementChange]s.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.channel.v1.ListEntitlementChangesRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.channel.v1.EntitlementChange], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.channel.v1.EntitlementChange]: @googleapis_reference_link{google/cloud/channel/v1/entitlement_changes.proto#L30}
  /// [google.cloud.channel.v1.ListEntitlementChangesRequest]: @googleapis_reference_link{google/cloud/channel/v1/service.proto#L2940}
  ///
  // clang-format on
  StreamRange<google::cloud::channel::v1::EntitlementChange>
  ListEntitlementChanges(
      google::cloud::channel::v1::ListEntitlementChangesRequest request,
      Options opts = {});

 private:
  std::shared_ptr<CloudChannelServiceConnection> connection_;
  Options options_;
};

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace channel_v1
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_CHANNEL_V1_CLOUD_CHANNEL_CLIENT_H
