// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/monitoring/v3/notification_service.proto

#include "google/cloud/monitoring/v3/notification_channel_connection_idempotency_policy.h"
#include <memory>

namespace google {
namespace cloud {
namespace monitoring_v3 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

using ::google::cloud::Idempotency;

NotificationChannelServiceConnectionIdempotencyPolicy::
    ~NotificationChannelServiceConnectionIdempotencyPolicy() = default;

std::unique_ptr<NotificationChannelServiceConnectionIdempotencyPolicy>
NotificationChannelServiceConnectionIdempotencyPolicy::clone() const {
  return std::make_unique<
      NotificationChannelServiceConnectionIdempotencyPolicy>(*this);
}

Idempotency NotificationChannelServiceConnectionIdempotencyPolicy::
    ListNotificationChannelDescriptors(
        google::monitoring::v3::
            ListNotificationChannelDescriptorsRequest) {  // NOLINT
  return Idempotency::kIdempotent;
}

Idempotency NotificationChannelServiceConnectionIdempotencyPolicy::
    GetNotificationChannelDescriptor(
        google::monitoring::v3::
            GetNotificationChannelDescriptorRequest const&) {
  return Idempotency::kIdempotent;
}

Idempotency
NotificationChannelServiceConnectionIdempotencyPolicy::ListNotificationChannels(
    google::monitoring::v3::ListNotificationChannelsRequest) {  // NOLINT
  return Idempotency::kIdempotent;
}

Idempotency
NotificationChannelServiceConnectionIdempotencyPolicy::GetNotificationChannel(
    google::monitoring::v3::GetNotificationChannelRequest const&) {
  return Idempotency::kIdempotent;
}

Idempotency NotificationChannelServiceConnectionIdempotencyPolicy::
    CreateNotificationChannel(
        google::monitoring::v3::CreateNotificationChannelRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency NotificationChannelServiceConnectionIdempotencyPolicy::
    UpdateNotificationChannel(
        google::monitoring::v3::UpdateNotificationChannelRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency NotificationChannelServiceConnectionIdempotencyPolicy::
    DeleteNotificationChannel(
        google::monitoring::v3::DeleteNotificationChannelRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency NotificationChannelServiceConnectionIdempotencyPolicy::
    SendNotificationChannelVerificationCode(
        google::monitoring::v3::
            SendNotificationChannelVerificationCodeRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency NotificationChannelServiceConnectionIdempotencyPolicy::
    GetNotificationChannelVerificationCode(
        google::monitoring::v3::
            GetNotificationChannelVerificationCodeRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency NotificationChannelServiceConnectionIdempotencyPolicy::
    VerifyNotificationChannel(
        google::monitoring::v3::VerifyNotificationChannelRequest const&) {
  return Idempotency::kNonIdempotent;
}

std::unique_ptr<NotificationChannelServiceConnectionIdempotencyPolicy>
MakeDefaultNotificationChannelServiceConnectionIdempotencyPolicy() {
  return std::make_unique<
      NotificationChannelServiceConnectionIdempotencyPolicy>();
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace monitoring_v3
}  // namespace cloud
}  // namespace google
