// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/pubsublite/v1/cursor.proto

#include "google/cloud/pubsublite/internal/cursor_tracing_stub.h"
#include "google/cloud/internal/async_read_write_stream_tracing.h"
#include "google/cloud/internal/grpc_opentelemetry.h"

namespace google {
namespace cloud {
namespace pubsublite_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

CursorServiceTracingStub::CursorServiceTracingStub(
    std::shared_ptr<CursorServiceStub> child)
    : child_(std::move(child)), propagator_(internal::MakePropagator()) {}

std::unique_ptr<AsyncStreamingReadWriteRpc<
    google::cloud::pubsublite::v1::StreamingCommitCursorRequest,
    google::cloud::pubsublite::v1::StreamingCommitCursorResponse>>
CursorServiceTracingStub::AsyncStreamingCommitCursor(
    CompletionQueue const& cq, std::shared_ptr<grpc::ClientContext> context) {
  auto span = internal::MakeSpanGrpc("google.cloud.pubsublite.v1.CursorService",
                                     "StreamingCommitCursor");
  internal::OTelScope scope(span);
  internal::InjectTraceContext(*context, *propagator_);
  auto stream = child_->AsyncStreamingCommitCursor(cq, context);
  return std::make_unique<internal::AsyncStreamingReadWriteRpcTracing<
      google::cloud::pubsublite::v1::StreamingCommitCursorRequest,
      google::cloud::pubsublite::v1::StreamingCommitCursorResponse>>(
      std::move(context), std::move(stream), std::move(span));
}

StatusOr<google::cloud::pubsublite::v1::CommitCursorResponse>
CursorServiceTracingStub::CommitCursor(
    grpc::ClientContext& context,
    google::cloud::pubsublite::v1::CommitCursorRequest const& request) {
  auto span = internal::MakeSpanGrpc("google.cloud.pubsublite.v1.CursorService",
                                     "CommitCursor");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->CommitCursor(context, request));
}

StatusOr<google::cloud::pubsublite::v1::ListPartitionCursorsResponse>
CursorServiceTracingStub::ListPartitionCursors(
    grpc::ClientContext& context,
    google::cloud::pubsublite::v1::ListPartitionCursorsRequest const& request) {
  auto span = internal::MakeSpanGrpc("google.cloud.pubsublite.v1.CursorService",
                                     "ListPartitionCursors");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->ListPartitionCursors(context, request));
}

#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

std::shared_ptr<CursorServiceStub> MakeCursorServiceTracingStub(
    std::shared_ptr<CursorServiceStub> stub) {
#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY
  return std::make_shared<CursorServiceTracingStub>(std::move(stub));
#else
  return stub;
#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace pubsublite_internal
}  // namespace cloud
}  // namespace google
