/*
 * Decompiled with CFR 0.152.
 */
package net.gcalc.calc;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import net.gcalc.calc.Package;
import net.gcalc.calc.main.AbstractPlugin;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class PluginListReader {
    private ClassLoader classLoader;

    public PluginListReader(ClassLoader cl) {
        this.classLoader = cl;
    }

    private String getPackageObject(Node pkg, String tagName) {
        NodeList nl = pkg.getChildNodes();
        int i = 0;
        while (i < nl.getLength()) {
            Node n = nl.item(i);
            if (n.getNodeName() == tagName) {
                NodeList children = n.getChildNodes();
                String name = children.item(0).getNodeValue();
                return name;
            }
            ++i;
        }
        return "No " + tagName;
    }

    private String getPackageDescription(Node pkg) {
        return this.getPackageObject(pkg, "description");
    }

    private String getPackageName(Node pkg) {
        return this.getPackageObject(pkg, "name");
    }

    private AbstractPlugin getPlugin(String className) throws Exception {
        AbstractPlugin dp = null;
        try {
            Class<?> C = Class.forName(className, true, this.classLoader);
            dp = (AbstractPlugin)C.newInstance();
        }
        catch (ClassNotFoundException e1) {
            throw new Exception("Cannot find " + e1.getMessage());
        }
        return dp;
    }

    private DefaultMutableTreeNode getPluginTreeNode(Node node) throws Exception {
        String className = node.getChildNodes().item(0).getNodeValue();
        AbstractPlugin dp = this.getPlugin(className);
        if (dp == null) {
            return null;
        }
        return new DefaultMutableTreeNode(dp);
    }

    private DefaultMutableTreeNode getTreeNode(Node packageNode) throws Exception {
        String name = this.getPackageName(packageNode);
        String description = this.getPackageDescription(packageNode);
        DefaultMutableTreeNode top = new DefaultMutableTreeNode(new Package(name, description));
        NodeList nl = packageNode.getChildNodes();
        int i = 0;
        while (i < nl.getLength()) {
            Node n = nl.item(i);
            String nodeName = n.getNodeName();
            if (nodeName.equals("package")) {
                top.add(this.getTreeNode(n));
            } else if (nodeName.equals("plugin")) {
                top.add(this.getPluginTreeNode(n));
            }
            ++i;
        }
        return top;
    }

    public synchronized DefaultMutableTreeNode getTreeRoot(InputStream stream) throws IOException, ParserConfigurationException, Exception {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder db = factory.newDocumentBuilder();
        InputSource is = new InputSource(new InputStreamReader(stream));
        Document doc = db.parse(is);
        DefaultMutableTreeNode branch = this.getTreeNode(doc.getDocumentElement());
        return branch;
    }
}

