/*
 * Decompiled with CFR 0.152.
 */
package net.gcalc.calc.main;

import java.awt.Frame;
import javax.swing.Icon;
import javax.swing.JDialog;
import net.gcalc.calc.gui.Shutdown;
import net.gcalc.calc.gui.ShutdownWindowAdapter;
import net.gcalc.calc.gui.SwingGUI;

public abstract class AbstractPlugin
extends JDialog
implements Shutdown {
    private static Frame owner;
    private boolean dieOnClose;
    private boolean initialized;

    public static void setParentFrame(Frame f) {
        owner = f;
    }

    protected AbstractPlugin() {
        super(owner);
        this.setResizable(false);
        this.setTitle(this.getPluginName());
        this.addWindowListener(new ShutdownWindowAdapter(this));
        System.out.println(owner);
    }

    public Icon getIcon() {
        return null;
    }

    public abstract String getCreatorName();

    public abstract String getDescription();

    public String getHTMLDescription() {
        return String.valueOf(this.getStandardHeading()) + " " + this.getDescription();
    }

    public abstract String getPluginName();

    protected String getStandardHeading() {
        return "<b>" + this.getPluginName() + " </b><br>\n Author: " + this.getCreatorName();
    }

    public String toString() {
        return this.getPluginName();
    }

    public void shutdown() {
        this.setVisible(false);
        if (owner != null) {
            owner.toFront();
        }
        if (this.dieOnClose) {
            System.exit(0);
        }
    }

    public void setDieOnClose(boolean b) {
        this.dieOnClose = b;
    }

    public abstract void init();

    public void popupMessageDialog(String message, int messageType) {
        SwingGUI.popupMessage(message, this, messageType);
    }

    public void setInitialized(boolean b) {
        this.initialized = b;
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public boolean equals(Object o) {
        return o == null ? false : this.getClass().equals(o.getClass());
    }
}

