/*
 * Decompiled with CFR 0.152.
 */
package net.gcalc.calc.math.functions;

import java.util.Vector;
import net.gcalc.calc.main.SymbolTable;
import net.gcalc.calc.main.ValueTable;
import net.gcalc.calc.math.functions.Function;
import net.gcalc.calc.math.functions.FunctionFactory;
import net.gcalc.calc.math.functions.UnaryOperation;
import net.gcalc.calc.parser.ParseTree;

public class ArcHyperbolicCotangent
extends UnaryOperation {
    public ArcHyperbolicCotangent(ParseTree pt) {
        super(pt);
    }

    public double evaluate(SymbolTable st, ValueTable vt) {
        double z = this.evaluateArgument(st, vt);
        if (z == 0.0) {
            return Double.NaN;
        }
        return (Math.log(1.0 + 1.0 / z) - Math.log(1.0 - 1.0 / z)) / 2.0;
    }

    public Function derivative(Vector vars) {
        Function u2 = FunctionFactory.getFunction(CARET_TOKEN, this.var, TWO);
        return FunctionFactory.getFunction(DIV_TOKEN, this.var.derivative(vars), FunctionFactory.getFunction(MINUS_TOKEN, ONE, u2));
    }
}

