/*
 * Decompiled with CFR 0.152.
 */
package net.gcalc.plugin.plane.graph;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.util.Vector;
import net.gcalc.calc.main.ValueTable;
import net.gcalc.calc.math.functions.BooleanOperation;
import net.gcalc.calc.math.functions.Function;
import net.gcalc.calc.models.ColoredModel;
import net.gcalc.calc.models.ModelList;
import net.gcalc.calc.models.RenderableModel;
import net.gcalc.calc.parser.VariableToken;
import net.gcalc.plugin.gui.AbstractCartesianGraphPlugin;
import net.gcalc.plugin.plane.graph.CartesianGraph;
import net.gcalc.plugin.plane.graph.DrawingThread;
import net.gcalc.plugin.plane.graph.ImplicitFunctionDrawingThread;
import net.gcalc.plugin.plane.graph.LayeredDrawingThread;
import net.gcalc.plugin.properties.GraphProperties;

public class CartesianInequalityGraph
extends CartesianGraph {
    private DrawingThread thread = null;

    public CartesianInequalityGraph(AbstractCartesianGraphPlugin plugin) {
        super(plugin);
        this.getProperties().put(GraphProperties.V_TITLE_STRING, "y");
    }

    protected Vector makeZoomsVector() {
        Vector v = super.makeZoomsVector();
        int i = v.size() - 1;
        while (i >= 0) {
            if (v.elementAt(i) instanceof CartesianGraph.FitZoom) {
                v.removeElementAt(i);
            }
            --i;
        }
        return v;
    }

    public void setDefaultGraphElements() {
        boolean b = true;
        this.properties.initDefault(GraphProperties.H_AXIS, b);
        this.properties.initDefault(GraphProperties.H_GRID, b);
        this.properties.initDefault(GraphProperties.H_SCALE, b);
        this.properties.initDefault(GraphProperties.V_AXIS, b);
        this.properties.initDefault(GraphProperties.V_GRID, b);
        this.properties.initDefault(GraphProperties.V_SCALE, b);
        this.properties.initDefault(GraphProperties.V_TITLE, b);
        this.properties.initDefault(GraphProperties.H_TITLE, b);
        this.properties.initDefault(GraphProperties.V_LABEL, b);
        this.properties.initDefault(GraphProperties.H_LABEL, b);
        this.properties.initDefault(GraphProperties.TRACE, b);
        this.properties.initDefault(GraphProperties.INTERACTIVE_ZOOM, b);
    }

    public void drawModelList() {
        ModelList modelList = this.getModelList();
        if (this.thread != null) {
            this.thread.kill();
        }
        this.thread = new InequalityDrawingThread(this, this.gr, modelList);
        this.thread.start();
    }

    class InequalityDrawingThread
    extends LayeredDrawingThread {
        CartesianGraph graph;

        InequalityDrawingThread(CartesianGraph parent, Graphics2D g, ModelList m) {
            super((Component)parent, (Graphics)g, m);
            this.graph = parent;
        }

        protected void render(int k, Graphics buffer, RenderableModel model) {
            int progress;
            int i;
            buffer.setColor(new Color(1.0f, 1.0f, 1.0f, 0.0f));
            buffer.fillRect(0, 0, 1000, 1000);
            Function inequality = model.getFunction();
            Vector vars = inequality.getVars();
            ValueTable vt = new ValueTable();
            float[] rgba = model.getColor().getRGBColorComponents(null);
            buffer.setColor(new Color(rgba[0], rgba[1], rgba[2], 0.5f));
            if (vars.contains(VariableToken.X_VAR) && vars.contains(VariableToken.Y_VAR)) {
                i = 0;
                while (i < CartesianInequalityGraph.this.getWidth()) {
                    double x = CartesianInequalityGraph.this.screenXtoCartesian(i);
                    vt.setValue(VariableToken.X_VAR, x);
                    int j = 0;
                    while (j < CartesianInequalityGraph.this.getHeight()) {
                        double y = CartesianInequalityGraph.this.screenYtoCartesian(j);
                        vt.setValue(VariableToken.Y_VAR, y);
                        double z = inequality.evaluate(vt);
                        if (!Double.isNaN(z)) {
                            buffer.drawLine(i, j, i, j);
                        }
                        ++j;
                    }
                    progress = this.modelIdx * 100 + 100 * i / CartesianInequalityGraph.this.getWidth();
                    this.progressMonitor.setProgress(progress);
                    this.progressMonitor.setNote(String.valueOf(100 * progress / this.progressMonitor.getMaximum()) + "% complete");
                    if (!this.isDead()) {
                        ++i;
                        continue;
                    }
                    break;
                }
            } else if (vars.contains(VariableToken.X_VAR)) {
                i = 0;
                while (i < CartesianInequalityGraph.this.getWidth()) {
                    double x = CartesianInequalityGraph.this.screenXtoCartesian(i);
                    vt.setValue(VariableToken.X_VAR, x);
                    double z = inequality.evaluate(vt);
                    if (!Double.isNaN(z)) {
                        buffer.drawLine(i, 0, i, CartesianInequalityGraph.this.getHeight());
                    }
                    progress = this.modelIdx * 100 + 100 * i / CartesianInequalityGraph.this.getWidth();
                    this.progressMonitor.setProgress(progress);
                    this.progressMonitor.setNote(String.valueOf(100 * progress / this.progressMonitor.getMaximum()) + "% complete");
                    if (!this.isDead()) {
                        ++i;
                        continue;
                    }
                    break;
                }
            } else if (vars.contains(VariableToken.Y_VAR)) {
                i = 0;
                while (i < CartesianInequalityGraph.this.getHeight()) {
                    double y = CartesianInequalityGraph.this.screenYtoCartesian(i);
                    vt.setValue(VariableToken.Y_VAR, y);
                    double z = inequality.evaluate(vt);
                    if (!Double.isNaN(z)) {
                        buffer.drawLine(0, i, CartesianInequalityGraph.this.getWidth(), i);
                    }
                    progress = this.modelIdx * 100 + 100 * i / CartesianInequalityGraph.this.getHeight();
                    this.progressMonitor.setProgress(progress);
                    this.progressMonitor.setNote(String.valueOf(100 * progress / this.progressMonitor.getMaximum()) + "% complete");
                    if (!this.isDead()) {
                        ++i;
                        continue;
                    }
                    break;
                }
            }
            try {
                BooleanOperation g = (BooleanOperation)inequality;
                if (!g.isStrict()) {
                    Function F = g.getZeroSetFunction();
                    ModelList modelList = new ModelList(new ColoredModel(F, Color.black));
                    ImplicitFunctionDrawingThread thread = new ImplicitFunctionDrawingThread(this.graph, buffer, modelList);
                    ((Thread)thread).start();
                    thread.join();
                }
            }
            catch (InterruptedException interruptedException) {
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
        }

        protected void finishRun() {
            CartesianInequalityGraph.this.repaint();
        }
    }
}

