/*
 * Decompiled with CFR 0.152.
 */
package net.gcalc.proto.plugin.space;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import net.gcalc.calc.main.AbstractPlugin;
import net.gcalc.calc.math.functions.FunctionFactory;
import net.gcalc.calc.models.RenderableModel;
import net.gcalc.calc.parser.BadSyntaxRuntimeException;
import net.gcalc.plugin.gui.TextInputPanel;
import net.gcalc.proto.plugin.space.Graph3DCanvas;

public class CartesianGraph3DPlugin
extends AbstractPlugin
implements ActionListener {
    protected Graph3DCanvas gc = null;
    protected JButton inputButton;
    private JMenuItem close;
    private JMenuItem clearGraph;
    private JMenuItem clearHistory;
    private JMenuItem saveImage;
    private JMenuItem printImage;
    private JMenuItem copyImage;
    private JMenuItem aboutPlugin;
    private JMenuItem showHelp;
    private TextInputPanel ip;
    Thread T;

    protected JMenu initPluginMenu() {
        return null;
    }

    protected JMenuBar initMenuBar() {
        JMenuBar jmb = new JMenuBar();
        JMenu graphMenu = new JMenu("Graph");
        JMenu editMenu = new JMenu("Edit");
        JMenu helpMenu = new JMenu("Help");
        JMenu pluginMenu = this.initPluginMenu();
        this.clearGraph = new JMenuItem("Clear Graph...");
        graphMenu.add(this.clearGraph);
        this.clearHistory = new JMenuItem("Clear Function History...");
        graphMenu.add(this.clearHistory);
        graphMenu.addSeparator();
        this.saveImage = new JMenuItem("Save Graph Image...");
        graphMenu.add(this.saveImage);
        this.printImage = new JMenuItem("Print Image...");
        graphMenu.add(this.printImage);
        graphMenu.addSeparator();
        this.close = new JMenuItem("Close Plugin");
        graphMenu.add(this.close);
        this.copyImage = new JMenuItem("Copy");
        editMenu.add(this.copyImage);
        this.showHelp = new JMenuItem("Help...");
        helpMenu.add(this.showHelp);
        this.aboutPlugin = new JMenuItem("About Plugin...");
        helpMenu.add(this.aboutPlugin);
        this.saveImage.addActionListener(this);
        this.printImage.addActionListener(this);
        this.aboutPlugin.addActionListener(this);
        this.showHelp.addActionListener(this);
        this.close.addActionListener(this);
        this.clearGraph.addActionListener(this);
        this.clearHistory.addActionListener(this);
        this.copyImage.addActionListener(this);
        jmb.add(graphMenu);
        jmb.add(editMenu);
        if (pluginMenu != null) {
            jmb.add(this.initPluginMenu());
        }
        jmb.add(Box.createHorizontalGlue());
        jmb.add(helpMenu);
        return jmb;
    }

    protected Box frameBox() {
        return Box.createVerticalBox();
    }

    public void init() {
        String[] s = new String[]{"f(x,y)="};
        this.init(new Graph3DCanvas(), s);
        if (this.T == null) {
            this.T = new Thread(this.gc);
            this.T.start();
        }
        this.pack();
    }

    protected void init(Graph3DCanvas gc, String[] labels) {
        if (this.gc != null) {
            return;
        }
        this.gc = gc;
        this.ip = new TextInputPanel("Function", labels);
        this.ip.addActionListener(new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                CartesianGraph3DPlugin.this.handleTextInput();
            }
        });
        Box graphBox = Box.createVerticalBox();
        graphBox.add(gc);
        graphBox.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(1), "Graph"));
        Box frame = this.frameBox();
        frame.add(this.ip);
        frame.add(graphBox);
        this.getContentPane().add(frame);
        this.setJMenuBar(this.initMenuBar());
        this.pack();
    }

    protected void handleTextInput() {
        try {
            String input = this.ip.getValues()[0].trim();
            this.gc.setModel(new RenderableModel(FunctionFactory.getFunction(input)));
            this.ip.addCurrentValuesToHistory();
            this.ip.clear();
        }
        catch (BadSyntaxRuntimeException ex2) {
            JOptionPane.showMessageDialog(this, ex2.toString(), "Syntax Error", 0);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void actionPerformed(ActionEvent e) {
        Object src = e.getSource();
        if (src == this.close) {
            this.shutdown();
        } else if (src == this.aboutPlugin) {
            JOptionPane.showMessageDialog(this, this.getDescription(), "About Plugin", 1);
        } else if (src == this.showHelp) {
            JOptionPane.showMessageDialog(this, "Sorry, the help feature is not yet implemented.", "Help!", 0);
        } else if (src == this.clearGraph) {
            if (JOptionPane.showConfirmDialog(this, "Do you really want to clear the graph?", "Purge Graph Data?", 0, 3) == 0) {
                this.gc.clear();
            }
        } else if (src == this.clearHistory && JOptionPane.showConfirmDialog(this, "Do you really want to clear the input history?", "Purge Input History?", 0, 3) == 0) {
            this.ip.clearHistory();
        }
    }

    public String getHTMLDescription() {
        return String.valueOf(this.getStandardHeading()) + "<p>Graphs standard 3D graphs near the origin.</p>" + "<p>Color legend: <font color=red>x-axis</font>,<font color=green>y-axis</font>, and <font color=blue>z-axis</font>";
    }

    public String getCreatorName() {
        return "Jiho Kim";
    }

    public String getPluginName() {
        return "Cartesian 3D Graph";
    }

    public String getDescription() {
        return "Graphs standard 3D graphs near origin.";
    }
}

