/* polyTest.c was originally generated by the autoSql program, which also 
 * generated polyTest.h and polyTest.sql.  This module links the database and
 * the RAM representation of objects. */

#include "common.h"
#include "linefile.h"
#include "dystring.h"
#include "jksql.h"
#include "output/polyTest.h"


struct point *pointLoad(char **row)
/* Load a point from row fetched with select * from point
 * from database.  Dispose of this with pointFree(). */
{
struct point *ret;

AllocVar(ret);
safecpy(ret->acc, sizeof(ret->acc), row[0]);
ret->x = sqlSigned(row[1]);
ret->y = sqlSigned(row[2]);
ret->z = sqlSigned(row[3]);
return ret;
}

struct point *pointLoadAll(char *fileName) 
/* Load all point from a whitespace-separated file.
 * Dispose of this with pointFreeList(). */
{
struct point *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[4];

while (lineFileRow(lf, row))
    {
    el = pointLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct point *pointLoadAllByChar(char *fileName, char chopper) 
/* Load all point from a chopper separated file.
 * Dispose of this with pointFreeList(). */
{
struct point *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[4];

while (lineFileNextCharRow(lf, chopper, row, ArraySize(row)))
    {
    el = pointLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct point *pointCommaIn(char **pS, struct point *ret)
/* Create a point out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new point */
{
char *s = *pS;

if (ret == NULL)
    AllocVar(ret);
sqlFixedStringComma(&s, ret->acc, sizeof(ret->acc));
ret->x = sqlSignedComma(&s);
ret->y = sqlSignedComma(&s);
ret->z = sqlSignedComma(&s);
*pS = s;
return ret;
}

void pointFree(struct point **pEl)
/* Free a single dynamically allocated point such as created
 * with pointLoad(). */
{
struct point *el;

if ((el = *pEl) == NULL) return;
freez(pEl);
}

void pointFreeList(struct point **pList)
/* Free a list of dynamically allocated point's */
{
struct point *el, *next;

for (el = *pList; el != NULL; el = next)
    {
    next = el->next;
    pointFree(&el);
    }
*pList = NULL;
}

void pointOutput(struct point *el, FILE *f, char sep, char lastSep) 
/* Print out point.  Separate fields with sep. Follow last field with lastSep. */
{
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->acc);
if (sep == ',') fputc('"',f);
fputc(sep,f);
fprintf(f, "%d", el->x);
fputc(sep,f);
fprintf(f, "%d", el->y);
fputc(sep,f);
fprintf(f, "%d", el->z);
fputc(lastSep,f);
}

struct polygon *polygonLoad(char **row)
/* Load a polygon from row fetched with select * from polygon
 * from database.  Dispose of this with polygonFree(). */
{
struct polygon *ret;

AllocVar(ret);
ret->pointCount = sqlSigned(row[1]);
ret->id = sqlUnsigned(row[0]);
{
int i;
char *s = row[2];
for (i=0; i<ret->pointCount; ++i)
    {
    s = sqlEatChar(s, '{');
    slSafeAddHead(&ret->points, pointCommaIn(&s, NULL));
    s = sqlEatChar(s, '}');
    s = sqlEatChar(s, ',');
    }
slReverse(&ret->points);
}
return ret;
}

struct polygon *polygonLoadAll(char *fileName) 
/* Load all polygon from a whitespace-separated file.
 * Dispose of this with polygonFreeList(). */
{
struct polygon *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[3];

while (lineFileRow(lf, row))
    {
    el = polygonLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct polygon *polygonLoadAllByChar(char *fileName, char chopper) 
/* Load all polygon from a chopper separated file.
 * Dispose of this with polygonFreeList(). */
{
struct polygon *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[3];

while (lineFileNextCharRow(lf, chopper, row, ArraySize(row)))
    {
    el = polygonLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct polygon *polygonCommaIn(char **pS, struct polygon *ret)
/* Create a polygon out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new polygon */
{
char *s = *pS;

if (ret == NULL)
    AllocVar(ret);
ret->id = sqlUnsignedComma(&s);
ret->pointCount = sqlSignedComma(&s);
{
int i;
s = sqlEatChar(s, '{');
for (i=0; i<ret->pointCount; ++i)
    {
    s = sqlEatChar(s, '{');
    if(s[0] != '}')        slSafeAddHead(&ret->points, pointCommaIn(&s,NULL));
    s = sqlEatChar(s, '}');
    s = sqlEatChar(s, ',');
    }
slReverse(&ret->points);
s = sqlEatChar(s, '}');
s = sqlEatChar(s, ',');
}
*pS = s;
return ret;
}

void polygonFree(struct polygon **pEl)
/* Free a single dynamically allocated polygon such as created
 * with polygonLoad(). */
{
struct polygon *el;

if ((el = *pEl) == NULL) return;
pointFreeList(&el->points);
freez(pEl);
}

void polygonFreeList(struct polygon **pList)
/* Free a list of dynamically allocated polygon's */
{
struct polygon *el, *next;

for (el = *pList; el != NULL; el = next)
    {
    next = el->next;
    polygonFree(&el);
    }
*pList = NULL;
}

void polygonOutput(struct polygon *el, FILE *f, char sep, char lastSep) 
/* Print out polygon.  Separate fields with sep. Follow last field with lastSep. */
{
fprintf(f, "%u", el->id);
fputc(sep,f);
fprintf(f, "%d", el->pointCount);
fputc(sep,f);
{
int i;
/* Loading point list. */
    {
    struct point *it = el->points;
    if (sep == ',') fputc('{',f);
    for (i=0; i<el->pointCount; ++i)
        {
        fputc('{',f);
        pointCommaOut(it,f);
        it = it->next;
        fputc('}',f);
        fputc(',',f);
        }
    if (sep == ',') fputc('}',f);
    }
}
fputc(lastSep,f);
}

struct polyhedron *polyhedronLoad(char **row)
/* Load a polyhedron from row fetched with select * from polyhedron
 * from database.  Dispose of this with polyhedronFree(). */
{
struct polyhedron *ret;

AllocVar(ret);
ret->polygonCount = sqlSigned(row[2]);
ret->id = sqlUnsigned(row[0]);
{
char *s = cloneString(row[1]);
sqlStringArray(s, ret->names, 2);
}
{
int i;
char *s = row[3];
for (i=0; i<ret->polygonCount; ++i)
    {
    s = sqlEatChar(s, '{');
    slSafeAddHead(&ret->polygons, polygonCommaIn(&s, NULL));
    s = sqlEatChar(s, '}');
    s = sqlEatChar(s, ',');
    }
slReverse(&ret->polygons);
}
return ret;
}

struct polyhedron *polyhedronLoadAll(char *fileName) 
/* Load all polyhedron from a whitespace-separated file.
 * Dispose of this with polyhedronFreeList(). */
{
struct polyhedron *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[4];

while (lineFileRow(lf, row))
    {
    el = polyhedronLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct polyhedron *polyhedronLoadAllByChar(char *fileName, char chopper) 
/* Load all polyhedron from a chopper separated file.
 * Dispose of this with polyhedronFreeList(). */
{
struct polyhedron *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[4];

while (lineFileNextCharRow(lf, chopper, row, ArraySize(row)))
    {
    el = polyhedronLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct polyhedron *polyhedronCommaIn(char **pS, struct polyhedron *ret)
/* Create a polyhedron out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new polyhedron */
{
char *s = *pS;

if (ret == NULL)
    AllocVar(ret);
ret->id = sqlUnsignedComma(&s);
{
int i;
s = sqlEatChar(s, '{');
for (i=0; i<2; ++i)
    {
    ret->names[i] = sqlStringComma(&s);
    }
s = sqlEatChar(s, '}');
s = sqlEatChar(s, ',');
}
ret->polygonCount = sqlSignedComma(&s);
{
int i;
s = sqlEatChar(s, '{');
for (i=0; i<ret->polygonCount; ++i)
    {
    s = sqlEatChar(s, '{');
    if(s[0] != '}')        slSafeAddHead(&ret->polygons, polygonCommaIn(&s,NULL));
    s = sqlEatChar(s, '}');
    s = sqlEatChar(s, ',');
    }
slReverse(&ret->polygons);
s = sqlEatChar(s, '}');
s = sqlEatChar(s, ',');
}
*pS = s;
return ret;
}

void polyhedronFree(struct polyhedron **pEl)
/* Free a single dynamically allocated polyhedron such as created
 * with polyhedronLoad(). */
{
struct polyhedron *el;

if ((el = *pEl) == NULL) return;
/* All strings in names are allocated at once, so only need to free first. */
if (el->names != NULL)
    freeMem(el->names[0]);
polygonFreeList(&el->polygons);
freez(pEl);
}

void polyhedronFreeList(struct polyhedron **pList)
/* Free a list of dynamically allocated polyhedron's */
{
struct polyhedron *el, *next;

for (el = *pList; el != NULL; el = next)
    {
    next = el->next;
    polyhedronFree(&el);
    }
*pList = NULL;
}

void polyhedronOutput(struct polyhedron *el, FILE *f, char sep, char lastSep) 
/* Print out polyhedron.  Separate fields with sep. Follow last field with lastSep. */
{
fprintf(f, "%u", el->id);
fputc(sep,f);
{
int i;
if (sep == ',') fputc('{',f);
for (i=0; i<2; ++i)
    {
    if (sep == ',') fputc('"',f);
    fprintf(f, "%s", el->names[i]);
    if (sep == ',') fputc('"',f);
    fputc(',', f);
    }
if (sep == ',') fputc('}',f);
}
fputc(sep,f);
fprintf(f, "%d", el->polygonCount);
fputc(sep,f);
{
int i;
/* Loading polygon list. */
    {
    struct polygon *it = el->polygons;
    if (sep == ',') fputc('{',f);
    for (i=0; i<el->polygonCount; ++i)
        {
        fputc('{',f);
        polygonCommaOut(it,f);
        it = it->next;
        fputc('}',f);
        fputc(',',f);
        }
    if (sep == ',') fputc('}',f);
    }
}
fputc(lastSep,f);
}

/* -------------------------------- End autoSql Generated Code -------------------------------- */

