/* dv.h was originally generated by the autoSql program, which also 
 * generated dv.c and dv.sql.  This header links the database and
 * the RAM representation of objects. */

#ifndef DV_H
#define DV_H

#define DV_NUM_COLS 7

struct dv
/* disease variation */
    {
    struct dv *next;  /* Next in singly linked list. */
    char *spID;	/* Swiss-prot ID */
    unsigned start;	/* Start position */
    unsigned len;	/* Length */
    char *orig;	/* Original */
    char *variant;	/* Variant */
    char *varId;	/* Variant identifier */
    char *varStatus;	/* Variant status (always unknown) */
    };

void dvStaticLoad(char **row, struct dv *ret);
/* Load a row from dv table into ret.  The contents of ret will
 * be replaced at the next call to this function. */

struct dv *dvLoad(char **row);
/* Load a dv from row fetched with select * from dv
 * from database.  Dispose of this with dvFree(). */

struct dv *dvLoadAll(char *fileName);
/* Load all dv from whitespace-separated file.
 * Dispose of this with dvFreeList(). */

struct dv *dvLoadAllByChar(char *fileName, char chopper);
/* Load all dv from chopper separated file.
 * Dispose of this with dvFreeList(). */

#define dvLoadAllByTab(a) dvLoadAllByChar(a, '\t');
/* Load all dv from tab separated file.
 * Dispose of this with dvFreeList(). */

struct dv *dvCommaIn(char **pS, struct dv *ret);
/* Create a dv out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new dv */

void dvFree(struct dv **pEl);
/* Free a single dynamically allocated dv such as created
 * with dvLoad(). */

void dvFreeList(struct dv **pList);
/* Free a list of dynamically allocated dv's */

void dvOutput(struct dv *el, FILE *f, char sep, char lastSep);
/* Print out dv.  Separate fields with sep. Follow last field with lastSep. */

#define dvTabOut(el,f) dvOutput(el,f,'\t','\n');
/* Print out dv as a line in a tab-separated file. */

#define dvCommaOut(el,f) dvOutput(el,f,',',',');
/* Print out dv as a comma separated list including final comma. */

/* -------------------------------- End autoSql Generated Code -------------------------------- */

#endif /* DV_H */

