table stanMad 
"stanford's microarray database output"
(
string exp; "Name of the experiment based on the array id."
lstring name; "Name of the gene or sample that is at a given position."
string type; "Indicates whether an element is a control or cDNA."
int ch1i; "The average total signal for each spot for Cy3"
int ch1b; "The local background calculated for each spot for Cy3"
int ch1d; "The difference between the total and background for each element."
int ch2i; "The average total signal for each spot for Cy5."
int ch2b; "The local background calculated for each spot for Cy5"
int ch2d; "The difference between the total and background for each element."
int ch2in; "The average total signal for each spot for Cy5 normalized so that the average log ratio of all well measured spots is equal to 0."
int ch2bn; "The local background calculated for each spot for Cy5 normalized so that the average log ratio of all well measured spots is equal to 0."
int ch2dn; "The difference between the total and background for each element normalized so that the average log ratio of all well measured spots is equal to 0."
float rat1; "CH1D/CH2D"
float rat2; "CH2D/CH1D"
float rat1n; "CH1D/CH2DN"
float rat2n; "CH2DN/CH1D"
float mrat; "unknown"
float crt1; "and CRT2 Unused."
float crt2; "unused"
float regr; "The ratio estimated by the slope of the line fit to the distribution of pixels in each spot."
float corr; "The correlation of the signal at each pixel of a spot in CH1 to CH2."
float edge; "unnknown"
int fing; "unknown"
int grid; "unknown"
int arow; "unknown"
int row; "unknown"
int acol; "unknown"
int col; "unknown"
int plat; "The plate ID from which a sample was printed."
string prow; "The plate row from which a sample was printed."
int pcol; "The plate column from which a sample was printed."
int flag; "A user defined field which identifies spots which are visually of low quality. The value 0 is good all other values represent poor quality spots."
int clid; "The Identification number of the printed cDNA clone. These are mostly IMAGE clones. It is recommended to verify the clone identity by GenBank lookup using the EST accession number (see above)"
int spot; "The spot number on the array."
int left; "The left coordinate of the spot on the scanned Microarray Image"
int top; "The top coordinate of the spot."
int right; "The right coordinate of the spot."
int bot; "The bottom coordinate of the spot."
string acc5; "The 5' GenBank accession number for an EST generated from the printed cDNA clone (This is the most stable handle for retrieving up to date information about this cDNA clone)"
string acc3; "The 3' GenBank accession number for an EST generated from the printed cDNA clone (This is the most stable handle for retrieving up to date information about this cDNA clone)"
)
