# List and cxr

The list library and cxr library was written by M. Hiroi.

# Acknowledgement
Thanks to Mr. Hiroi.

# Usage 

```lisp
(import "list")

(import "cxr")
```

# Specification
- cxxr, cxxxr, cxxxxr
    combination of car and cdr
- first, second, ..., tenth
    Find the elements of the list
- last-pair xs
    Find the last cell of list xs
- last xs
    Find the last element of list xs
- take xs n
    Extract n elements from the beginning of list xs
- drop xs n
    Remove n elements from the beginning of list xs
- revappend xs ys
    Invert list xs and concatenate with ys 
- copy-list xs
    Copy the top level of the list xs
- copy-tree tree
    Copy the entire list tree
- copy-alist alist
    Copy the associative list alist
    Only the top level and the cell containing the key and value are copied
- subst new old tree
    Equal to old (eql) Replace elements in list tree with new
- subst-if new pred tree
    Replace the element for which the predicate pred returns true with new
- subst-if-not new pred tree
    Replace elements where the predicate pred returns false with new 
- iota n m
    Generate a sequence (list) of integers from n to m
- tabulate f n m
    Stores and returns the values of f (n), ..., f (m) in a list
- unfold p f g seed
    Unraveling (reverse convolution)
    Stores the value of f (seed) in a list and returns it. The next term is generated by g (seed). When p (seed) is true, the list generation ends. 
- fold-left f a xs1 [xs2 ...]
    Fold from the top of the list
    Cumulative value is passed as the first argument of the function f, and the elements of the list are passed after that.
- fold-right f a xs1 [xs2 ...]
    Convolution from the end of the list
    Cumulative value is passed as the first argument of the function f, and the elements of the list are passed after that. 
- for-each f xs1 [xs2 ...]
    Apply the function f to the elements of the list
- partition pred xs
    Divide the list xs into two by the truth of the predicate pred
- any pred xs1 [xs2 ...]
    Apply the predicate pred to the elements of the list and return T if any element returns true.
- all pred xs1 [xs2 ...]
    Apply the predicate pred to the elements of the list and return NIL if any element returns false. 
- member-if pred xs
    Find the first element for which the predicate pred is true
- member-if-not pred xs
    Find the first element where the predicate pred is false
- remove-duplicates xs
    Remove duplicate elements (use eql for equality determination)
- union xs ys ys
    Find the union
- intersection xs ys
    Find the intersection
- difference xs ys
    Find the difference set
- subsetp xs ys
    Returns true if xs is a subset of ys   
- acons k v alist
    Add key k and value v to the associative list alist
- pairlis ks vs alist
    Add key (element of list ks) and value (element of list vs) to alist
- assoc-if pred alist
    Find the first key for which the predicate pred returns true
- assoc-if pred alist
    Find the first key for which the predicate pred returns false
- rassoc value alist
    Equal to value (eql) Find the first value
- rassoc-if pred alist
    Find the first value for which the predicate pred returns true
- rassoc-if pred alist
    Find the first value for which the predicate pred returns false 
    


# Test cases

```lisp
(test (caar '((a b) (c d) (e f))) A)
(test (cadr '((a b) (c d) (e f))) (C D))
(test (cdar '((a b) (c d) (e f))) (B))
(test (cddr '((a b) (c d) (e f))) ((E F)))
;; ommited cXXXr cXXXXr
(test (first '(a b c d e f)) A)
(test (second '(a b c d e f)) B)
(test (third '(a b c d e f)) C)
(test (fourth '(a b c d e f)) D)
(test (fifth '(a b c d e f)) E)
(test (sixth '(a b c d e f g h i j)) F)
(test (seventh '(a b c d e f g h i j)) G)
(test (eigthth '(a b c d e f g h i j)) h)
(test (ninth '(a b c d e f g h i j)) i)
(test (tenth '(a b c d e f g h i j)) j)
(test (last-pair '(a b c d e f)) (F))
(test (last '(a b c d e f)) F)
(test (take '(a b c d e f) 3) (A B C))
(test (drop '(a b c d e f) 3) (D E F))
(test (take '(a b c d e f) 6) (A B C D E F))
(test (drop '(a b c d e f) 6) NIL)
(test (revappend '(a b c) '(d e f)) (C B A D E F))
(test (revappend nil '(d e f)) (D E F))
(test (revappend '(a b c) nil) (C B A))
(test (iota 1 10) (1 2 3 4 5 6 7 8 9 10))
(test (iota 1 1) (1))
(test (iota 1 0) NIL)
(test (remove-duplicates '(a b c a b c d a b c d e)) (A B C D E))
(test (remove-duplicates '(a b c d e f)) (A B C D E F))
(defun evenp (x)
    (= (mod x 2) 0) )

(defun xcons (a b)
    (cons b a) )

(test (member-if (lambda (x) (= (mod x 2) 0)) '(1 2 3 4 5 6 7 8)) (2 3 4 5 6 7 8))
(test (member-if (lambda (x) (= (mod x 2) 0)) '(1 3 5 7 9)) NIL)
(test (member-if-not (lambda (x) (= (mod x 2) 0)) '(1 2 3 4 5 6 7 8)) (1 2 3 4 5 6 7 8))
(test (member-if-not (lambda (x) (= (mod x 2) 1)) '(1 3 5 7 9)) NIL)
(test (fold-left #'+ 0 (iota 1 10)) 55)
(test (fold-right #'+ 0 (iota 1 10)) 55)
(test (fold-left (lambda (a x y) (cons (cons x y) a)) nil '(1 2 3 4) '(5 6 7 8)) ((4 . 8) (3 . 7) (2 . 6) (1 . 5)))
(test (fold-right (lambda (a x y) (cons (cons x y) a)) nil '(1 2 3 4) '(5 6 7 8)) ((1 . 5) (2 . 6) (3 . 7) (4 . 8)))
(test (partition (lambda (x) (= (mod x 2) 0)) (iota 1 10)) ((2 4 6 8 10) (1 3 5 7 9)))
(test (partition (lambda (x) (= (mod x 2) 1)) (iota 1 10)) ((1 3 5 7 9) (2 4 6 8 10)))
(test (partition (lambda (x) (<= x 5)) (iota 1 10)) ((1 2 3 4 5) (6 7 8 9 10)))
(test (partition (lambda (x) (> x 5)) (iota 1 10)) ((6 7 8 9 10) (1 2 3 4 5)))
(test (any #'< '(1 3 5) '(2 1 0)) T)
(test (any #'< '(1 3 5) '(0 1 0)) NIL)
(test (any #'evenp '(1 3 4 5)) T)
(test (any #'evenp '(1 3 5)) NIL)
(test (any (lambda (x) (<= x 5)) '(5 6 7 8 9)) T)
(test (any (lambda (x) (<= x 5)) '(6 7 8 9 10)) NIL)
(test (any #'<= '(5 6 7 8 9) '(5 4 3 2 1)) T)
(test (any #'<= '(5 6 7 8 9) '(4 3 2 1 0)) NIL)
(test (all (lambda (x) (<= 5 x)) '(5 6 7 8 9)) T)
(test (all (lambda (x) (<= 5 x)) '(5 6 7 8 0)) NIL)
(test (all #'<= '(1 2 3 4 5) '(6 7 8 9 10)) T)
(test (all #'<= '(1 2 3 4 5) '(6 7 8 9 0)) NIL)
(test (union '(1 2 3 4) '(3 4 5 6)) (1 2 3 4 5 6))
(test (intersection '(1 2 3 4) '(3 4 5 6)) (3 4))
(test (difference '(1 2 3 4) '(3 4 5 6)) (1 2))
(test (subsetp '(1 2) '(1 2 3 4)) T)
(test (subsetp '(1 2 5) '(1 2 3 4)) NIL)
```
