/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.xmindresource;

import java.io.File;
import net.xmind.verify.ui.VerifyUI20141031;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.IImportWizard;
import org.eclipse.ui.IWorkbench;
import org.xmind.core.util.FileUtils;
import org.xmind.ui.internal.xmindresource.Messages;
import org.xmind.ui.internal.xmindresource.ResourceImportWizardSelectionPage;
import org.xmind.ui.internal.xmindresource.XMindResourceImpExpUtils;
import org.xmind.ui.mindmap.MindMapUI;
import org.xmind.ui.xmindresource.XMindResourcePlugin;

public class ResourceImportWizard
extends Wizard
implements IImportWizard {
    private static final String SECTION_NAME = "org.xmind.ui.xmindresource.ResourceImportWizard";
    private IWorkbench workbench;
    private ResourceImportWizardSelectionPage selectionPage;

    public ResourceImportWizard() {
        this.setWindowTitle(Messages.ResourceImportWizard_windowTitle);
        this.setDefaultPageImageDescriptor(MindMapUI.getImages().getWizBan("import_wiz.png"));
        this.setDialogSettings(XMindResourcePlugin.getDefault().getDialogSettings(SECTION_NAME));
        VerifyUI20141031.getUsageDataCollector().increase("ImportResourcesCount");
    }

    public void addPages() {
        this.selectionPage = new ResourceImportWizardSelectionPage();
        this.addPage((IWizardPage)this.selectionPage);
    }

    public boolean canFinish() {
        return super.canFinish() && this.isValidPath(this.selectionPage.getSourcePath());
    }

    private boolean isValidPath(String path) {
        if (path == null) {
            return false;
        }
        File file = new File(path);
        if (file.isDirectory()) {
            String[] resourceFiles = file.list();
            if (resourceFiles != null) {
                String[] stringArray = resourceFiles;
                int n = resourceFiles.length;
                int n2 = 0;
                while (n2 < n) {
                    String resourceFile = stringArray[n2];
                    if (resourceFile.endsWith(".xrb") || resourceFile.endsWith(".xmp")) {
                        return true;
                    }
                    ++n2;
                }
            }
        } else if (file.exists() && (path.endsWith(".xrb") || path.endsWith(".xmp"))) {
            return true;
        }
        return false;
    }

    public boolean performFinish() {
        boolean[] b = new boolean[1];
        int status = this.selectionPage.getStatus();
        if ((status |= XMindResourceImpExpUtils.importResourceBundleFromTempDir(this.selectionPage.getUnZipDir())) != 0) {
            if ((status & 0x20) == 0) {
                StringBuffer failureType = XMindResourceImpExpUtils.getFailureType(status);
                MessageDialog information = new MessageDialog(this.workbench.getActiveWorkbenchWindow().getShell(), Messages.ResourceImportWizard_Exception_Informtion_title, null, NLS.bind((String)Messages.ResourceImportWizard_PartialException_Information_description, (Object)failureType), 2, new String[]{Messages.ResourceImportWizard_Exception_Information_button}, 0);
                information.setBlockOnOpen(false);
                information.open();
                b[0] = true;
            } else {
                MessageDialog information = new MessageDialog(this.workbench.getActiveWorkbenchWindow().getShell(), Messages.ResourceImportWizard_Exception_Informtion_title, null, Messages.ResourceImportWizard_WholeException_Information_description, 2, new String[]{Messages.ResourceImportWizard_Exception_Information_button}, 0);
                information.setBlockOnOpen(false);
                information.open();
                b[0] = false;
            }
        } else {
            b[0] = true;
        }
        this.clearTempDir();
        return b[0];
    }

    private void clearTempDir() {
        File dir = XMindResourcePlugin.getDefault().getStateLocation().toFile();
        if ((dir = new File(dir, "Import Resource Bundle")).isDirectory()) {
            FileUtils.clearDir((File)dir);
        }
    }

    public boolean performCancel() {
        this.clearTempDir();
        return super.performCancel();
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.workbench = workbench;
    }
}

