/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.core.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Set;
import org.xmind.core.style.IStyle;
import org.xmind.core.style.IStyleSheet;
import org.xmind.core.util.DOMUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class StyleSheet
implements IStyleSheet {
    protected static final Set<IStyle> NO_STYLES = Collections.emptySet();
    private IStyleSheet parent = null;

    @Override
    public <T> T getAdapter(Class<T> adapter) {
        return null;
    }

    @Override
    public Set<IStyle> getAllStyles() {
        Set<IStyle> normalStyles = this.getStyles("normal-styles");
        Set<IStyle> masterStyles = this.getStyles("master-styles");
        Set<IStyle> automaticStyles = this.getStyles("automatic-styles");
        int size = normalStyles.size() + masterStyles.size() + automaticStyles.size();
        if (size == 0) {
            return NO_STYLES;
        }
        ArrayList<IStyle> list = new ArrayList<IStyle>(size);
        list.addAll(automaticStyles);
        list.addAll(masterStyles);
        list.addAll(normalStyles);
        return DOMUtils.unmodifiableSet(list);
    }

    @Override
    public boolean isEmpty() {
        return this.getAllStyles().isEmpty();
    }

    @Override
    public IStyleSheet getParentSheet() {
        return this.parent;
    }

    @Override
    public void setParentSheet(IStyleSheet parent) {
        this.parent = parent;
    }

    @Override
    public IStyle findStyle(String styleId) {
        if (styleId == null) {
            return null;
        }
        IStyle style = this.getLocalStyle(styleId);
        if (style != null) {
            return style;
        }
        if (this.parent != null) {
            style = this.parent.findStyle(styleId);
        }
        return style;
    }

    protected abstract IStyle getLocalStyle(String var1);
}

