/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.gef.image;

import java.io.OutputStream;
import org.eclipse.draw2d.FreeformFigure;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageLoader;
import org.xmind.gef.draw2d.geometry.Geometry;
import org.xmind.gef.image.ExportAreaProvider;
import org.xmind.gef.image.FigureRenderer;
import org.xmind.gef.image.IExportAreaProvider;
import org.xmind.gef.image.IExportSourceProvider;
import org.xmind.gef.image.ImageWriter;
import org.xmind.gef.internal.image.ConstrainedExportAreaProvider;
import org.xmind.gef.internal.image.FittedExportAreaProvider;
import org.xmind.gef.internal.image.MaxPixelsExportAreaProvider;
import org.xmind.gef.internal.image.SWTImageWriter;
import org.xmind.gef.internal.image.StretchedExportAreaProvider;

public class ImageExportUtils {
    public static IExportAreaProvider createExportAreaProvider(Rectangle sourceArea) {
        return ImageExportUtils.createExportAreaProvider(sourceArea, 0, -1, -1, null);
    }

    public static IExportAreaProvider createExportAreaProvider(Rectangle sourceArea, int resizeStrategy) {
        return ImageExportUtils.createExportAreaProvider(sourceArea, resizeStrategy, -1, -1, null);
    }

    public static IExportAreaProvider createExportAreaProvider(Rectangle sourceArea, int resizeStrategy, int wHint, int hHint) {
        return ImageExportUtils.createExportAreaProvider(sourceArea, resizeStrategy, wHint, hHint, null);
    }

    public static IExportAreaProvider createExportAreaProvider(Rectangle sourceArea, int resizeStrategy, Insets margins) {
        return ImageExportUtils.createExportAreaProvider(sourceArea, resizeStrategy, -1, -1, margins);
    }

    public static IExportAreaProvider createExportAreaProvider(Rectangle sourceArea, Insets margins) {
        return ImageExportUtils.createExportAreaProvider(sourceArea, 0, -1, -1, margins);
    }

    public static IExportAreaProvider createExportAreaProvider(Rectangle sourceArea, int resizeStrategy, int wHint, int hHint, Insets margins) {
        switch (resizeStrategy) {
            case 1: {
                return new StretchedExportAreaProvider(sourceArea, wHint, hHint, margins);
            }
            case 2: {
                return new FittedExportAreaProvider(sourceArea, wHint, hHint, margins);
            }
            case 3: {
                return new ConstrainedExportAreaProvider(sourceArea, wHint, hHint, margins);
            }
            case 4: {
                return new MaxPixelsExportAreaProvider(sourceArea, wHint, hHint, margins);
            }
        }
        return new ExportAreaProvider(sourceArea, wHint, hHint, margins);
    }

    public static ImageWriter createImageWriter(Image image, int format, OutputStream output) {
        return new SWTImageWriter(image, format, output);
    }

    public static ImageWriter createImageWriter(ImageData[] imageData, int format, OutputStream output) {
        return new SWTImageWriter(imageData, format, output);
    }

    public static Rectangle calcBoundsUnion(IFigure[] figures) {
        Rectangle r = null;
        IFigure[] iFigureArray = figures;
        int n = figures.length;
        int n2 = 0;
        while (n2 < n) {
            IFigure figure = iFigureArray[n2];
            r = Geometry.union(r, ImageExportUtils.getBounds(figure));
            ++n2;
        }
        return r;
    }

    public static Rectangle calcBoundsIntersection(IFigure[] figures) {
        Rectangle r = null;
        IFigure[] iFigureArray = figures;
        int n = figures.length;
        int n2 = 0;
        while (n2 < n) {
            IFigure figure = iFigureArray[n2];
            r = Geometry.intersect(r, ImageExportUtils.getBounds(figure));
            ++n2;
        }
        return r;
    }

    public static Rectangle getBounds(IFigure figure) {
        if (figure instanceof FreeformFigure) {
            return ((FreeformFigure)figure).getFreeformExtent();
        }
        return figure.getBounds();
    }

    public static Image createImage(Device device, IExportSourceProvider source, int resizeStrategy, int wHint, int hHint) {
        IExportAreaProvider area = ImageExportUtils.createExportAreaProvider(source.getSourceArea(), resizeStrategy, wHint, hHint, source.getMargins());
        FigureRenderer renderer = new FigureRenderer();
        renderer.init(source, area);
        return ImageExportUtils.createImage(device, renderer);
    }

    public static Image createImage(Device device, FigureRenderer renderer) {
        Rectangle bounds = renderer.getBounds();
        Image image = new Image(device, bounds.width, bounds.height);
        GC gc = new GC((Drawable)image);
        try {
            renderer.render(gc);
        }
        finally {
            gc.dispose();
        }
        return image;
    }

    public static void saveImage(Image image, OutputStream stream, int format) {
        ImageData data = image.getImageData();
        ImageLoader saver = new ImageLoader();
        saver.data = new ImageData[]{data};
        saver.save(stream, format);
    }
}

