/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.cathy.internal;

import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.ComboFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.xmind.cathy.internal.CathyPlugin;
import org.xmind.cathy.internal.WorkbenchMessages;
import org.xmind.ui.internal.MindMapUIPlugin;
import org.xmind.ui.preference.PreferenceFieldEditorPageSection;

public class SaveBackupPreferencePageSection
extends PreferenceFieldEditorPageSection
implements IWorkbenchPreferencePage {
    private String[][] saveIntervals = new String[][]{{"5", "5"}, {"10", "10"}, {"30", "30"}, {"60", "60"}};
    private Composite container;
    private FieldEditor autoSaveInterval;
    private boolean autoBackup = true;
    private BooleanFieldEditor autoBackupField;
    private Composite autoSaveIntervalsParent;

    protected Control createContents(Composite parent) {
        if (this.container == null) {
            this.container = parent;
        }
        return super.createContents(parent);
    }

    protected IPreferenceStore doGetPreferenceStore() {
        return CathyPlugin.getDefault().getPreferenceStore();
    }

    protected void initialize() {
        super.initialize();
        this.autoBackupField.setPreferenceStore(MindMapUIPlugin.getDefault().getPreferenceStore());
        this.autoBackupField.load();
    }

    protected void createFieldEditors() {
        this.addAutoSaveGroup(this.container);
        this.initialize();
    }

    private void addAutoSaveGroup(Composite parent) {
        String message = WorkbenchMessages.AutoSave_label2;
        int index = message.indexOf("{0}");
        String label1 = message.substring(0, index);
        String label2 = message.substring(index + 3);
        if (this.saveIntervals != null) {
            String[][] stringArray = this.saveIntervals;
            int n = this.saveIntervals.length;
            int n2 = 0;
            while (n2 < n) {
                String[] interval = stringArray[n2];
                interval[0] = String.valueOf(interval[0]) + " " + label2;
                ++n2;
            }
        }
        Composite container = new Composite(parent, 0);
        GridDataFactory.fillDefaults().applyTo((Control)container);
        GridLayoutFactory.fillDefaults().extendedMargins(23, 0, 0, 0).applyTo(container);
        Composite saveParent = this.createContainer(container, 2);
        Composite enableParent = this.createContainer(saveParent, 1);
        this.addField((FieldEditor)new BooleanFieldEditor("autoSaveEnabled", label1, enableParent));
        this.autoSaveIntervalsParent = this.createContainer(saveParent, 1);
        this.autoSaveInterval = new ComboFieldEditor("autoSaveIntervals", "", this.saveIntervals, this.autoSaveIntervalsParent);
        this.addField(this.autoSaveInterval);
        this.autoSaveInterval.setEnabled(this.getPreferenceStore().getBoolean("autoSaveEnabled"), this.autoSaveIntervalsParent);
        Composite boolParent = this.createContainer(container, 1);
        this.autoBackupField = new BooleanFieldEditor("autoBackupEnable", WorkbenchMessages.AutoBackup_label, boolParent);
        this.autoBackupField.setPropertyChangeListener((IPropertyChangeListener)this);
    }

    private Composite createContainer(Composite parent, int cols) {
        Composite container = new Composite(parent, 0);
        GridDataFactory.fillDefaults().applyTo((Control)container);
        GridLayoutFactory.fillDefaults().numColumns(cols).applyTo(container);
        return container;
    }

    public void propertyChange(PropertyChangeEvent event) {
        if (event.getSource() instanceof FieldEditor) {
            FieldEditor fe = (FieldEditor)event.getSource();
            if (event.getProperty().equals("field_editor_value")) {
                String prefName = fe.getPreferenceName();
                if ("autoSaveEnabled".equals(prefName)) {
                    this.autoSaveInterval.setEnabled(((Boolean)event.getNewValue()).booleanValue(), this.autoSaveIntervalsParent);
                } else if ("autoBackupEnable".equals(prefName)) {
                    this.autoBackup = (Boolean)event.getNewValue();
                }
            }
        }
    }

    public boolean performOk() {
        if (!super.performOk()) {
            return false;
        }
        MindMapUIPlugin.getDefault().getPreferenceStore().setValue("autoBackupEnable", this.autoBackup);
        return true;
    }
}

