/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.util.Util;
import org.eclipse.ui.actions.CompoundContributionItem;
import org.eclipse.ui.menus.CommandContributionItem;
import org.eclipse.ui.menus.CommandContributionItemParameter;
import org.eclipse.ui.menus.IWorkbenchContribution;
import org.eclipse.ui.services.IServiceLocator;
import org.xmind.ui.internal.MindMapMessages;
import org.xmind.ui.mindmap.MindMapUI;

public class ColorfulSheetMenu
extends CompoundContributionItem
implements IWorkbenchContribution {
    private static final String SHEET_ICON_PATH = "icons/sheet/";
    private static final List<ColorEntry> TAB_COLORS_WINDOWS = Arrays.asList(new ColorEntry(MindMapMessages.ColorfulSheetMenu_windows_blue, "#2188e2", "windows_blue.png"), new ColorEntry(MindMapMessages.ColorfulSheetMenu_windows_purple, "#a497fd", "windows_purple.png"), new ColorEntry(MindMapMessages.ColorfulSheetMenu_windows_red, "#f58868", "windows_red.png"), new ColorEntry(MindMapMessages.ColorfulSheetMenu_windows_yellow, "#fabd65", "windows_yellow.png"), new ColorEntry(MindMapMessages.ColorfulSheetMenu_windows_green, "#80df98", "windows_green.png"), new ColorEntry(MindMapMessages.ColorfulSheetMenu_windows_brown, "#9e8273", "windows_brown.png"), new ColorEntry(MindMapMessages.ColorfulSheetMenu_windows_gray, "#6b7288", "windows_gray.png"), new ColorEntry(MindMapMessages.ColorfulSheetMenu_windows_none, "", "windows_none.png"));
    private static final List<ColorEntry> TAB_COLORS_OTHERS = Arrays.asList(new ColorEntry(MindMapMessages.ColorfulSheetMenu_mac_red, "#ff625c", "others_red.png"), new ColorEntry(MindMapMessages.ColorfulSheetMenu_mac_orange, "#f9a646", "others_orange.png"), new ColorEntry(MindMapMessages.ColorfulSheetMenu_mac_yellow, "#f5cf4a", "others_yellow.png"), new ColorEntry(MindMapMessages.ColorfulSheetMenu_mac_green, "#6dcc50", "others_green.png"), new ColorEntry(MindMapMessages.ColorfulSheetMenu_mac_blue, "#4bb8f3", "others_blue.png"), new ColorEntry(MindMapMessages.ColorfulSheetMenu_mac_purple, "#d089e1", "others_purple.png"), new ColorEntry(MindMapMessages.ColorfulSheetMenu_mac_gray, "#a4a4a8", "others_gray.png"), new ColorEntry(MindMapMessages.ColorfulSheetMenu_mac_none, "", "others_none.png"));
    private IServiceLocator serviceLocator;

    public void initialize(IServiceLocator serviceLocator) {
        this.serviceLocator = serviceLocator;
    }

    protected IContributionItem[] getContributionItems() {
        ArrayList<IContributionItem> items = new ArrayList<IContributionItem>();
        if (this.serviceLocator != null) {
            this.fillItems(items, ColorfulSheetMenu.getSheetTabColors());
        }
        return items.toArray(new IContributionItem[items.size()]);
    }

    private void fillItems(List<IContributionItem> items, List<ColorEntry> colors) {
        for (ColorEntry color : colors) {
            items.add(this.makeColorCommandItem(color));
        }
    }

    private IContributionItem makeColorCommandItem(ColorEntry color) {
        String id = "colorfulSheet." + color.getName();
        CommandContributionItemParameter parameter = new CommandContributionItemParameter(this.serviceLocator, id, "org.xmind.ui.command.colorfulSheet", 8);
        parameter.label = color.getName();
        parameter.icon = MindMapUI.getImages().get(color.getIconPath(), SHEET_ICON_PATH);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("org.xmind.ui.command.colorfulSheet.rgbParameter", color.getRgb());
        parameter.parameters = params;
        return new CommandContributionItem(parameter);
    }

    private static List<ColorEntry> getSheetTabColors() {
        return Util.isWindows() ? TAB_COLORS_WINDOWS : TAB_COLORS_OTHERS;
    }

    private static class ColorEntry {
        private String name;
        private String rgb;
        private String iconPath;

        public ColorEntry(String name, String rgb, String iconPath) {
            this.name = name;
            this.rgb = rgb;
            this.iconPath = iconPath;
        }

        public String getName() {
            return this.name;
        }

        public String getRgb() {
            return this.rgb;
        }

        public String getIconPath() {
            return this.iconPath;
        }
    }
}

