/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.actions;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.ui.actions.CompoundContributionItem;
import org.eclipse.ui.menus.CommandContributionItem;
import org.eclipse.ui.menus.CommandContributionItemParameter;
import org.eclipse.ui.menus.IWorkbenchContribution;
import org.eclipse.ui.services.IServiceLocator;
import org.xmind.core.marker.IMarker;
import org.xmind.core.marker.IMarkerGroup;
import org.xmind.core.marker.IMarkerSheet;
import org.xmind.ui.mindmap.MindMapUI;
import org.xmind.ui.util.MarkerImageDescriptor;

public class AllMarkersMenu
extends CompoundContributionItem
implements IWorkbenchContribution {
    private IServiceLocator serviceLocator;

    public void initialize(IServiceLocator serviceLocator) {
        this.serviceLocator = serviceLocator;
    }

    protected IContributionItem[] getContributionItems() {
        ArrayList<IContributionItem> items = new ArrayList<IContributionItem>();
        if (this.serviceLocator != null) {
            this.fillItems(items, MindMapUI.getResourceManager().getSystemMarkerSheet());
        }
        return items.toArray(new IContributionItem[items.size()]);
    }

    private void fillItems(List<IContributionItem> items, IMarkerSheet markerSheet) {
        for (IMarkerGroup group : markerSheet.getMarkerGroups()) {
            MenuManager groupMenu = new MenuManager(group.getName(), "#" + group.getId());
            if (group.isHidden()) continue;
            this.fillGroup(group, (IMenuManager)groupMenu);
            items.add((IContributionItem)groupMenu);
        }
    }

    private void fillGroup(IMarkerGroup group, IMenuManager groupMenu) {
        for (IMarker marker : group.getMarkers()) {
            if (marker.isHidden()) continue;
            groupMenu.add(this.makeMarkerCommandContributionItem(marker));
        }
    }

    private IContributionItem makeMarkerCommandContributionItem(IMarker marker) {
        CommandContributionItemParameter parameter = new CommandContributionItemParameter(this.serviceLocator, "addMarker." + marker.getId(), "org.xmind.ui.command.addMarker", 8);
        parameter.label = marker.getName();
        parameter.icon = MarkerImageDescriptor.createFromMarker(marker);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("org.xmind.ui.mindmap.markerId", marker.getId());
        parameter.parameters = params;
        return new CommandContributionItem(parameter);
    }
}

