/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.branch;

import java.util.List;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.xmind.gef.draw2d.IReferencedFigure;
import org.xmind.gef.part.IPart;
import org.xmind.ui.branch.AbstractBranchStructure;
import org.xmind.ui.internal.branch.BaseRadialStructure;
import org.xmind.ui.internal.branch.RadialData;
import org.xmind.ui.internal.branch.RadialUtils;
import org.xmind.ui.mindmap.IBranchPart;
import org.xmind.ui.mindmap.ISummaryPart;
import org.xmind.ui.tools.ParentSearchKey;

public class RadialStructure
extends BaseRadialStructure {
    @Override
    protected void doFillSubBranches(IBranchPart branch, List<IBranchPart> subBranches, AbstractBranchStructure.LayoutInfo info) {
        RadialData cache = this.getRadialData(branch);
        int numRight = cache.getNumRight();
        int[] childrenSpacings = cache.getChildrenSpacings();
        int num = subBranches.size();
        boolean right = true;
        BaseRadialStructure.RadiationInsertion insertion = this.getCurrentInsertion(branch);
        int insHeight = insertion == null ? 0 : insertion.getSize().height;
        int y = -cache.getRightSumSpacing() / 2;
        if (insertion != null && insertion.right) {
            y -= insHeight / 2;
        }
        Point ref = info.getReference();
        int i = 0;
        while (i < num) {
            Rectangle r;
            if (i == numRight) {
                y = -cache.getLeftSumSpacing() / 2;
                if (insertion != null && !insertion.right) {
                    y -= insHeight / 2;
                }
                right = false;
            }
            if (!(insertion == null || i != insertion.getIndex() || i == numRight && insertion.right)) {
                Point p = ref.getTranslated(cache.getX(y, right), y);
                Rectangle insBounds = RadialUtils.getPrefBounds(insertion.getSize(), p, right);
                info.add(insBounds);
                y += insHeight;
            }
            IBranchPart subBranch = subBranches.get(i);
            Dimension offset = this.getOffset(subBranch);
            IFigure subFigure = subBranch.getFigure();
            if (offset != null && subFigure instanceof IReferencedFigure) {
                Point subRef = ref.getTranslated(offset);
                r = ((IReferencedFigure)subFigure).getPreferredBounds(subRef);
            } else {
                int x = cache.getX(y, right);
                Point subRef = ref.getTranslated(x, y);
                r = RadialUtils.getPrefBounds(subBranch, subRef, right);
            }
            info.put(subFigure, r);
            y += childrenSpacings[i];
            if (insertion != null && (i == numRight - 1 && insertion.getIndex() == numRight && insertion.right || i == num)) {
                Point p = ref.getTranslated(cache.getX(y, right), y);
                Rectangle insBounds = RadialUtils.getPrefBounds(insertion.getSize(), p, right);
                info.add(insBounds);
                y += insHeight;
            }
            ++i;
        }
    }

    @Override
    public IPart calcChildNavigation(IBranchPart branch, IBranchPart sourceChild, String navReqType, boolean sequential) {
        if ("navigate_up".equals(navReqType)) {
            return this.getSubTopicPart(branch, sourceChild.getBranchIndex() - 1);
        }
        if ("navigate_down".equals(navReqType)) {
            return this.getSubTopicPart(branch, sourceChild.getBranchIndex() + 1);
        }
        if (!sequential) {
            if ("navigate_right".equals(navReqType)) {
                int numFirst = this.getRadialData(branch).getNumRight();
                if (sourceChild.getBranchIndex() >= numFirst) {
                    return branch.getTopicPart();
                }
            } else if ("navigate_left".equals(navReqType)) {
                int numFirst = this.getRadialData(branch).getNumRight();
                if (sourceChild.getBranchIndex() < numFirst) {
                    return branch.getTopicPart();
                }
            }
        }
        return super.calcChildNavigation(branch, sourceChild, navReqType, sequential);
    }

    @Override
    public int getSummaryDirection(IBranchPart branch, ISummaryPart summary) {
        return super.getSummaryDirection(branch, summary);
    }

    @Override
    protected Point calcMovePosition(IBranchPart branch, IBranchPart child, ParentSearchKey key) {
        List<IBranchPart> subBranches = branch.getSubBranches();
        List<Integer> disables = this.getDisableBranches(branch);
        int index = this.calcInsIndex(branch, key, true);
        int oldIndex = this.getOldIndex(branch, child);
        if (disables != null) {
            if (disables.contains(index - 1)) {
                oldIndex = --index;
            } else if (disables.contains(index)) {
                oldIndex = index;
            }
        }
        RadialData cache = this.getRadialData(branch);
        int subSize = subBranches.size();
        int right = cache.getNumRight();
        Dimension inventSize = key.getInvent().getSize();
        if (index == oldIndex) {
            if (subSize > right && index == right - 1 && key.getCursorPos().x < 0 && !subBranches.get(right).getFigure().isEnabled()) {
                ++index;
            }
            int delta = this.getTopicSize((IBranchPart)subBranches.get((int)index)).width / 2 - inventSize.width / 2;
            int deltaX = index < right ? -delta : delta;
            return this.getReference(subBranches.get(index)).getTranslated(deltaX, 0);
        }
        return this.calcInsertPosition(branch, child, key);
    }

    @Override
    protected Point calcInsertPosition(IBranchPart branch, IBranchPart child, ParentSearchKey key) {
        List<IBranchPart> subBranches = branch.getSubBranches();
        Point firstLoc = this.calcFirstChildPosition(branch, key).getTranslated(key.getInvent().getSize().width / 2, 0);
        if (subBranches.isEmpty()) {
            return firstLoc;
        }
        int index = this.calcInsIndex(branch, key, true);
        RadialData cache = this.getRadialData(branch);
        int subSize = subBranches.size();
        int right = cache.getNumRight();
        int left = subSize - right;
        Dimension insSize = key.getFigure().getSize();
        Dimension inventSize = key.getInvent().getSize();
        IBranchPart first = subBranches.get(0);
        Rectangle fBounds = first.getFigure().getBounds();
        if (index == 0) {
            int x = fBounds.x + inventSize.width / 2;
            int y = fBounds.y - (insSize.height + inventSize.height) / 2;
            return new Point(x, y);
        }
        if (index == subSize || index == -1) {
            if (subSize == 1 && this.isWithinThreshold(first)) {
                if (fBounds.bottom() > 0) {
                    int x = fBounds.x + inventSize.width / 2;
                    int y = fBounds.bottom() + (insSize.height + inventSize.height) / 2;
                    return new Point(x, y);
                }
                return new Point(firstLoc.x, -firstLoc.y);
            }
            if (left == 0) {
                return new Point(-firstLoc.x, firstLoc.y);
            }
            IBranchPart sub = subBranches.get(subSize - 1);
            Rectangle bounds = sub.getFigure().getBounds();
            if (left == 1 && bounds.bottom() < 0) {
                return firstLoc.getNegated();
            }
            int x = bounds.right() - inventSize.width / 2;
            int y = bounds.bottom() + (insSize.height + inventSize.height) / 2;
            return new Point(x, y);
        }
        if (index == right) {
            int y;
            int x;
            boolean isRight = left == 1 && right == 1 || this.isRight(subBranches, child, right);
            IBranchPart sub = isRight ? subBranches.get(index - 1) : subBranches.get(index);
            Rectangle bounds = sub.getFigure().getBounds();
            if (isRight) {
                x = bounds.x + inventSize.width / 2;
                y = bounds.bottom() + (insSize.height + inventSize.height) / 2;
            } else {
                x = bounds.right() - inventSize.width / 2;
                y = bounds.y - (insSize.height + inventSize.height) / 2;
            }
            return new Point(x, y);
        }
        return this.calcInventPosition(subBranches.get(index - 1), subBranches.get(index), key, index < right);
    }
}

