/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.layouts;

import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.xmind.gef.draw2d.IReferencedFigure;
import org.xmind.gef.draw2d.ReferencedLayoutData;
import org.xmind.gef.draw2d.geometry.Geometry;
import org.xmind.gef.part.IGraphicalPart;
import org.xmind.gef.part.IPart;
import org.xmind.ui.internal.layouts.MindMapLayoutBase;
import org.xmind.ui.internal.layouts.SheetIntersectionSolver;
import org.xmind.ui.mindmap.IBranchPart;
import org.xmind.ui.mindmap.ISheetPart;
import org.xmind.ui.mindmap.MindMapUI;
import org.xmind.ui.util.MindMapUtils;

public class SheetLayout
extends MindMapLayoutBase {
    private SheetIntersectionSolver intersectionSolver = new SheetIntersectionSolver();

    public SheetLayout(ISheetPart sheet) {
        super(sheet);
    }

    protected ISheetPart getSheet() {
        return (ISheetPart)super.getPart();
    }

    private boolean needsSolveIntersections() {
        return !MindMapUI.isOverlapsAllowed();
    }

    protected void fillLayoutData(IFigure container, ReferencedLayoutData data) {
        Point ref = data.getReference();
        ISheetPart sheet = this.getSheet();
        this.intersectionSolver.setOrigin(ref);
        this.intersectionSolver.recordInitPositions(sheet, true);
        if (this.needsSolveIntersections()) {
            this.intersectionSolver.solve();
        }
        Rectangle freeBranchesBounds = null;
        for (Object key : this.intersectionSolver.getKeys("free")) {
            if (!(key instanceof IGraphicalPart)) continue;
            IFigure figure = ((IGraphicalPart)key).getFigure();
            Rectangle rect = this.intersectionSolver.getSolvedBounds(key);
            if (key instanceof IBranchPart && ((IBranchPart)key).getParentBranch() != null) {
                IBranchPart branch = (IBranchPart)key;
                Point pos = this.intersectionSolver.getSolvedPosition(key);
                MindMapUtils.setCache((IPart)branch, "org.xmind.ui.cache.preferredPosition", pos);
                freeBranchesBounds = Geometry.union(freeBranchesBounds, (Rectangle)rect);
                continue;
            }
            data.put(figure, rect);
        }
        IBranchPart centralBranch = sheet.getCentralBranch();
        if (centralBranch != null) {
            IFigure centralBranchFigure = centralBranch.getFigure();
            Rectangle centralBranchBounds = ((IReferencedFigure)centralBranchFigure).getPreferredBounds(ref);
            centralBranchBounds = Geometry.union((Rectangle)centralBranchBounds, freeBranchesBounds);
            data.put(centralBranchFigure, centralBranchBounds);
        }
        this.intersectionSolver.clear();
    }
}

