/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.notes;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.xmind.core.INotes;
import org.xmind.core.INotesContent;
import org.xmind.core.IPlainNotesContent;
import org.xmind.core.ITopic;
import org.xmind.core.event.CoreEvent;
import org.xmind.core.event.ICoreEventRegister;
import org.xmind.gef.command.Command;
import org.xmind.gef.ui.actions.IActionRegistry;
import org.xmind.gef.ui.editor.IGraphicalEditor;
import org.xmind.ui.actions.DelegatingAction;
import org.xmind.ui.actions.MindMapActionFactory;
import org.xmind.ui.commands.DeleteNotesCommand;
import org.xmind.ui.internal.MindMapMessages;
import org.xmind.ui.internal.utils.E4Utils;
import org.xmind.ui.mindmap.AbstractInfoItemContributor;
import org.xmind.ui.mindmap.IInfoPart;
import org.xmind.ui.mindmap.ITopicPart;
import org.xmind.ui.mindmap.MindMapUI;

public class NotesInfoItemContributor
extends AbstractInfoItemContributor {
    private static final String PRESENTATION_VIERWER_CLASS_NAME = "PresentationViewer";

    @Override
    public IAction createAction(ITopicPart topicPart, ITopic topic) {
        INotesContent content;
        INotes notes = topic.getNotes();
        if (notes.isEmpty()) {
            return null;
        }
        Object action = null;
        IActionRegistry actionRegistry = (IActionRegistry)topicPart.getAdapter(IActionRegistry.class);
        if (actionRegistry != null && (action = actionRegistry.getAction(MindMapActionFactory.EDIT_NOTES.getId())) != null) {
            action = new DelegatingAction((IAction)action);
        }
        if (action == null || action.getImageDescriptor() == null) {
            action = new ShowNotesAction(topicPart);
        }
        if ((content = notes.getContent("plain")) instanceof IPlainNotesContent) {
            String text = ((IPlainNotesContent)content).getTextContent();
            if (text.length() > 500) {
                text = String.valueOf(text.substring(0, 500)) + "...\n...";
            }
            action.setToolTipText(text);
        }
        action.setEnabled(true);
        return action;
    }

    @Override
    public String getContent(ITopic topic) {
        INotes notes = topic.getNotes();
        if (notes.isEmpty()) {
            return null;
        }
        INotesContent content = notes.getContent("plain");
        if (content instanceof IPlainNotesContent) {
            return ((IPlainNotesContent)content).getTextContent().replaceAll("\r\n|\r|\n", " ");
        }
        return null;
    }

    @Override
    public String getSVGFilePath(ITopic topic, IAction action) {
        return "platform:/plugin/org.xmind.ui.mindmap/icons/notes.svg";
    }

    @Override
    public boolean isCardModeAvailable(ITopic topic, ITopicPart topicPart) {
        return !this.isIconTipOnly(topicPart);
    }

    @Override
    protected void registerTopicEvent(ITopicPart topicPart, ITopic topic, ICoreEventRegister register) {
        register.register("topicNotes");
    }

    @Override
    protected void handleTopicEvent(IInfoPart infoPart, CoreEvent event) {
        infoPart.refresh();
    }

    @Override
    protected void handleTopicEvent(ITopicPart topicPart, CoreEvent event) {
        topicPart.refresh();
    }

    public void removeNotes(ITopic topic) {
        if (topic == null) {
            return;
        }
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window == null) {
            return;
        }
        IGraphicalEditor editor = (IGraphicalEditor)window.getActivePage().getActiveEditor();
        if (editor == null) {
            return;
        }
        DeleteNotesCommand removeCommand = new DeleteNotesCommand(topic);
        if (removeCommand != null) {
            editor.getCommandStack().execute((Command)removeCommand);
        }
    }

    @Override
    public List<IAction> getPopupMenuActions(ITopicPart topicPart, final ITopic topic) {
        ArrayList<IAction> actions = new ArrayList<IAction>();
        IAction editNotesAction = this.createAction(topicPart, topic);
        editNotesAction.setText(MindMapMessages.ModifyMenu);
        editNotesAction.setImageDescriptor(null);
        Action deleteNotesAction = new Action(MindMapMessages.InfoItem_Delete_text){

            public void run() {
                NotesInfoItemContributor.this.removeNotes(topic);
            }
        };
        deleteNotesAction.setId("org.xmind.ui.removeNotes");
        deleteNotesAction.setImageDescriptor(null);
        actions.add(editNotesAction);
        actions.add((IAction)deleteNotesAction);
        return actions;
    }

    private static class ShowNotesAction
    extends Action {
        private ITopicPart topicPart;

        public ShowNotesAction(ITopicPart topicPart) {
            super(MindMapMessages.EditNotes_text, MindMapUI.getImages().get("notes.png", true));
            this.setId(MindMapActionFactory.EDIT_NOTES.getId());
            this.setDisabledImageDescriptor(MindMapUI.getImages().get("notes.png", false));
            this.topicPart = topicPart;
        }

        public void run() {
            if (this.topicPart == null || this.topicPart.getSite() == null || this.topicPart.getSite().getViewer() == null || this.topicPart.getSite().getViewer().getClass().getSimpleName().equals(NotesInfoItemContributor.PRESENTATION_VIERWER_CLASS_NAME)) {
                return;
            }
            if (!this.topicPart.getStatus().isActive()) {
                return;
            }
            final IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
            if (window == null) {
                return;
            }
            Display.getCurrent().asyncExec(new Runnable(){

                @Override
                public void run() {
                    E4Utils.showPart("org.xmind.ui.command.showModelPart", window, "org.xmind.ui.modelPart.notes", null, "org.xmind.ui.stack.right");
                }
            });
        }
    }
}

