/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.core.audio.device;

import java.util.ArrayList;
import java.util.List;
import org.xmind.core.audio.AudioValues;
import org.xmind.core.audio.IAudioChannel;
import org.xmind.core.audio.IAudioDevice;
import org.xmind.core.audio.IAudioProcessErroHandler;
import org.xmind.core.audio.IAudioProcessListener;
import org.xmind.core.audio.IAudioSource;
import org.xmind.core.audio.IAudioTarget;

public abstract class AudioChannelBase
implements IAudioChannel {
    private List<IAudioProcessListener> listeners = null;
    private IAudioProcessErroHandler errorHandler = null;
    private IAudioDevice device;
    private IAudioSource source;
    private IAudioTarget target;
    private boolean closed = false;
    private boolean isJumping = false;

    public AudioChannelBase(IAudioDevice device, IAudioSource source, IAudioTarget target) {
        this.device = device;
        this.source = source;
        this.target = target;
    }

    public IAudioDevice getDevice() {
        return this.device;
    }

    public IAudioSource getSource() {
        return this.source;
    }

    public IAudioTarget getTarget() {
        return this.target;
    }

    public boolean isOpen() {
        return !this.closed;
    }

    public boolean isRunning() {
        return this.isOpen();
    }

    protected void markClosed() {
        if (!this.isJumping) {
            this.closed = true;
        }
    }

    protected void setJumping() {
        this.isJumping = true;
    }

    protected void jumpFinished() {
        this.isJumping = false;
    }

    protected boolean isJumping() {
        return this.isJumping;
    }

    public void close() throws Exception {
        this.markClosed();
    }

    public synchronized void addAudioProcessListener(IAudioProcessListener listener) {
        if (this.listeners == null) {
            this.listeners = new ArrayList<IAudioProcessListener>();
        }
        this.listeners.add(listener);
    }

    public synchronized void removeAudioProcessListener(IAudioProcessListener listener) {
        if (this.listeners != null) {
            this.listeners.remove(listener);
        }
    }

    public void setErrorHandler(IAudioProcessErroHandler errorHandler) {
        this.errorHandler = errorHandler;
    }

    protected void fireStopped() {
        if (this.listeners == null) {
            return;
        }
        Object[] objectArray = this.listeners.toArray();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object l = objectArray[n2];
            ((IAudioProcessListener)l).audioProcessStopped(this);
            ++n2;
        }
    }

    protected void fireValueChanged(AudioValues values) {
        if (this.listeners == null) {
            return;
        }
        Object[] objectArray = this.listeners.toArray();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object l = objectArray[n2];
            ((IAudioProcessListener)l).audioProcessValueChanged(this, values);
            ++n2;
        }
    }

    protected boolean handleError(Throwable exception) {
        if (this.errorHandler != null && this.errorHandler.handleAudioProcessError(this, exception)) {
            return true;
        }
        IAudioProcessErroHandler globalErrorHandler = this.getDevice().getChannelErrorHandler();
        if (globalErrorHandler != null && globalErrorHandler.handleAudioProcessError(this, exception)) {
            return true;
        }
        return this.internalHandleError(exception);
    }

    protected boolean internalHandleError(Throwable exception) {
        return false;
    }
}

