// SPDX-License-Identifier: GPL-2.0-or-later
// SPDX-FileCopyrightText: 2011 Konrad Twardowski

// A basic password protection

#pragma once

#include "udialog.h"

#ifdef KS_KF5
	#include <KNewPasswordDialog>
#endif // KS_KF5

#include <QCheckBox>
#include <QListWidget>

class InfoWidget;

class PasswordDialog final:
	#ifdef KS_KF5
	public KNewPasswordDialog {
	#else
	public UDialog {
	#endif // KS_KF5
public:
	explicit PasswordDialog(QWidget *parent);
	virtual ~PasswordDialog();
	void apply();
	static bool authorize(QWidget *parent, const QString &caption, const QString &userAction);
	static bool authorizeQuit(QWidget *parent);
	static bool authorizeSettings(QWidget *parent);
	static void clearPassword(QString &password);
	static QString toHash(const QString &password);
private:
	Q_DISABLE_COPY(PasswordDialog)
	inline static const int MIN_LENGTH = 12;
	#ifdef KS_PURE_QT
	QLineEdit *m_confirmPassword;
	QLineEdit *m_password;
	void updateStatus();
	#endif // KS_PURE_QT
};

class PasswordPreferences final: public QWidget {
public:
	explicit PasswordPreferences(QWidget *parent);
	virtual ~PasswordPreferences() = default;
	void apply();
private:
	Q_DISABLE_COPY(PasswordPreferences)
	int m_configKeyRole;
	QCheckBox *m_enablePassword;
	QListWidget *m_userActionList;
	QListWidgetItem *addItem(const QString &key, const QString &text, const QIcon &icon);
	void updateWidgets(const bool passwordEnabled);

	// event handlers:
	void onEnablePassword(bool checked);
};
