// Setup helpers for other tests to use
// SPDX-FileCopyrightText: 2025 <copyright holder> <email>
// SPDX-License-Identifier: GPL-2.0-only OR GPL-3.0-only OR LicenseRef-KDE-Accepted-GPL

#ifndef TESTHELPERS_H
#define TESTHELPERS_H

#include <QIODevice>
#include <QDir>
#include <QFile>
#include <QList>
#include <QString>
#include <QPair>
#include <QTest>


/**
* Setup helpers for other tests to use
*/
namespace TestHelpers
{
	static QDir* baseTestDir;

	static void initTestDir() {
		//Make our test dir in /tmp
		if (QDir::temp().exists("kuroo_test"))
			QDir(QDir::tempPath() + "/kuroo_test").removeRecursively();
		QDir::temp().mkdir("kuroo_test");
		baseTestDir = new QDir(QDir::tempPath() + "/kuroo_test");
	};

	static void cleanupTestDir() {
		//Clean up our test dir
		if (baseTestDir) baseTestDir->removeRecursively();
	};

	static void writeFilesInTestDir(QList<QPair<QString, const char*>> contents) {
		for ( const auto& [testFilePath, content] : std::as_const(contents) ) {
			QFileInfo fi(baseTestDir->path() + u'/' + testFilePath);
			if (!fi.dir().exists()) fi.dir().mkpath(fi.dir().path());
			QFile testFlatFile(baseTestDir->path() + u'/' + testFilePath);
			QVERIFY(testFlatFile.open(QIODeviceBase::WriteOnly));
			testFlatFile.write(content);
			testFlatFile.close();
		}
	};
};

#endif // TESTHELPERS_H
