/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.jetty.servlet.jmx;

import javax.management.MBeanException;
import javax.management.ObjectName;
import org.mortbay.http.jmx.HttpHandlerMBean;
import org.mortbay.jetty.servlet.ServletHandler;
import org.mortbay.jetty.servlet.SessionManager;

public class ServletHandlerMBean
extends HttpHandlerMBean {
    private ServletHandler _servletHandler;

    protected void defineManagedResource() {
        super.defineManagedResource();
        this.defineAttribute("usingCookies");
        this.defineAttribute("servlets", false, true);
        this.defineAttribute("sessionManager", false, true);
        this._servletHandler = (ServletHandler)this.getManagedResource();
    }

    public ObjectName getSessionManager() {
        SessionManager sm = this._servletHandler.getSessionManager();
        if (sm == null) {
            return null;
        }
        ObjectName[] on = this.getComponentMBeans(new Object[]{sm}, null);
        return on[0];
    }

    public ObjectName[] getServlets() {
        return this.getComponentMBeans(this._servletHandler.getServlets(), null);
    }

    public void postRegister(Boolean ok) {
        super.postRegister(ok);
        if (ok.booleanValue()) {
            this.getSessionManager();
        }
    }
}

