#!/usr/local/bin/perl -w
################################################################################
# merge SEQUENCE and ALIGNMENT.sort
################################################################################

use strict;
use File::Basename "basename";
use Getopt::Long "GetOptions";

sub Help {
    my ($exit) = @_;
    $exit = 0 unless (defined $exit);
    my $name = basename($0);
    print <<EndText;
Usage:
    $name --sequence <sequence dump> --alignment <alignments dump>

    Merge ordered sequence and alignment files
    generated by vdb_dump_sequence.pl and vdb_dump_alignments.pl
EndText

    exit $exit;
}

my %options;
Help(1) unless (GetOptions(\%options, "help", "alignment=s", "sequence=s"));
Help(0) if ($options{help});
Help(1) unless ($options{alignment} && $options{sequence});

my $name = 'SEQUENCE';
$name = $options{sequence};
open SEQ, $name or die "cannot open $name";

$name = 'ALIGNMENT.sort';
$name = $options{alignment};
open ALG, $name or die "cannot open $name";

chomp (my $HEADER_ALG = <ALG>);
my $alignment = <ALG>;
die unless ($alignment);
chomp $alignment;
my ($primOrSeq, $algSPOT_ID, $SEQ_SPOT_ID, $SEQ_READ_ID, @rest)
    = split /\t/, $alignment;
die $alignment unless ($primOrSeq && $algSPOT_ID && $SEQ_SPOT_ID && @rest);

my $HEADED;
my $HEADER_SEQ = '';
while (<SEQ>) {
    my $found;
    chomp;
    if (/^>/) {
        $HEADER_SEQ = $_;
        next;
    }
    my ($seqSPOT_ID, $flags, $READ, $QUALITY, $side, $PRIMARY_ALIGNMENT_ID)
        = split /\t/;
    die $_ unless ($seqSPOT_ID);
    unless ($SEQ_SPOT_ID)
    {   die "$_" if ($side || $PRIMARY_ALIGNMENT_ID); }
    unless ($HEADED) {
    print
  ">SPOT_ID\t>flags\treads\tscores\tside\tPRIMARY_ALIGNMENT_ID\t$HEADER_ALG\n";
        ++$HEADED;
    }
    if ($seqSPOT_ID != $SEQ_SPOT_ID)
    {   print "$_\n" }
    unless ($side || $PRIMARY_ALIGNMENT_ID) {
        die $_ if ($found);
        $found = 1;
        $_ .= "\t\t";
    }
    else {
        if    ($side eq 'L') {
            $side = 1
        } elsif ($side eq 'R') {
            $side = 2
        } else { die $_ }
    }
    while ($seqSPOT_ID == $SEQ_SPOT_ID) {
        die $_ unless ($side);
        if ($side == $SEQ_READ_ID) {
            if ($primOrSeq eq 'PRIMARY' && $algSPOT_ID == $PRIMARY_ALIGNMENT_ID)
            {
                die "$_\n$alignment" if ($found);
                $found = 1;
            }
            print "$_\t$alignment\n";
            $alignment = <ALG>;
            unless ($alignment) {
                $SEQ_SPOT_ID = 0;
                last;
            }
            chomp $alignment;
            ($primOrSeq, $algSPOT_ID, $SEQ_SPOT_ID, $SEQ_READ_ID, @rest)
                = split /\t/, $alignment;
            die $alignment unless ($primOrSeq && $algSPOT_ID && $SEQ_SPOT_ID);
        } elsif ($side > $SEQ_READ_ID) {
            die "$_\n$alignment"
        } else {
            last
        }
    }
}

die $alignment if ($alignment);
$alignment = <ALG>;

die $alignment if ($alignment);

close SEQ;
close ALG;

################################################################################
# EOF #
