/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.cache.internal;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import java.io.Closeable;
import java.io.File;
import java.io.FileFilter;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.SortedSet;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.FileFilterUtils;
import org.apache.commons.io.filefilter.RegexFileFilter;
import org.apache.commons.lang.StringUtils;
import org.gradle.cache.CleanupProgressMonitor;
import org.gradle.cache.internal.UsedGradleVersions;
import org.gradle.internal.IoActions;
import org.gradle.internal.cache.MonitoredCleanupAction;
import org.gradle.util.GradleVersion;
import org.gradle.util.internal.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WrapperDistributionCleanupAction
implements MonitoredCleanupAction {
    public static final String WRAPPER_DISTRIBUTION_FILE_PATH = "wrapper/dists";
    private static final Logger LOGGER = LoggerFactory.getLogger(WrapperDistributionCleanupAction.class);
    private static final ImmutableMap<String, Pattern> JAR_FILE_PATTERNS_BY_PREFIX;
    private static final String BUILD_RECEIPT_ZIP_ENTRY_PATH;
    private final File distsDir;
    private final UsedGradleVersions usedGradleVersions;

    public WrapperDistributionCleanupAction(File gradleUserHomeDirectory, UsedGradleVersions usedGradleVersions) {
        this.distsDir = new File(gradleUserHomeDirectory, WRAPPER_DISTRIBUTION_FILE_PATH);
        this.usedGradleVersions = usedGradleVersions;
    }

    @Nonnull
    public String getDisplayName() {
        return "Deleting unused Gradle distributions in " + this.distsDir;
    }

    public boolean execute(@Nonnull CleanupProgressMonitor progressMonitor) {
        long maximumTimestamp = Math.max(0L, System.currentTimeMillis() - TimeUnit.DAYS.toMillis(1L));
        SortedSet usedVersions = this.usedGradleVersions.getUsedGradleVersions();
        Multimap<GradleVersion, File> checksumDirsByVersion = this.determineChecksumDirsByVersion();
        for (GradleVersion version : checksumDirsByVersion.keySet()) {
            if (!usedVersions.contains(version) && version.compareTo(GradleVersion.current()) < 0) {
                this.deleteDistributions(version, checksumDirsByVersion.get((Object)version), maximumTimestamp, progressMonitor);
                continue;
            }
            progressMonitor.incrementSkipped((long)checksumDirsByVersion.get((Object)version).size());
        }
        return true;
    }

    private void deleteDistributions(GradleVersion version, Collection<File> dirs, long maximumTimestamp, CleanupProgressMonitor progressMonitor) {
        LinkedHashSet<File> parentsOfDeletedDistributions = new LinkedHashSet<File>();
        for (File checksumDir : dirs) {
            if (checksumDir.lastModified() > maximumTimestamp) {
                progressMonitor.incrementSkipped();
                LOGGER.debug("Skipping distribution for {} at {} because it was recently added", (Object)version, (Object)checksumDir);
                continue;
            }
            progressMonitor.incrementDeleted();
            LOGGER.debug("Marking distribution for {} at {} unusable", (Object)version, (Object)checksumDir);
            File[] markerFiles = checksumDir.listFiles((File dir, String name) -> name.endsWith(".ok"));
            boolean canBeDeleted = true;
            if (markerFiles != null) {
                for (File markerFile : markerFiles) {
                    canBeDeleted &= markerFile.delete();
                }
            }
            if (canBeDeleted) {
                if (FileUtils.deleteQuietly((File)checksumDir)) {
                    parentsOfDeletedDistributions.add(checksumDir.getParentFile());
                    continue;
                }
                LOGGER.info("Distribution for {} at {} was not completely deleted.", (Object)version, (Object)checksumDir);
                continue;
            }
            LOGGER.info("Distribution for {} at {} cannot be deleted because Gradle is unable to mark it as unusable.", (Object)version, (Object)checksumDir);
        }
        for (File parentDir : parentsOfDeletedDistributions) {
            if (!this.listFiles(parentDir).isEmpty()) continue;
            parentDir.delete();
        }
    }

    private Multimap<GradleVersion, File> determineChecksumDirsByVersion() {
        ArrayListMultimap result = ArrayListMultimap.create();
        for (File dir : this.listDirs(this.distsDir)) {
            for (File checksumDir : this.listDirs(dir)) {
                try {
                    GradleVersion gradleVersion = this.determineGradleVersionFromBuildReceipt(checksumDir);
                    result.put((Object)gradleVersion, (Object)checksumDir);
                }
                catch (Exception e) {
                    LOGGER.debug("Could not determine Gradle version for {}: {} ({})", new Object[]{checksumDir, e.getMessage(), e.getClass().getName()});
                }
            }
        }
        return result;
    }

    private GradleVersion determineGradleVersionFromBuildReceipt(File checksumDir) throws Exception {
        List<File> subDirs = this.listDirs(checksumDir);
        Preconditions.checkArgument((subDirs.size() == 1 ? 1 : 0) != 0, (String)"A Gradle distribution must contain exactly one subdirectory: %s", subDirs);
        return this.determineGradleVersionFromDistribution((File)CollectionUtils.single(subDirs));
    }

    @VisibleForTesting
    protected GradleVersion determineGradleVersionFromDistribution(File distributionHomeDir) throws Exception {
        ArrayList<File> checkedJarFiles = new ArrayList<File>();
        for (Map.Entry entry : JAR_FILE_PATTERNS_BY_PREFIX.entrySet()) {
            List<File> jarFiles = this.listFiles(new File(distributionHomeDir, "lib"), (FileFilter)new RegexFileFilter((Pattern)entry.getValue()));
            if (jarFiles.isEmpty()) continue;
            Preconditions.checkArgument((jarFiles.size() == 1 ? 1 : 0) != 0, (String)"A Gradle distribution must contain at most one %s-*.jar: %s", entry.getKey(), jarFiles);
            File jarFile = (File)CollectionUtils.single(jarFiles);
            GradleVersion gradleVersion = this.readGradleVersionFromJarFile(jarFile);
            if (gradleVersion != null) {
                return gradleVersion;
            }
            checkedJarFiles.add(jarFile);
        }
        throw new IllegalArgumentException("No checked JAR file contained a build receipt: " + checkedJarFiles);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private GradleVersion readGradleVersionFromJarFile(File jarFile) throws Exception {
        GradleVersion gradleVersion;
        ZipFile zipFile = null;
        try {
            zipFile = new ZipFile(jarFile);
            gradleVersion = this.readGradleVersionFromBuildReceipt(zipFile);
        }
        catch (Throwable throwable) {
            IoActions.closeQuietly(zipFile);
            throw throwable;
        }
        IoActions.closeQuietly((Closeable)zipFile);
        return gradleVersion;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private GradleVersion readGradleVersionFromBuildReceipt(ZipFile zipFile) throws Exception {
        ZipEntry zipEntry = zipFile.getEntry(BUILD_RECEIPT_ZIP_ENTRY_PATH);
        if (zipEntry == null) {
            return null;
        }
        try (InputStream in = zipFile.getInputStream(zipEntry);){
            Properties properties = new Properties();
            properties.load(in);
            String versionString = properties.getProperty("versionNumber");
            GradleVersion gradleVersion = GradleVersion.version((String)versionString);
            return gradleVersion;
        }
    }

    private List<File> listDirs(File baseDir) {
        return this.listFiles(baseDir, (FileFilter)FileFilterUtils.directoryFileFilter());
    }

    private List<File> listFiles(File baseDir) {
        return this.listFiles(baseDir, null);
    }

    private List<File> listFiles(File baseDir, @Nullable FileFilter filter) {
        File[] dirs = baseDir.listFiles(filter);
        return dirs == null ? Collections.emptyList() : Arrays.asList(dirs);
    }

    static {
        BUILD_RECEIPT_ZIP_ENTRY_PATH = StringUtils.removeStart((String)"/org/gradle/build-receipt.properties", (String)"/");
        ImmutableSet prefixes = ImmutableSet.of((Object)"gradle-base-services", (Object)"gradle-version-info", (Object)"gradle-core");
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (String prefix : prefixes) {
            builder.put((Object)prefix, (Object)Pattern.compile('^' + Pattern.quote(prefix) + "-\\d.+.jar$"));
        }
        JAR_FILE_PATTERNS_BY_PREFIX = builder.build();
    }
}

