/*
 * Decompiled with CFR 0.152.
 */
package org.argouml.language.java.reveng.classfile;

import antlr.ANTLRException;
import antlr.RecognitionException;
import antlr.TokenStreamException;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import org.argouml.kernel.Project;
import org.argouml.language.java.reveng.JavaImportSettings;
import org.argouml.language.java.reveng.Modeller;
import org.argouml.language.java.reveng.classfile.ClassfileParser;
import org.argouml.language.java.reveng.classfile.ClassfileTreeParser;
import org.argouml.language.java.reveng.classfile.SimpleByteLexer;
import org.argouml.profile.Profile;
import org.argouml.taskmgmt.ProgressMonitor;
import org.argouml.uml.reveng.FileImportUtils;
import org.argouml.uml.reveng.ImportInterface;
import org.argouml.uml.reveng.ImportSettings;
import org.argouml.uml.reveng.ImporterManager;
import org.argouml.uml.reveng.SettingsTypes;
import org.argouml.util.SuffixFilter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassfileImport
implements ImportInterface {
    private Collection secondPassFiles;
    private Profile javaProfile = null;
    private Collection newElements;
    private int fileCount;

    public Collection parseFiles(Project p, Collection<File> files, ImportSettings settings, ProgressMonitor monitor) throws ImportInterface.ImportException {
        this.secondPassFiles = new ArrayList();
        this.newElements = new HashSet();
        this.javaProfile = this.getJavaProfile(p);
        monitor.setMaximumProgress(this.countFiles(files));
        for (File file : files) {
            monitor.updateMainTask("Parsing file: " + file);
            if (monitor.isCanceled()) break;
            this.processFile(p, file, monitor);
            monitor.updateProgress(this.fileCount++);
        }
        if (this.count2ndPassFiles(this.secondPassFiles) > 0 && !monitor.isCanceled()) {
            for (File next : this.secondPassFiles) {
                try {
                    FileInputStream fis;
                    if (next instanceof Collection) {
                        this.do2ndJarPass(p, (Collection)((Object)next), monitor);
                        continue;
                    }
                    File nextFile = next;
                    String fileName = nextFile.getName();
                    try {
                        fis = new FileInputStream(nextFile);
                    }
                    catch (FileNotFoundException e) {
                        throw new ImportInterface.ImportException((Throwable)e);
                    }
                    monitor.updateSubTask("Parsing class 2nd pass - " + fileName);
                    if (monitor.isCanceled()) break;
                    this.parseFile(p, fis, fileName);
                    monitor.updateProgress(this.fileCount++);
                }
                catch (ANTLRException e) {
                    throw new ImportInterface.ImportException((Throwable)e);
                }
                catch (IOException e) {
                    throw new ImportInterface.ImportException((Throwable)e);
                }
            }
        }
        return this.newElements;
    }

    private int countFiles(Collection<File> files) {
        int total = 0;
        for (File f : files) {
            if (f.getName().endsWith(".jar")) {
                try {
                    Enumeration<JarEntry> e = new JarFile(f).entries();
                    while (e.hasMoreElements()) {
                        ZipEntry entry = e.nextElement();
                        if (entry.isDirectory() || !entry.getName().endsWith(".class")) continue;
                        ++total;
                    }
                    continue;
                }
                catch (IOException e) {
                    ++total;
                    continue;
                }
            }
            ++total;
        }
        return total;
    }

    private int count2ndPassFiles(Collection buffer) {
        int nfiles = 0;
        for (Object next : this.secondPassFiles) {
            nfiles += next instanceof Collection ? ((Collection)next).size() - 1 : 1;
        }
        return nfiles;
    }

    private void processFile(Project p, File f, ProgressMonitor monitor) throws ImportInterface.ImportException {
        monitor.updateMainTask("Importing " + f.getName());
        if (f.getName().endsWith(".jar")) {
            this.processJarFile(p, f, monitor);
        } else {
            String fileName = f.getName();
            try {
                FileInputStream is;
                try {
                    is = new FileInputStream(f);
                }
                catch (FileNotFoundException e) {
                    throw new ImportInterface.ImportException((Throwable)e);
                }
                this.parseFile(p, is, fileName);
            }
            catch (ANTLRException e) {
                this.secondPassFiles.add(f);
            }
        }
    }

    private void processJarFile(Project p, File f, ProgressMonitor monitor) throws ImportInterface.ImportException {
        JarFile jarfile;
        try {
            jarfile = new JarFile(f);
        }
        catch (IOException e) {
            throw new ImportInterface.ImportException("IO exception opening Jar file: " + f, (Throwable)e);
        }
        ArrayList<Object> jarSecondPassFiles = new ArrayList<Object>();
        Enumeration<JarEntry> e = jarfile.entries();
        while (e.hasMoreElements()) {
            JarEntry entry = e.nextElement();
            String entryName = entry.getName();
            if (entry.isDirectory() || !entryName.endsWith(".class")) continue;
            try {
                InputStream is;
                try {
                    is = jarfile.getInputStream(entry);
                }
                catch (IOException e1) {
                    throw new ImportInterface.ImportException((Throwable)e1);
                }
                monitor.updateSubTask("Parsing class - " + entryName);
                if (monitor.isCanceled()) break;
                this.parseFile(p, is, entryName);
                monitor.updateProgress(this.fileCount++);
            }
            catch (ANTLRException e1) {
                if (jarSecondPassFiles.isEmpty()) {
                    jarSecondPassFiles.add(f);
                }
                jarSecondPassFiles.add(entryName);
            }
        }
        if (!jarSecondPassFiles.isEmpty()) {
            this.secondPassFiles.add(jarSecondPassFiles);
        }
        try {
            jarfile.close();
        }
        catch (IOException e2) {
            throw new ImportInterface.ImportException("IO exception closing Jar file: " + f, (Throwable)e2);
        }
    }

    private void do2ndJarPass(Project p, Collection secondPassBuffer, ProgressMonitor monitor) throws IOException, RecognitionException, TokenStreamException {
        if (!secondPassBuffer.isEmpty()) {
            Iterator iterator = secondPassBuffer.iterator();
            JarFile jarfile = new JarFile((File)iterator.next());
            while (iterator.hasNext()) {
                String filename = (String)iterator.next();
                monitor.updateSubTask("Parsing class 2nd pass - " + filename);
                if (monitor.isCanceled()) break;
                this.parseFile(p, jarfile.getInputStream(jarfile.getEntry(filename)), filename);
                monitor.updateProgress(this.fileCount++);
            }
            jarfile.close();
        }
    }

    public void parseFile(Project p, InputStream is, String fileName) throws RecognitionException, TokenStreamException {
        int lastSlash = fileName.lastIndexOf(47);
        if (lastSlash != -1) {
            fileName = fileName.substring(lastSlash + 1);
        }
        ClassfileParser parser = new ClassfileParser(new SimpleByteLexer(new BufferedInputStream(is)));
        parser.classfile();
        Modeller modeller = new Modeller(p.getUserDefinedModelList().get(0), this.javaProfile, JavaImportSettings.getInstance().isAttributeSelected(), JavaImportSettings.getInstance().isDatatypeSelected(), fileName);
        ClassfileTreeParser tparser = new ClassfileTreeParser();
        tparser.classfile(parser.getAST(), modeller);
        this.newElements.addAll(modeller.getNewElements());
    }

    public boolean enable() {
        ImporterManager.getInstance().addImporter((ImportInterface)this);
        return true;
    }

    public boolean disable() {
        return true;
    }

    public String getName() {
        return "Java from classes";
    }

    public String getInfo(int type) {
        switch (type) {
            case 1: {
                return "The ArgoUML project team";
            }
            case 0: {
                return "Java import from class or jar files";
            }
            case 2: {
                return "0.33.8";
            }
            case 3: {
                return "http://argouml-java.tigris.org/";
            }
        }
        return null;
    }

    public SuffixFilter[] getSuffixFilters() {
        SuffixFilter[] result = new SuffixFilter[]{new SuffixFilter(new String[]{"class", "jar"}, "Java files"), new SuffixFilter("class", "Java class files"), new SuffixFilter("jar", "Java JAR files")};
        return result;
    }

    public boolean isParseable(File file) {
        return FileImportUtils.matchesSuffix((Object)file, (SuffixFilter[])this.getSuffixFilters());
    }

    public List<SettingsTypes.Setting> getImportSettings() {
        return JavaImportSettings.getInstance().getImportSettings();
    }

    private Profile getJavaProfile(Project p) {
        for (Profile profile : p.getProfileConfiguration().getProfiles()) {
            if (!"Java".equals(profile.getDisplayName())) continue;
            return profile;
        }
        return null;
    }
}

