/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.jmiimpl.mof.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.jmi.model.Constraint;
import javax.jmi.model.GeneralizableElement;
import javax.jmi.model.Import;
import javax.jmi.model.ModelElement;
import javax.jmi.model.Namespace;
import javax.jmi.model.Operation;
import javax.jmi.model.Reference;
import javax.jmi.model.Tag;
import javax.jmi.model.TypedElement;
import org.netbeans.mdr.handlers.InstanceHandler;
import org.netbeans.mdr.storagemodel.StorableObject;

public abstract class ModelElementImpl
extends InstanceHandler
implements ModelElement {
    public static final String CONTAINER_DEP = "container";
    public static final String CONTENTS_DEP = "contents";
    public static final String SIGNATURE_DEP = "signature";
    public static final String CONSTRAINT_DEP = "constraint";
    public static final String CONSTRAINED_ELEMENTS_DEP = "constrained elements";
    public static final String SPECIALIZATION_DEP = "specialization";
    public static final String IMPORT_DEP = "import";
    public static final String TYPE_DEFINITION_DEP = "type definition";
    public static final String REFERENCED_ENDS_DEP = "referenced ends";
    public static final String TAGGED_ELEMENTS_DEP = "tagged elements";
    public static final String INDIRECT_DEP = "indirect";
    public static final String ALL_DEP = "all";
    static final HashSet ALL_KINDS = new HashSet();

    protected ModelElementImpl(StorableObject storable) {
        super(storable);
    }

    private void recursiveFindDeps(Set kinds, Set result) {
        HashSet temp = new HashSet();
        Iterator m = kinds.iterator();
        while (m.hasNext()) {
            this.findDepsOfKind((String)m.next(), temp);
        }
        Iterator it = temp.iterator();
        while (it.hasNext()) {
            ModelElementImpl me = (ModelElementImpl)it.next();
            if (!result.add(me)) continue;
            me.recursiveFindDeps(kinds, result);
        }
    }

    private void findDepsOfKind(String kind, Set result) {
        if (kind.equals(CONSTRAINT_DEP)) {
            result.addAll(this.getConstraints());
        } else if (kind.equals(CONTAINER_DEP)) {
            result.add(this.getContainer());
        } else if (kind.equals(CONSTRAINED_ELEMENTS_DEP) && this instanceof Constraint) {
            result.addAll(((Constraint)this).getConstrainedElements());
        } else if (kind.equals(SPECIALIZATION_DEP) && this instanceof GeneralizableElement) {
            result.addAll(((GeneralizableElement)this).getSupertypes());
        } else if (kind.equals(IMPORT_DEP) && this instanceof Import) {
            result.add(((Import)this).getImportedNamespace());
        } else if (kind.equals(CONTENTS_DEP) && this instanceof Namespace) {
            result.addAll(((Namespace)this).getContents());
        } else if (kind.equals(SIGNATURE_DEP) && this instanceof Operation) {
            result.addAll(((Operation)this).getExceptions());
        } else if (kind.equals(TAGGED_ELEMENTS_DEP) && this instanceof Tag) {
            result.addAll(((Tag)this).getElements());
        } else if (kind.equals(TYPE_DEFINITION_DEP) && this instanceof TypedElement) {
            result.add(((TypedElement)this).getType());
        } else if (kind.equals(REFERENCED_ENDS_DEP) && this instanceof Reference) {
            result.add(((Reference)this).getReferencedEnd());
            result.add(((Reference)this).getExposedEnd());
        }
        result.remove(null);
    }

    private boolean isDepOfKind(String kind, ModelElement otherElement) {
        HashSet result = new HashSet();
        this.findDepsOfKind(kind, result);
        return result.contains(otherElement);
    }

    public boolean isFrozen() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection findRequiredElements(Collection kinds, boolean recursive) {
        this._lock(false);
        try {
            if (kinds.contains(ALL_DEP)) {
                Collection collection = this.findRequiredElements(ALL_KINDS, recursive);
                return collection;
            }
            HashSet newKinds = kinds == ALL_KINDS ? ALL_KINDS : new HashSet(kinds);
            HashSet result = new HashSet();
            if (recursive) {
                this.recursiveFindDeps(newKinds, result);
            } else {
                Iterator it = kinds.iterator();
                while (it.hasNext()) {
                    String kind = (String)it.next();
                    this.findDepsOfKind(kind, result);
                }
            }
            HashSet hashSet = result;
            return hashSet;
        }
        finally {
            this._unlock();
        }
    }

    public boolean isVisible(ModelElement otherElement) {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isRequiredBecause(ModelElement otherElement, String[] reason) {
        this._lock(false);
        try {
            Iterator it = ALL_KINDS.iterator();
            while (it.hasNext()) {
                reason[0] = (String)it.next();
                if (!this.isDepOfKind(reason[0], otherElement)) continue;
                boolean bl = true;
                return bl;
            }
            if (this.findRequiredElements(ALL_KINDS, true).size() <= 0) {
                reason[0] = "";
                boolean bl = false;
                return bl;
            }
            reason[0] = INDIRECT_DEP;
            boolean bl = true;
            return bl;
        }
        finally {
            this._unlock();
        }
    }

    public List getQualifiedName() {
        Namespace container = this.getContainer();
        ArrayList<String> result = container == null ? new ArrayList<String>() : new ArrayList(container.getQualifiedName());
        result.add(this.getName());
        return result;
    }

    static {
        ALL_KINDS.add(CONTAINER_DEP);
        ALL_KINDS.add(CONTENTS_DEP);
        ALL_KINDS.add(SIGNATURE_DEP);
        ALL_KINDS.add(CONSTRAINT_DEP);
        ALL_KINDS.add(CONSTRAINED_ELEMENTS_DEP);
        ALL_KINDS.add(SPECIALIZATION_DEP);
        ALL_KINDS.add(IMPORT_DEP);
        ALL_KINDS.add(TYPE_DEFINITION_DEP);
        ALL_KINDS.add(REFERENCED_ENDS_DEP);
        ALL_KINDS.add(TAGGED_ELEMENTS_DEP);
    }
}

