/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.mdr.persistence.btreeimpl.btreeindex;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.text.MessageFormat;
import java.util.Set;
import org.netbeans.mdr.persistence.Index;
import org.netbeans.mdr.persistence.Storage;
import org.netbeans.mdr.persistence.StorageBadRequestException;
import org.netbeans.mdr.persistence.StorageClient;
import org.netbeans.mdr.persistence.StorageException;
import org.netbeans.mdr.persistence.StorageIOException;
import org.netbeans.mdr.persistence.Streamable;
import org.netbeans.mdr.persistence.btreeimpl.btreeindex.BtreeKeySet;
import org.netbeans.mdr.persistence.btreeimpl.btreeindex.BtreePage;
import org.netbeans.mdr.persistence.btreeimpl.btreeindex.BtreePageSource;
import org.netbeans.mdr.persistence.btreeimpl.btreeindex.EntryTypeInfo;
import org.netbeans.mdr.persistence.btreeimpl.btreeindex.FixedKeyPage;
import org.netbeans.mdr.persistence.btreeimpl.btreeindex.MOFIDInfo;
import org.netbeans.mdr.persistence.btreeimpl.btreeindex.SearchResult;
import org.netbeans.mdr.persistence.btreeimpl.btreeindex.ShrinkablePage;
import org.netbeans.mdr.persistence.btreeimpl.btreeindex.TreeMetrics;
import org.netbeans.mdr.persistence.btreeimpl.btreeindex.VarKeyPage;
import org.netbeans.mdr.persistence.btreeimpl.btreeindex.VarRecordPage;
import org.netbeans.mdr.persistence.btreeimpl.btreestorage.BtreeMDRSource;
import org.netbeans.mdr.persistence.btreeimpl.btreestorage.BtreeStorage;

public abstract class Btree
implements Index,
Streamable,
StorageClient {
    protected BtreePageSource pageSource;
    protected BtreeStorage storage;
    protected Storage.EntryType keyType;
    protected Storage.EntryType dataType;
    protected String name;
    protected EntryTypeInfo keyInfo;
    protected EntryTypeInfo dataInfo;
    protected int dataLength;
    protected int pageIdLength;
    protected int pageSize;
    protected byte[] rootPageId;
    protected boolean uniqueKeys;
    protected boolean uniqueValues;
    protected boolean hasBigKeys;
    static final byte ADD = 0;
    static final byte REPLACE = 1;
    static final byte REPLACE_IF_EXISTS = 2;
    boolean failed;
    boolean replaced;
    private int activeReaders = 0;
    private int activeWriters = 0;
    private int waitingWriters = 0;
    int modCount = 0;

    public Btree(String name, Storage.EntryType keyType, Storage.EntryType dataType, BtreePageSource pageSource) throws StorageException {
        this.keyType = keyType;
        this.dataType = dataType;
        this.name = name;
        this.pageSource = pageSource;
        this.pageSize = pageSource.getPageSize();
        this.storage = pageSource.getStorage();
        this.init();
    }

    protected void init() throws StorageException {
        BtreePage root;
        if (this.keyInfo != null) {
            return;
        }
        this.keyInfo = EntryTypeInfo.getEntryTypeInfo(this.keyType, this.storage);
        this.dataInfo = EntryTypeInfo.getEntryTypeInfo(this.dataType, this.storage);
        if (this.keyInfo == null) {
            throw new StorageBadRequestException(MessageFormat.format("Invalid index key type: ", this.keyType));
        }
        if (this.dataInfo == null) {
            throw new StorageBadRequestException(MessageFormat.format("Invalid index data type: ", this.dataType));
        }
        this.dataLength = this.dataInfo.getLength();
        this.pageIdLength = this.pageSource.getPageIdLength();
        if (this.rootPageId == null) {
            root = this.pageSource.getRootPage(this);
            this.rootPageId = new byte[this.pageIdLength];
            System.arraycopy(root.pageId, 0, this.rootPageId, 0, root.pageId.length);
            root.makeRoot();
        } else {
            root = this.pageSource.getPage(this.rootPageId, this);
        }
        this.hasBigKeys = !this.pageSource.isNoPage(root.nextPage);
        this.pageSource.unpinPage(root);
    }

    public Btree() {
    }

    public void write(OutputStream outputStream) throws StorageException {
        try {
            DataOutputStream out = new DataOutputStream(outputStream);
            byte[] n = this.name.getBytes();
            out.writeShort(n.length);
            out.write(n);
            out.writeByte(this.keyType.encode());
            out.writeByte(this.dataType.encode());
            out.writeBoolean(this.uniqueValues);
            out.writeInt(this.pageSize);
            out.write(this.rootPageId);
        }
        catch (IOException e) {
            throw new StorageIOException(e);
        }
    }

    public void read(InputStream inputStream) throws StorageException {
        try {
            DataInputStream in = new DataInputStream(inputStream);
            short length = in.readShort();
            byte[] n = new byte[length];
            in.read(n, 0, length);
            this.name = new String(n).intern();
            this.keyType = Storage.EntryType.decodeEntryType(in.readByte());
            this.dataType = Storage.EntryType.decodeEntryType(in.readByte());
            this.uniqueValues = in.readBoolean();
            this.pageSize = in.readInt();
            this.pageSource = new BtreeMDRSource(this.storage, this.pageSize);
            this.rootPageId = new byte[this.pageSource.getPageIdLength()];
            in.read(this.rootPageId, 0, this.rootPageId.length);
        }
        catch (IOException e) {
            throw new StorageIOException(e);
        }
        this.init();
    }

    public void setStorage(Storage storage) {
        this.storage = (BtreeStorage)storage;
    }

    public Storage.EntryType getKeyType() {
        return this.keyType;
    }

    public Storage.EntryType getValueType() {
        return this.dataType;
    }

    public String getName() {
        return this.name;
    }

    public Set keySet() throws StorageException {
        return new BtreeKeySet(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(Object key, Object data) throws StorageException {
        this.beginWrite();
        try {
            this.failed = false;
            this.btreePut(key, data, (byte)0, 0);
            if (this.failed) {
                String message = this.uniqueKeys ? MessageFormat.format("Key {0} already exists in index", key) : MessageFormat.format("Key-value pair {0}, {1} already exists in index", key, data);
                throw new StorageBadRequestException(message);
            }
        }
        finally {
            this.endWrite();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean remove(Object key) throws StorageException {
        this.beginWrite();
        try {
            byte[] keyBuffer = this.keyInfo.toBuffer(key);
            if (keyBuffer == null) {
                throw new StorageBadRequestException(MessageFormat.format("Invalid key type for this index: {0} received, {1} expected", key.getClass().getName(), this.keyInfo.typeName()));
            }
            BtreePage root = this.pageSource.getPage(this.rootPageId, this);
            boolean result = root.remove(keyBuffer);
            this.pageSource.unpinPage(root);
            boolean bl = result;
            return bl;
        }
        finally {
            this.endWrite();
        }
    }

    public BtreePage pageFactory() {
        if (!this.dataInfo.isFixedLength()) {
            return new VarRecordPage();
        }
        if (this.keyInfo.isFixedLength()) {
            if (this.keyInfo instanceof MOFIDInfo && this.dataInfo instanceof MOFIDInfo) {
                return new ShrinkablePage();
            }
            return new FixedKeyPage();
        }
        return new VarKeyPage();
    }

    SearchResult getFirst() throws StorageException {
        BtreePage root = this.pageSource.getPage(this.rootPageId, this);
        SearchResult result = root.getFirst();
        if (result.page != root) {
            this.pageSource.unpinPage(root);
        }
        return result;
    }

    SearchResult getLocation(byte[] key) throws StorageException {
        BtreePage root = this.pageSource.getPage(this.rootPageId, this);
        SearchResult result = root.getLocation(key);
        if (result.page != root) {
            this.pageSource.unpinPage(root);
        }
        return result;
    }

    protected void btreePut(Object key, Object data, byte operation, int index) throws StorageException {
        byte[] keyBuffer = this.keyInfo.toBuffer(key);
        if (keyBuffer == null) {
            throw new StorageBadRequestException(MessageFormat.format("Invalid key type for this index: {0} received, {1} expected", key.getClass().getName(), this.keyInfo.typeName()));
        }
        byte[] dataBuffer = this.dataInfo.toBuffer(data);
        if (dataBuffer == null) {
            throw new StorageBadRequestException(MessageFormat.format("Invalid data type for this index: {0} received, {1} expected", data.getClass().getName(), this.dataInfo.typeName()));
        }
        BtreePage root = this.pageSource.getPage(this.rootPageId, this);
        root.put(keyBuffer, dataBuffer, operation, index);
        this.pageSource.unpinPage(root);
    }

    int countRecords() throws StorageException {
        int count = 0;
        SearchResult location = this.getFirst();
        if (!location.matched) {
            return 0;
        }
        do {
            BtreePage savePage = location.page;
            BtreePage.getNext(null, location);
            ++count;
            if (savePage == null || savePage == location.page) continue;
            this.pageSource.unpinPage(savePage);
        } while (location.matched);
        if (location.page != null) {
            this.pageSource.unpinPage(location.page);
        }
        return count;
    }

    boolean hasBigKeys() {
        return this.hasBigKeys;
    }

    void setHasBigKeys() {
        this.hasBigKeys = true;
    }

    void unsetHasBigKeys() {
        this.hasBigKeys = false;
    }

    private boolean allowReader() {
        return this.waitingWriters == 0 && this.activeWriters == 0;
    }

    private boolean allowWriter() {
        return this.activeReaders == 0 && this.activeWriters == 0;
    }

    protected synchronized void beginRead() {
        while (!this.allowReader()) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
        ++this.activeReaders;
    }

    protected synchronized void endRead() {
        --this.activeReaders;
        this.notifyAll();
    }

    protected synchronized void beginWrite() {
        ++this.waitingWriters;
        while (!this.allowWriter()) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
        --this.waitingWriters;
        ++this.activeWriters;
    }

    protected synchronized void endWrite() {
        --this.activeWriters;
        ++this.modCount;
        this.notifyAll();
    }

    public void dumpTree(PrintWriter out) throws StorageException {
        BtreePage root = this.pageSource.getPage(this.rootPageId, this);
        root.dumpTree(out);
        this.pageSource.unpinPage(root);
    }

    public TreeMetrics computeMetrics() throws StorageException {
        BtreePage root = this.pageSource.getPage(this.rootPageId, this);
        TreeMetrics m = root.computeMetrics();
        this.pageSource.unpinPage(root);
        return m;
    }

    public int consistencyCheck(PrintWriter out) throws StorageException {
        BtreePage root = this.pageSource.getPage(this.rootPageId, this);
        int result = root.consistencyCheck(out);
        this.pageSource.unpinPage(root);
        return result;
    }
}

