/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.toolbar.toolbutton;

import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.UIManager;
import org.tigris.toolbar.ToolBarManager;
import org.tigris.toolbar.toolbutton.AbstractButtonAction;
import org.tigris.toolbar.toolbutton.ToolButtonGroup;

public class ToolButton
extends JButton {
    private static final long serialVersionUID = 6707530106426207396L;
    protected ArrayList containedGroups = new ArrayList();
    protected JButton _button;
    protected boolean selected;
    private boolean rollover;

    public ToolButton(Action action) {
        super(action);
        this.addMouseListener(new MyMouseListener());
        if ("1.3".equals(System.getProperties().getProperty("java.specification.version"))) {
            this.setMargin(new Insets(0, 0, 0, 0));
        }
    }

    void setInGroup(ToolButtonGroup toolButtonGroup) {
        this.containedGroups.add(toolButtonGroup);
    }

    public void setRolloverEnabled(boolean bl) {
        super.setRolloverEnabled(bl);
        this.rollover = bl;
    }

    public void setSelected(boolean bl) {
        this.selected = bl;
        if (bl) {
            this.setBackground(UIManager.getColor("controlShadow"));
            super.setRolloverEnabled(false);
            Iterator iterator = this.containedGroups.iterator();
            while (iterator.hasNext()) {
                ToolButtonGroup toolButtonGroup = (ToolButtonGroup)iterator.next();
                toolButtonGroup.buttonSelected(this);
            }
        } else {
            this.setBackground(UIManager.getColor("control"));
            super.setRolloverEnabled(this.rollover);
        }
    }

    public Action getRealAction() {
        if (this._button == null) {
            return null;
        }
        return this._button.getAction();
    }

    protected void performAction(ActionEvent actionEvent) {
        this.setSelected(!this.selected);
        Action action = this._button.getAction();
        action.actionPerformed(actionEvent);
    }

    private class MyMouseListener
    implements MouseListener {
        private MyMouseListener() {
        }

        public void mouseEntered(MouseEvent mouseEvent) {
            Action action = ToolButton.this.getRealAction();
            if (action != null && action.isEnabled() && !ToolBarManager.alwaysUseStandardRollover()) {
                ToolButton.this.setBorderPainted(true);
            }
        }

        public void mouseExited(MouseEvent mouseEvent) {
            if (!ToolButton.this.selected && !ToolBarManager.alwaysUseStandardRollover()) {
                ToolButton.this.setBorderPainted(false);
            }
        }

        public void mouseClicked(MouseEvent mouseEvent) {
        }

        public void mousePressed(MouseEvent mouseEvent) {
        }

        public void mouseReleased(MouseEvent mouseEvent) {
        }
    }

    protected class ToolButtonAction
    extends AbstractButtonAction {
        private static final long serialVersionUID = 3795102603065565883L;

        public void actionPerformed(ActionEvent actionEvent) {
            ToolButton.this.performAction(actionEvent);
        }
    }
}

