/*
 * Decompiled with CFR 0.152.
 */
package tudresden.ocl.check;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import tudresden.ocl.check.NameBoundQueryable;
import tudresden.ocl.check.NameSpaceEntry;
import tudresden.ocl.check.TypeChecker;
import tudresden.ocl.parser.OclParserException;
import tudresden.ocl.parser.analysis.DepthFirstAdapter;
import tudresden.ocl.parser.node.AConstraint;
import tudresden.ocl.parser.node.AContextDeclaration;
import tudresden.ocl.parser.node.ADeclaratorTail;
import tudresden.ocl.parser.node.AExpression;
import tudresden.ocl.parser.node.AFeatureCall;
import tudresden.ocl.parser.node.AFeatureCallParameters;
import tudresden.ocl.parser.node.AFormalParameter;
import tudresden.ocl.parser.node.AFormalParameterList;
import tudresden.ocl.parser.node.AFormalParameterListTail;
import tudresden.ocl.parser.node.AIterateDeclarator;
import tudresden.ocl.parser.node.ALetExpression;
import tudresden.ocl.parser.node.AOperationContext;
import tudresden.ocl.parser.node.AOperationContextBody;
import tudresden.ocl.parser.node.AStandardDeclarator;
import tudresden.ocl.parser.node.Node;
import tudresden.ocl.parser.node.PActualParameterList;
import tudresden.ocl.parser.node.PDeclarator;
import tudresden.ocl.parser.node.Start;

public class NameBinder
extends DepthFirstAdapter
implements NameBoundQueryable {
    protected Start ast;
    protected HashMap nodes;
    protected HashMap defaultContexts;

    public NameBinder(Start s) {
        this.ast = s;
        this.update(this.ast);
    }

    protected void update(Node n) {
        n.apply(this);
    }

    public void inStart(Start s) {
        this.nodes = new HashMap();
        this.defaultContexts = new HashMap();
        this.nodes.put(s, new HashSet());
    }

    public void inAConstraint(AConstraint c) {
        HashSet set = this.getCopy(c);
        set.add(new NameSpaceEntry("self"));
        if (((AContextDeclaration)c.getContextDeclaration()).getContextBody() instanceof AOperationContextBody) {
            set.add(new NameSpaceEntry("result"));
            AOperationContextBody ocb = (AOperationContextBody)((AContextDeclaration)c.getContextDeclaration()).getContextBody();
            AOperationContext oc = (AOperationContext)ocb.getOperationContext();
            if (oc.getFormalParameterList() != null) {
                AFormalParameterList fpl = (AFormalParameterList)oc.getFormalParameterList();
                set.add(new NameSpaceEntry(((AFormalParameter)fpl.getFormalParameter()).getName().toString().trim()));
                Iterator iter = fpl.getFormalParameterListTail().iterator();
                while (iter.hasNext()) {
                    AFormalParameter fp = (AFormalParameter)((AFormalParameterListTail)iter.next()).getFormalParameter();
                    set.add(new NameSpaceEntry(fp.getName().toString().trim()));
                }
            }
        }
        this.nodes.put(c, set);
        this.defaultContexts.put(c, "self");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void inAFeatureCall(AFeatureCall fc) {
        String iteratorName;
        if (!TypeChecker.setOfIteratingMethodNames.contains(fc.getPathName().toString().trim())) return;
        AFeatureCallParameters afcp = (AFeatureCallParameters)fc.getFeatureCallParameters();
        if (afcp == null) {
            throw new OclParserException("iterating method without FeatureCallParameters: " + fc.toString());
        }
        if (afcp.getDeclarator() != null) {
            if (!(afcp.getDeclarator() instanceof AStandardDeclarator)) throw new OclParserException("iterating method with wrong Declarator type: " + fc.toString());
            AStandardDeclarator asd = (AStandardDeclarator)afcp.getDeclarator();
            iteratorName = asd.getDeclaratorTail() == null || asd.getDeclaratorTail().isEmpty() ? asd.getName().toString().trim() : null;
        } else {
            iteratorName = null;
        }
        this.defaultContexts.put(fc.getFeatureCallParameters(), iteratorName);
    }

    public void inAFeatureCallParameters(AFeatureCallParameters fcp) {
        PDeclarator pd = fcp.getDeclarator();
        if (pd != null) {
            HashSet newNames = this.getCopy(fcp);
            if (pd instanceof AStandardDeclarator) {
                AStandardDeclarator asd = (AStandardDeclarator)pd;
                String name = asd.getName().toString().trim();
                newNames.add(new NameSpaceEntry(name));
                Iterator iter = asd.getDeclaratorTail().iterator();
                while (iter.hasNext()) {
                    name = ((ADeclaratorTail)iter.next()).getName().toString().trim();
                    newNames.add(new NameSpaceEntry(name));
                }
            } else if (pd instanceof AIterateDeclarator) {
                AIterateDeclarator aid = (AIterateDeclarator)pd;
                String nameIterator = aid.getIterator().toString().trim();
                String nameAccum = aid.getAccumulator().toString().trim();
                newNames.add(new NameSpaceEntry(nameIterator));
                newNames.add(new NameSpaceEntry(nameAccum));
            }
            PActualParameterList params = fcp.getActualParameterList();
            if (params != null) {
                this.nodes.put(params, newNames);
            }
        }
    }

    public void inAExpression(AExpression e) {
        LinkedList lets = e.getLetExpression();
        if (!lets.isEmpty()) {
            HashSet set = this.getCopy(e);
            Iterator iter = lets.iterator();
            while (iter.hasNext()) {
                String name = ((ALetExpression)iter.next()).getName().toString().trim();
                set.add(new NameSpaceEntry(name));
            }
            this.nodes.put(e, set);
        }
    }

    protected HashSet getCopy(Node n) {
        Node parent = n.parent();
        while (parent != null && !this.nodes.containsKey(parent)) {
            parent = parent.parent();
        }
        return new HashSet((HashSet)this.nodes.get(parent));
    }

    protected HashSet getEnvironment(Node n) {
        Node parent = n;
        while (!this.nodes.containsKey(parent)) {
            parent = parent.parent();
        }
        return (HashSet)this.nodes.get(parent);
    }

    public boolean isNameBound(String name, Node node) {
        HashSet environ = this.getEnvironment(node);
        if (environ == null) {
            return false;
        }
        return environ.contains(new NameSpaceEntry(name.trim()));
    }

    public HashSet getBoundNames(Node n) {
        HashSet<String> result = new HashSet<String>();
        HashSet env = this.getEnvironment(n);
        Iterator iter = env.iterator();
        while (iter.hasNext()) {
            NameSpaceEntry nse = (NameSpaceEntry)iter.next();
            result.add(nse.name);
        }
        return result;
    }

    public String getDefaultContext(Node n) {
        Node parent = n;
        while (parent != null && !this.defaultContexts.containsKey(parent)) {
            parent = parent.parent();
        }
        return (String)this.defaultContexts.get(parent);
    }

    public void changeNotify(Node subtree) {
        this.update(subtree);
    }
}

