/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.gef.base;

import java.awt.Dimension;
import java.awt.FileDialog;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import org.tigris.gef.base.Cmd;
import org.tigris.gef.base.Diagram;
import org.tigris.gef.base.Editor;
import org.tigris.gef.base.Globals;
import org.tigris.gef.graph.presentation.JGraphFrame;
import org.tigris.gef.persistence.svg.SvgParser;
import org.tigris.gef.util.Util;

public class CmdOpenSVG
extends Cmd
implements FilenameFilter {
    static final long serialVersionUID = 0L;

    public CmdOpenSVG() {
        super("OpenSVG");
        this.setArg("filterPattern", "*.svg");
    }

    public boolean accept(File dir, String name) {
        System.out.println("checking: " + dir + " " + name);
        if (this.containsArg("filterPattern")) {
            return true;
        }
        return true;
    }

    public void doIt() {
        Editor ce = Globals.curEditor();
        FileDialog fd = new FileDialog(ce.findFrame(), "Open...", 0);
        fd.setFilenameFilter(this);
        fd.setDirectory(Globals.getLastDirectory());
        fd.setVisible(true);
        String filename = fd.getFile();
        String path = fd.getDirectory();
        Globals.setLastDirectory(path);
        if (filename != null) {
            try {
                Globals.showStatus("Reading " + path + filename + "...");
                URL url = Util.fileToURL(new File(path + filename));
                Diagram diag = SvgParser.SINGLETON.readDiagram(url);
                Editor ed = new Editor(diag);
                Globals.showStatus("Read " + path + filename);
                JGraphFrame jgf = new JGraphFrame(path + filename, ed);
                Object d = this.getArg("dimension");
                if (d instanceof Dimension) {
                    jgf.setSize((Dimension)d);
                }
                jgf.setVisible(true);
            }
            catch (MalformedURLException murle) {
                System.out.println("bad URL");
            }
            catch (IOException e) {
                System.out.println("IOExcept in opensvg");
            }
        }
    }

    public void undoIt() {
        System.out.println("Undo does not make sense for CmdOpen");
    }
}

