/*
 * Decompiled with CFR 0.152.
 */
package org.argouml.model.mdr;

import java.util.Collection;
import org.argouml.model.ActivityGraphsHelper;
import org.argouml.model.Model;
import org.argouml.model.mdr.CollectionHelper;
import org.omg.uml.behavioralelements.activitygraphs.ClassifierInState;
import org.omg.uml.behavioralelements.activitygraphs.ObjectFlowState;
import org.omg.uml.behavioralelements.activitygraphs.Partition;
import org.omg.uml.behavioralelements.statemachines.CompositeState;
import org.omg.uml.behavioralelements.statemachines.State;
import org.omg.uml.behavioralelements.statemachines.StateMachine;
import org.omg.uml.behavioralelements.statemachines.StateVertex;
import org.omg.uml.foundation.core.BehavioralFeature;
import org.omg.uml.foundation.core.Classifier;
import org.omg.uml.foundation.core.ModelElement;
import org.omg.uml.foundation.core.Namespace;
import org.omg.uml.foundation.core.Parameter;
import org.omg.uml.modelmanagement.UmlPackage;

class ActivityGraphsHelperMDRImpl
implements ActivityGraphsHelper {
    public Object findClassifierByName(Object ofs, String s) {
        if (!(ofs instanceof ObjectFlowState)) {
            throw new IllegalArgumentException();
        }
        CompositeState cs = ((ObjectFlowState)ofs).getContainer();
        StateMachine sm = cs.getStateMachine();
        ModelElement ns = sm.getContext();
        if (ns == null) {
            return null;
        }
        if (!(ns instanceof Namespace)) {
            ns = ns.getNamespace();
        }
        if (ns != null) {
            Collection c = Model.getModelManagementHelper().getAllModelElementsOfKind((Object)ns, Model.getMetaTypes().getClassifier());
            for (ModelElement classifier : c) {
                String cn = classifier.getName();
                if (cn == null || !cn.equals(s)) continue;
                return classifier;
            }
        } else {
            throw new IllegalArgumentException();
        }
        return null;
    }

    public Object findStateByName(Object c, String s) {
        if (!(c instanceof Classifier)) {
            throw new IllegalArgumentException();
        }
        if (s == null || s.equals("")) {
            return null;
        }
        Collection allStatemachines = Model.getFacade().getBehaviors(c);
        for (StateMachine statemachine : allStatemachines) {
            State top = statemachine.getTop();
            Collection allStates = Model.getStateMachinesHelper().getAllSubStates(top);
            for (StateVertex state : allStates) {
                String statename = state.getName();
                if (statename == null || !statename.equals(s)) continue;
                return state;
            }
        }
        return null;
    }

    public boolean isAddingActivityGraphAllowed(Object context) {
        return context instanceof BehavioralFeature || context instanceof Classifier || context instanceof UmlPackage;
    }

    public void addInState(Object classifierInState, Object state) {
        if (!(classifierInState instanceof ClassifierInState) || !(state instanceof State)) {
            throw new IllegalArgumentException("classifierInState: " + classifierInState + " or state: " + state);
        }
        ((ClassifierInState)classifierInState).getInState().add((State)state);
    }

    public void setInStates(Object classifierInState, Collection newStates) {
        if (!(classifierInState instanceof ClassifierInState)) {
            throw new IllegalArgumentException("classifierInState: " + classifierInState);
        }
        ClassifierInState cis = (ClassifierInState)classifierInState;
        CollectionHelper.update(cis.getInState(), newStates);
    }

    public void setContents(Object partition, Collection contents) {
        if (!(partition instanceof Partition)) {
            throw new IllegalArgumentException("Partition: " + partition);
        }
        Partition p = (Partition)partition;
        CollectionHelper.update(p.getContents(), contents);
    }

    public void addContent(Object partition, Object modelElement) {
        Partition p = (Partition)partition;
        p.getContents().add((ModelElement)modelElement);
    }

    public void removeContent(Object partition, Object modelElement) {
        Partition p = (Partition)partition;
        p.getContents().remove(modelElement);
    }

    public void setSynch(Object objectFlowState, boolean isSynch) {
        ((ObjectFlowState)objectFlowState).setSynch(isSynch);
    }

    public void addParameter(Object objectFlowState, Object parameter) {
        ((ObjectFlowState)objectFlowState).getParameter().add((Parameter)parameter);
    }

    public void removeParameter(Object objectFlowState, Object parameter) {
        ((ObjectFlowState)objectFlowState).getParameter().remove(parameter);
    }

    public void setParameters(Object objectFlowState, Collection parameters) {
        Collection params = ((ObjectFlowState)objectFlowState).getParameter();
        params.clear();
        params.addAll(parameters);
    }
}

