/*
 * Decompiled with CFR 0.152.
 */
package org.argouml.model.euml;

import java.util.ArrayList;
import org.argouml.model.AbstractModelFactory;
import org.argouml.model.ModelManagementFactory;
import org.argouml.model.NotImplementedException;
import org.argouml.model.euml.EUMLModelImplementation;
import org.argouml.model.euml.RunnableClass;
import org.argouml.model.euml.UMLUtil;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.uml2.common.edit.command.ChangeCommand;
import org.eclipse.uml2.uml.ElementImport;
import org.eclipse.uml2.uml.Model;
import org.eclipse.uml2.uml.Namespace;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.PackageableElement;
import org.eclipse.uml2.uml.Profile;
import org.eclipse.uml2.uml.UMLFactory;

class ModelManagementFactoryEUMLImpl
implements ModelManagementFactory,
AbstractModelFactory {
    private EUMLModelImplementation modelImpl;
    private EditingDomain editingDomain;
    private Package theRootModel;

    public ModelManagementFactoryEUMLImpl(EUMLModelImplementation implementation) {
        this.modelImpl = implementation;
        this.editingDomain = implementation.getEditingDomain();
    }

    public ElementImport buildElementImport(final Object pack, final Object me) {
        UMLUtil.checkArgs(new Object[]{pack, me}, new Class[]{Namespace.class, PackageableElement.class});
        RunnableClass run = new RunnableClass(){

            public void run() {
                ElementImport elementImport = ModelManagementFactoryEUMLImpl.this.createElementImport();
                elementImport.setImportingNamespace((Namespace)pack);
                elementImport.setImportedElement((PackageableElement)me);
                this.getParams().add(elementImport);
            }
        };
        this.editingDomain.getCommandStack().execute((Command)new ChangeCommand(this.editingDomain, (Runnable)run));
        return (ElementImport)run.getParams().get(0);
    }

    public Package buildPackage(final String name) {
        RunnableClass run = new RunnableClass(){

            public void run() {
                Package pkg = ModelManagementFactoryEUMLImpl.this.createPackage();
                if (name != null) {
                    pkg.setName(name);
                }
                this.getParams().add(pkg);
            }
        };
        this.editingDomain.getCommandStack().execute((Command)new ChangeCommand(this.editingDomain, (Runnable)run));
        return (Package)run.getParams().get(0);
    }

    public Object copyPackage(Object source, Object ns) {
        return null;
    }

    public ElementImport createElementImport() {
        RunnableClass run = new RunnableClass(){

            public void run() {
                this.getParams().add(UMLFactory.eINSTANCE.createElementImport());
            }
        };
        this.editingDomain.getCommandStack().execute((Command)new ChangeCommand(this.editingDomain, (Runnable)run));
        return (ElementImport)run.getParams().get(0);
    }

    public Model createModel() {
        RunnableClass run = new RunnableClass(){

            public void run() {
                this.getParams().add(UMLFactory.eINSTANCE.createModel());
            }
        };
        this.editingDomain.getCommandStack().execute((Command)new ChangeCommand(this.editingDomain, (Runnable)run));
        return (Model)run.getParams().get(0);
    }

    public Package createPackage() {
        RunnableClass run = new RunnableClass(){

            public void run() {
                this.getParams().add(UMLFactory.eINSTANCE.createPackage());
            }
        };
        this.editingDomain.getCommandStack().execute((Command)new ChangeCommand(this.editingDomain, (Runnable)run));
        return (Package)run.getParams().get(0);
    }

    public Profile createProfile() {
        RunnableClass run = new RunnableClass(){

            public void run() {
                this.getParams().add(UMLFactory.eINSTANCE.createProfile());
            }
        };
        this.editingDomain.getCommandStack().execute((Command)new ChangeCommand(this.editingDomain, (Runnable)run));
        return (Profile)run.getParams().get(0);
    }

    @Deprecated
    public Object createSubsystem() {
        throw new NotImplementedException();
    }

    @Deprecated
    public void setRootModel(Object rootModel) {
        if (rootModel != null && !(rootModel instanceof Package)) {
            throw new IllegalArgumentException("The rootModel supplied must be a Package. Got a " + rootModel.getClass().getName());
        }
        ArrayList<Object> restoreList = new ArrayList<Object>();
        if (this.theRootModel != null && this.theRootModel.eResource() != null) {
            if (this.theRootModel.eResource().getContents().contains((Object)this.theRootModel) && rootModel == this.theRootModel) {
                for (EObject o : this.theRootModel.eResource().getContents()) {
                    if (o == this.theRootModel) continue;
                    restoreList.add(o);
                }
            }
            EcoreUtil.remove((EObject)this.theRootModel);
        }
        this.theRootModel = (Package)rootModel;
        if (rootModel != null && this.theRootModel.eResource() == null) {
            restoreList.add(0, this.theRootModel);
            Resource r = UMLUtil.getResource(this.modelImpl, UMLUtil.DEFAULT_URI, Boolean.FALSE);
            r.getContents().addAll(restoreList);
        }
        this.modelImpl.getModelEventPump().setRootContainer((Notifier)this.theRootModel);
    }

    @Deprecated
    public Package getRootModel() {
        return this.theRootModel;
    }
}

