/* Time-stamp: <2007-09-22 19:42:47 poser> */
/*
 * Copyright (C) 2006-2007 William J. Poser.
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of version 2.1 of the GNU Lesser General
 * Public License as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */

#ifndef __GMP_H__
#include <gmp.h>
#endif
#ifndef __WCHAR_H__
#include <wchar.h>
#endif

#ifndef _UNICODE_POSER
#include "unicode.h"
#endif

union ns_rval {
  char *s;
  unsigned long u;
  mpz_t m;
};

struct vcpair {
  unsigned long v;
  UTF32 c;
};

#ifndef UNINUM
extern char *uninum_version(void);

extern char *UNStrToWNStr(UTF32 *s,char *sns); /* Tcl interface */
extern UCS2 *WNStrToUNStr(char *,char *); /* Tcl interface */
extern char *StrGuessNumberSystem(UTF32 *); /* Tcl interface */

extern void StringToInt(union ns_rval *, UTF32 *, short, int);
extern UTF32 *IntToString(union ns_rval *, int, short);

extern int GuessNumberSystem(UTF32 *);
extern UTF32 wcStripSeparators (UTF32 *, UTF32);
extern UTF32 *NormalizeChineseNumbers (UTF32 *);
extern int StringToNumberSystem (char *);
extern char *NumberSystemToString (int);
extern char *ListNumberSystems(int,int);
extern void GetLocaleGroupInfo(void);
extern UTF32 *wcDelimitNumber(UTF32 *, UCS2, UTF32, int, int);
/* The maximum value representable in the specified number system */
extern char *UninumStringMaximumValue(int);

extern int uninum_err;
extern UTF32 uninum_badchar;
extern UCS2 tcl_uninum_badchar;
extern short uninum_ns_type;

/* Parameters governing string output */
extern int Uninum_Input_Base;
extern int Uninum_Output_Base;
extern int Uninum_Output_General_Group_Size;
extern int Uninum_Output_First_Group_Size;
extern UCS2 Uninum_Output_Group_Separator;
extern int Uninum_Generate_Roman_With_Bar_P;
#endif

