# Copyright 2026 Gentoo Authors
# Distributed under the terms of the GNU General Public License v2

# Autogenerated by pycargoebuild 0.14.0

EAPI=8

CRATES="
"

RUST_MIN_VER="1.87.0"

declare -A GIT_CRATES=(
	[vmlinux]='https://github.com/libbpf/vmlinux.h;a9c092aa771310bf8b00b5018f7d40a1fdb6ec82;vmlinux.h-%commit%'
)

inherit cargo edo rust-toolchain

DESCRIPTION="C bindings for blazesym, a library for address symbolization and related tasks"
HOMEPAGE="https://github.com/libbpf/blazesym"
SRC_URI="
	https://github.com/libbpf/blazesym/archive/refs/tags/capi-v${PV}.tar.gz -> ${P}.tar.gz
	https://github.com/gentoo-crate-dist/blazesym/releases/download/capi-v${PV}/blazesym-capi-v${PV}-crates.tar.xz
	${CARGO_CRATE_URIS}
"

# build in the capi subdirectory since cargo has no -C option:
# https://github.com/rust-lang/cargo/issues/10098
S="${WORKDIR}/blazesym-capi-v${PV}/capi"

LICENSE="BSD"
# Dependent crate licenses
LICENSE+="
	Apache-2.0 Apache-2.0-with-LLVM-exceptions BSD-2 BSD Boost-1.0
	CDLA-Permissive-2.0 ISC MIT MPL-2.0 Unicode-3.0 ZLIB
"

SLOT="0"
KEYWORDS="~amd64 ~arm64"

# Currently suffers from (at least):
# - problems with crate tarball
# - hardcoded/hand-rolled multilib assumptions
# - possibly sandbox
RESTRICT="test"

BDEPEND="
	dev-util/cargo-c
"

QA_FLAGS_IGNORED="usr/lib64/libblazesym_c.so.${PV}"

src_configure() {
	CARGO_ARGS=(
		--library-type=cdylib
		--prefix="${EPREFIX}"/usr
		--libdir="${EPREFIX}/usr/$(get_libdir)"
		--target="$(rust_abi)"
		$(usev !debug '--release')
	)

	cargo_src_configure
}

src_compile() {
	edo cargo cbuild "${CARGO_ARGS[@]}" || die
}

src_install() {
	CARGO_ARGS+=(
		--destdir="${ED}"
	)

	edo cargo cinstall "${CARGO_ARGS[@]}" || die
}
