#include <stdio.h>
#include <assert.h>
#include <string.h>
#include <stdlib.h>
#include "tool.h"
#include "link.h"
#include "kernelsyms.h"


/*
	Add the symbol defined in the kernel, simulating a pseudo module
	Return -1 if any error.
*/
static int depmod_addksyms (
	MODULES &mods,
	SYMBOLS &syms)
{
	int ret = -1;
	MODULE *mod = mods.setdummy ("-");
	SYMBOL *tbsym[2000];
	int nbsym=1;
	// Fake the _mod_use_count_ symbol which is provided by insmod
	int requis;		// Dummy
	tbsym[0] = syms.add ("_mod_use_count_",mod,SYM_DEFINI,requis,0);
#if 0
		char *cmd_strings = "strings /usr/src/linux/kernel/ksyms.o";
		FILE *fin = popen_err (cmd_strings,"r",0);
		if (fin != NULL){
			char buf[300];
			char lin[300];
			while (fgets(lin,sizeof(lin)-1,fin)!= NULL
				&& sscanf (lin,"%s\n",buf)==1){
				assert (nbsym < 2000);
				tbsym[nbsym++] = syms.add (buf,mod,SYM_DEFINI,requis,0);
			}
			pclose (fin);
		}
#else
#if 1
		struct kernel_sym *ksym;
		int so_far = 0;

		load_kernel_symbols();
		int kernel_syms = 0;
		/* #Specification: depmod / kernel syms only
			When initialising its symbol table from the kernel
			depmod silently discad all symbol from loaded modules.

			This means that depmod may be used at any time to compute
			the dependancy table, even if there are modules already
			loaded.

			depmod use the kernel system call to obtain the
			symbol table, not /proc/ksyms. depmod assume that
			kernel symbols are at the end of the list, just
			after a pseudo symbol with a one character name: #
		*/
		for (ksym = ksymtab; so_far < nksyms ; ++so_far, ksym++) {
			if (kernel_syms){
				assert (nbsym < 2000);
				tbsym[nbsym++] = syms.add (ksym->name,mod,SYM_DEFINI,requis,0);
			}else if (strcmp(ksym->name,"#") == 0){
				kernel_syms = 1;
			}
		}
#else
		FILE *fin = fopen ("/proc/ksyms","r");
		if (fin == NULL){
			fprintf (stderr,"Can't open /proc/ksyms\n");
		}else{
			char buf[300];
			char lin[300];
			char drop_me[300];
			while (fgets(lin,sizeof(lin)-1,fin)!= NULL
				&& sscanf (lin,"%s %s\n",drop_me,buf)==2){
				assert (nbsym < 2000);
				tbsym[nbsym++] = syms.add (buf,mod,SYM_DEFINI,requis,0);
			}
			fclose (fin);
		}
#endif
#endif
	int size = nbsym*sizeof(SYMBOL*);
	mod->pub.tb = (SYMBOL**)malloc(size);
	if (mod->pub.tb == NULL){
		fprintf (stderr,"Can't allocate memory for kernel symbols\n");
	}else{
		memcpy (mod->pub.tb,tbsym,size);
		ret = 0;
	}
	return ret;
}
/*
	Load the symbols from a module.
*/
static int depmod_load (MODULES &mods, SYMBOLS &syms, const char *path)
{
	return mods.loadobj (syms,path);
}

/*
	Prints the dependancies in the output or stdout if depfile is NULL.
*/
static void depmod_prtdepend(
	MODULES &mods,
	const char *depfile)
{
	FILE *out = stdout;
	if (depfile != NULL){
		out = fopen (depfile,"w");
		if (out == NULL){
			fprintf (stderr,"Can't open %s\n",depfile);
			exit (-1);
		}
	}								
	mods.prtdepend(out,"-");
}

int depmod_main (int argc, char *argv[])
{
	int ret = -1;
	if (argc == 1){
		fprintf (stderr,
			"depmod " DEPMOD_RELEASE "\n"
			"depmod -a\n"
			"depmod module1.o module2.o ...\n"
			"\n"
			"depmod will output a dependancy list suitable for the\n"
			"modprobe utility. This dependancy file look like\n"
			"a Makefile\n"
			"\n"
			// "It reads the file /proc/ksyms\n"
			"It reads the kernel symbol table\n"
			"to find out which symbols are already available\n"
			"in the running kernel\n"
			"\n"
			"It will output on stdout\n"
			"\n"
			"depmod -a will find the list of module to probe from\n"
			"the file " ETC_CONF_MODULES "\n"
			"It will output the result into the depfile specified\n"
			"in this configuration file\n"
			"(depfile=...)\n"
			);
	}else{
		MODULES mods;
		SYMBOLS syms;
		ret = depmod_addksyms(mods,syms);
		if (ret != -1){
			if (argc == 2 && strcmp(argv[1],"-a")==0){
				if (config_read() == -1){
					ret = -1;
				}else{
					char *lst[1000];
					int nb = config_lstmod ("*.{mod,o}",NULL,lst);
					for (int i=0; i<nb && ret != -1; i++){
						ret = depmod_load (mods,syms,lst[i]);
					}
					if (ret != -1){
						depmod_prtdepend (mods,config_getdepfile());
					}
				}				
			}else{
				for (int i=1; i<argc && ret != -1; i++){
					char *arg = argv[i];
					if (arg[0] == '-'){
						// Option processing, one day ...
					}else{
						ret = depmod_load (mods,syms,arg);
					}
				}
				if (ret != -1){
					depmod_prtdepend(mods,NULL);
				}
			}
		}
	}
	return ret;			
}

