/******************************************************************************
 *
 * Name: acgcc.h - GCC specific defines, etc.
 *       $Revision: 22 $
 *
 *****************************************************************************/

/*
 *  Copyright (C) 2000 - 2002, R. Byron Moore
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef __ACGCC_H__
#define __ACGCC_H__


#ifdef __ia64__
#define _IA64

#define COMPILER_DEPENDENT_INT64   long
#define COMPILER_DEPENDENT_UINT64  unsigned long

/*
 * Calling conventions:
 *
 * ACPI_SYSTEM_XFACE        - Interfaces to host OS (handlers, threads)
 * ACPI_EXTERNAL_XFACE      - External ACPI interfaces
 * ACPI_INTERNAL_XFACE      - Internal ACPI interfaces
 * ACPI_INTERNAL_VAR_XFACE  - Internal variable-parameter list interfaces
 */
#define ACPI_SYSTEM_XFACE
#define ACPI_EXTERNAL_XFACE
#define ACPI_INTERNAL_XFACE
#define ACPI_INTERNAL_VAR_XFACE

/* Single threaded */

#define ACPI_APPLICATION

/* Asm macros */

#define ACPI_ASM_MACROS
#define BREAKPOINT3
#define ACPI_DISABLE_IRQS() __cli()
#define ACPI_ENABLE_IRQS()  __sti()

/*! [Begin] no source code translation */

#include <asm/pal.h>

#define halt()              ia64_pal_halt_light()           /* PAL_HALT[_LIGHT] */
#define safe_halt()         ia64_pal_halt(1)                /* PAL_HALT */


#define ACPI_ACQUIRE_GLOBAL_LOCK(GLptr, Acq) \
	do { \
	__asm__ volatile ("1:  ld4      r29=%1\n"  \
		";;\n"                  \
		"mov    ar.ccv=r29\n"   \
		"mov    r2=r29\n"       \
		"shr.u  r30=r29,1\n"    \
		"and    r29=-4,r29\n"   \
		";;\n"                  \
		"add    r29=2,r29\n"    \
		"and    r30=1,r30\n"    \
		";;\n"                  \
		"add    r29=r29,r30\n"  \
		";;\n"                  \
		"cmpxchg4.acq   r30=%1,r29,ar.ccv\n" \
		";;\n"                  \
		"cmp.eq p6,p7=r2,r30\n" \
		"(p7) br.dpnt.few 1b\n" \
		"cmp.gt p8,p9=3,r29\n"  \
		";;\n"                  \
		"(p8) mov %0=-1\n"      \
		"(p9) mov %0=r0\n"      \
		:"=r"(Acq):"m"(GLptr):"r2","r29","r30","memory"); \
	} while (0)

#define ACPI_RELEASE_GLOBAL_LOCK(GLptr, Acq) \
	do { \
	__asm__ volatile ("1:  ld4      r29=%1\n" \
		";;\n"                  \
		"mov    ar.ccv=r29\n"   \
		"mov    r2=r29\n"       \
		"and    r29=-4,r29\n"   \
		";;\n"                  \
		"cmpxchg4.acq   r30=%1,r29,ar.ccv\n" \
		";;\n"                  \
		"cmp.eq p6,p7=r2,r30\n" \
		"(p7) br.dpnt.few 1b\n" \
		"and    %0=1,r2\n"      \
		";;\n"                  \
		:"=r"(Acq):"m"(GLptr):"r2","r29","r30","memory"); \
	} while (0)
/*! [End] no source code translation !*/


#else /* DO IA32 */

#define COMPILER_DEPENDENT_INT64   long long
#define COMPILER_DEPENDENT_UINT64  unsigned long long

/*
 * Calling conventions:
 *
 * ACPI_SYSTEM_XFACE        - Interfaces to host OS (handlers, threads)
 * ACPI_EXTERNAL_XFACE      - External ACPI interfaces
 * ACPI_INTERNAL_XFACE      - Internal ACPI interfaces
 * ACPI_INTERNAL_VAR_XFACE  - Internal variable-parameter list interfaces
 */
#define ACPI_SYSTEM_XFACE
#define ACPI_EXTERNAL_XFACE
#define ACPI_INTERNAL_XFACE
#define ACPI_INTERNAL_VAR_XFACE

/* Asm macros */

#define ACPI_ASM_MACROS
#define BREAKPOINT3
#define ACPI_DISABLE_IRQS() __cli()
#define ACPI_ENABLE_IRQS()  __sti()

/*! [Begin] no source code translation
 *
 * A brief explanation as GNU inline assembly is a bit hairy
 *  %0 is the output parameter in EAX ("=a")
 *  %1 and %2 are the input parameters in ECX ("c")
 *  and an immediate value ("i") respectively
 *  All actual register references are preceded with "%%" as in "%%edx"
 *  Immediate values in the assembly are preceded by "$" as in "$0x1"
 *  The final asm parameter are the operation altered non-output registers.
 */
#define ACPI_ACQUIRE_GLOBAL_LOCK(GLptr, Acq) \
	do { \
		int dummy; \
		asm("1:     movl (%1),%%eax;" \
			"movl   %%eax,%%edx;" \
			"andl   %2,%%edx;" \
			"btsl   $0x1,%%edx;" \
			"adcl   $0x0,%%edx;" \
			"lock;  cmpxchgl %%edx,(%1);" \
			"jnz    1b;" \
			"cmpb   $0x3,%%dl;" \
			"sbbl   %%eax,%%eax" \
			:"=a"(Acq),"=c"(dummy):"c"(GLptr),"i"(~1L):"dx"); \
	} while(0)

#define ACPI_RELEASE_GLOBAL_LOCK(GLptr, Acq) \
	do { \
		int dummy; \
		asm("1:     movl (%1),%%eax;" \
			"movl   %%eax,%%edx;" \
			"andl   %2,%%edx;" \
			"lock;  cmpxchgl %%edx,(%1);" \
			"jnz    1b;" \
			"andl   $0x1,%%eax" \
			:"=a"(Acq),"=c"(dummy):"c"(GLptr),"i"(~3L):"dx"); \
	} while(0)


/*
 * Math helper asm macros
 */
#define ACPI_DIV_64_BY_32(n_hi, n_lo, d32, q32, r32) \
		asm("divl %2;"        \
		:"=a"(q32), "=d"(r32) \
		:"r"(d32),            \
		"0"(n_lo), "1"(n_hi))


#define ACPI_SHIFT_RIGHT_64(n_hi, n_lo) \
	asm("shrl   $1,%2;"             \
		"rcrl   $1,%3;"             \
		:"=r"(n_hi), "=r"(n_lo)     \
		:"0"(n_hi), "1"(n_lo))

/*! [End] no source code translation !*/

#endif /* IA 32 */

/* This macro is used to tag functions as "printf-like" because
 * some compilers (like GCC) can catch printf format string problems.
 */
#define ACPI_PRINTF_LIKE_FUNC __attribute__ ((__format__ (__printf__, 4, 5)))

#endif /* __ACGCC_H__ */
