/* SPDX-License-Identifier: GPL-2.0-only
 */

/*
 *  soc_sdw_rt_amp_coeff_tables.h - related coefficients for RTK amplifier parameters
 */

#ifndef SND_SOC_SDW_RT_SDW_AMP_COEFF_H
#define SND_SOC_SDW_RT_SDW_AMP_COEFF_H

#define RT1308_MAX_BQ_REG 480
#define RT1316_MAX_BQ_REG 580

static const u8 __maybe_unused dell_0a5d_bq_params[] = {
	0xb0, 0xc5, 0x00,  /* address: 0xc5b0; data: 0x00 */
	0xb1, 0xc5, 0x32,
	0xb2, 0xc5, 0x44,
	0xb3, 0xc5, 0x19,
	0xc0, 0xc5, 0x04,
	0xc1, 0xc5, 0x00,
	0xc2, 0xc5, 0x00,
	0xc3, 0xc5, 0x00,
	0xd0, 0xc5, 0x02,
	0xd1, 0xc5, 0x00,
	0xd2, 0xc5, 0x00,
	0xd3, 0xc5, 0x00,
	0xe0, 0xc5, 0x01,
	0xe1, 0xc5, 0xe8,
	0xe2, 0xc5, 0x5f,
	0xe3, 0xc5, 0x8a,
	0xf0, 0xc5, 0x1f,
	0xf1, 0xc5, 0x4e,
	0xf2, 0xc5, 0x90,
	0xf3, 0xc5, 0x11,
	0x50, 0xc6, 0x01,
	0x51, 0xc6, 0xff,
	0x52, 0xc6, 0x45,
	0x53, 0xc6, 0x41,
	0x60, 0xc6, 0x1c,
	0x61, 0xc6, 0x00,
	0x62, 0xc6, 0x00,
	0x63, 0xc6, 0x00,
	0x70, 0xc6, 0x02,
	0x71, 0xc6, 0x00,
	0x72, 0xc6, 0x00,
	0x73, 0xc6, 0x00,
	0x80, 0xc6, 0x03,
	0x81, 0xc6, 0xfe,
	0x82, 0xc6, 0x89,
	0x83, 0xc6, 0xfa,
	0x90, 0xc6, 0x1e,
	0x91, 0xc6, 0x01,
	0x92, 0xc6, 0x74,
	0x93, 0xc6, 0xf6,
	0x00, 0xc6, 0x01,
	0x01, 0xc6, 0xd9,
	0x02, 0xc6, 0xfb,
	0x03, 0xc6, 0xc4,
	0x10, 0xc6, 0x1c,
	0x11, 0xc6, 0x00,
	0x12, 0xc6, 0x00,
	0x13, 0xc6, 0x00,
	0x20, 0xc6, 0x02,
	0x21, 0xc6, 0x00,
	0x22, 0xc6, 0x00,
	0x23, 0xc6, 0x00,
	0x30, 0xc6, 0x03,
	0x31, 0xc6, 0xaf,
	0x32, 0xc6, 0x23,
	0x33, 0xc6, 0xcb,
	0x40, 0xc6, 0x1e,
	0x41, 0xc6, 0x47,
	0x42, 0xc6, 0x34,
	0x43, 0xc6, 0xba,
	0xa0, 0xc6, 0x01,
	0xa1, 0xc6, 0xff,
	0xa2, 0xc6, 0x45,
	0xa3, 0xc6, 0x41,
	0xb0, 0xc6, 0x1c,
	0xb1, 0xc6, 0x00,
	0xb2, 0xc6, 0x00,
	0xb3, 0xc6, 0x00,
	0xc0, 0xc6, 0x02,
	0xc1, 0xc6, 0x00,
	0xc2, 0xc6, 0x00,
	0xc3, 0xc6, 0x00,
	0xd0, 0xc6, 0x03,
	0xd1, 0xc6, 0xfe,
	0xd2, 0xc6, 0x89,
	0xd3, 0xc6, 0xfa,
	0xe0, 0xc6, 0x1e,
	0xe1, 0xc6, 0x01,
	0xe2, 0xc6, 0x74,
	0xe3, 0xc6, 0xf6,
	0x40, 0xc5, 0x0d,
	0x30, 0xc7, 0x15,
	0x31, 0xc7, 0x7c,
	0x32, 0xc7, 0x0f,
	0x33, 0xc7, 0xa0,
	0x40, 0xc7, 0x00,
	0x41, 0xc7, 0x00,
	0x42, 0xc7, 0xf8,
	0x43, 0xc7, 0xf8,
	0x50, 0xc7, 0x00,
	0x51, 0xc7, 0x00,
	0x52, 0xc7, 0x00,
	0x53, 0xc7, 0x01,
	0x90, 0xc7, 0x00,
	0x91, 0xc7, 0x14,
	0x92, 0xc7, 0x00,
	0x93, 0xc7, 0x14,
	0xa0, 0xc7, 0x00,
	0xa1, 0xc7, 0x00,
	0xa2, 0xc7, 0xf8,
	0xa3, 0xc7, 0xf8,
	0xb0, 0xc7, 0x00,
	0xb1, 0xc7, 0x00,
	0xb2, 0xc7, 0x00,
	0xb3, 0xc7, 0x00,
	0x60, 0xc7, 0x03,
	0x61, 0xc7, 0xe8,
	0x62, 0xc7, 0x03,
	0x63, 0xc7, 0xb6,
	0x70, 0xc7, 0x00,
	0x71, 0xc7, 0x00,
	0x72, 0xc7, 0xf8,
	0x73, 0xc7, 0xf8,
	0x80, 0xc7, 0x00,
	0x81, 0xc7, 0x00,
	0x82, 0xc7, 0x00,
	0x83, 0xc7, 0x00,
	0xc0, 0xc7, 0x00,
	0xc1, 0xc7, 0x14,
	0xc2, 0xc7, 0x00,
	0xc3, 0xc7, 0x14,
	0xd0, 0xc7, 0x00,
	0xd1, 0xc7, 0x00,
	0xd2, 0xc7, 0xf8,
	0xd3, 0xc7, 0xf8,
	0xe0, 0xc7, 0x00,
	0xe1, 0xc7, 0x00,
	0xe2, 0xc7, 0x00,
	0xe3, 0xc7, 0x00,
	0x60, 0xc5, 0x02,
	0x61, 0xc5, 0x00,
	0x62, 0xc5, 0x00,
	0x63, 0xc5, 0x00,
	0x70, 0xc5, 0x02,
	0x71, 0xc5, 0x00,
	0x72, 0xc5, 0x00,
	0x73, 0xc5, 0x00,
	0x80, 0xc5, 0x02,
	0x81, 0xc5, 0x00,
	0x82, 0xc5, 0x00,
	0x83, 0xc5, 0x00,
	0x90, 0xc5, 0x02,
	0x91, 0xc5, 0x00,
	0x92, 0xc5, 0x00,
	0x93, 0xc5, 0x00,
	0x50, 0xc5, 0x01,
};

static const u8 __maybe_unused dell_0b00_bq_params[] = {
	0x03, 0xc2, 0x00,
	0x04, 0xc2, 0xb2,
	0x05, 0xc2, 0xe0,
	0x06, 0xc2, 0x3a,
	0x07, 0xc2, 0x01,
	0x08, 0xc2, 0x65,
	0x09, 0xc2, 0xc0,
	0x0a, 0xc2, 0x75,
	0x0b, 0xc2, 0x00,
	0x0c, 0xc2, 0xb2,
	0x0d, 0xc2, 0xe0,
	0x0e, 0xc2, 0x3a,
	0x0f, 0xc2, 0xf7,
	0x10, 0xc2, 0x4d,
	0x11, 0xc2, 0x5b,
	0x12, 0xc2, 0xe9,
	0x13, 0xc2, 0x03,
	0x14, 0xc2, 0x7e,
	0x15, 0xc2, 0x25,
	0x16, 0xc2, 0x01,
	0x17, 0xc2, 0x07,
	0x18, 0xc2, 0xfd,
	0x19, 0xc2, 0x15,
	0x1a, 0xc2, 0x04,
	0x1b, 0xc2, 0xf0,
	0x1c, 0xc2, 0x05,
	0x1d, 0xc2, 0xd5,
	0x1e, 0xc2, 0xf7,
	0x1f, 0xc2, 0x07,
	0x20, 0xc2, 0xfd,
	0x21, 0xc2, 0x15,
	0x22, 0xc2, 0x04,
	0x23, 0xc2, 0xf0,
	0x24, 0xc2, 0x05,
	0x25, 0xc2, 0xd8,
	0x26, 0xc2, 0x17,
	0x27, 0xc2, 0x07,
	0x28, 0xc2, 0xfa,
	0x29, 0xc2, 0x2c,
	0x2a, 0xc2, 0x29,
	0x2b, 0xc2, 0x07,
	0x2c, 0xc2, 0x74,
	0x2d, 0xc2, 0xe0,
	0x2e, 0xc2, 0x33,
	0x2f, 0xc2, 0xf1,
	0x30, 0xc2, 0x16,
	0x31, 0xc2, 0x3f,
	0x32, 0xc2, 0x9b,
	0x33, 0xc2, 0x07,
	0x34, 0xc2, 0x74,
	0x35, 0xc2, 0xe0,
	0x36, 0xc2, 0x33,
	0x37, 0xc2, 0xf1,
	0x38, 0xc2, 0x29,
	0x39, 0xc2, 0xb0,
	0x3a, 0xc2, 0x4d,
	0x3b, 0xc2, 0x06,
	0x3c, 0xc2, 0xfd,
	0x3d, 0xc2, 0x31,
	0x3e, 0xc2, 0x18,
	0x3f, 0xc2, 0x07,
	0x40, 0xc2, 0xfd,
	0x41, 0xc2, 0x15,
	0x42, 0xc2, 0x04,
	0x43, 0xc2, 0xf0,
	0x44, 0xc2, 0x05,
	0x45, 0xc2, 0xd5,
	0x46, 0xc2, 0xf7,
	0x47, 0xc2, 0x07,
	0x48, 0xc2, 0xfd,
	0x49, 0xc2, 0x15,
	0x4a, 0xc2, 0x04,
	0x4b, 0xc2, 0xf0,
	0x4c, 0xc2, 0x05,
	0x4d, 0xc2, 0xd8,
	0x4e, 0xc2, 0x17,
	0x4f, 0xc2, 0x07,
	0x50, 0xc2, 0xfa,
	0x51, 0xc2, 0x2c,
	0x52, 0xc2, 0x29,
	0x0b, 0xc0, 0x30,
	0x80, 0xc3, 0x13,
	0x81, 0xc3, 0x88,
	0x82, 0xc3, 0x17,
	0x83, 0xc3, 0x70,
	0x84, 0xc3, 0x00,
	0x85, 0xc3, 0x00,
	0x86, 0xc3, 0xff,
	0x87, 0xc3, 0xee,
	0x88, 0xc3, 0x02,
	0x92, 0xc3, 0x00,
	0x93, 0xc3, 0x14,
	0x94, 0xc3, 0x00,
	0x95, 0xc3, 0x14,
	0x96, 0xc3, 0x00,
	0x97, 0xc3, 0x00,
	0x98, 0xc3, 0x00,
	0x99, 0xc3, 0x00,
	0x9a, 0xc3, 0x01,
	0x89, 0xc3, 0x03,
	0x8a, 0xc3, 0xe8,
	0x8b, 0xc3, 0x03,
	0x8c, 0xc3, 0xb6,
	0x8d, 0xc3, 0x00,
	0x8e, 0xc3, 0x00,
	0x8f, 0xc3, 0xff,
	0x90, 0xc3, 0xee,
	0x91, 0xc3, 0x01,
	0x9b, 0xc3, 0x00,
	0x9c, 0xc3, 0x14,
	0x9d, 0xc3, 0x00,
	0x9e, 0xc3, 0x14,
	0x9f, 0xc3, 0x00,
	0xa0, 0xc3, 0x00,
	0xa1, 0xc3, 0x00,
	0xa2, 0xc3, 0x00,
	0xa3, 0xc3, 0x01,
	0x61, 0xc2, 0x08,
	0x62, 0xc2, 0x00,
	0x63, 0xc2, 0x00,
	0x64, 0xc2, 0x00,
	0x65, 0xc2, 0x08,
	0x66, 0xc2, 0x00,
	0x67, 0xc2, 0x00,
	0x68, 0xc2, 0x00,
	0x69, 0xc2, 0x08,
	0x6a, 0xc2, 0x00,
	0x6b, 0xc2, 0x00,
	0x6c, 0xc2, 0x00,
	0x6d, 0xc2, 0x08,
	0x6e, 0xc2, 0x00,
	0x6f, 0xc2, 0x00,
	0x70, 0xc2, 0x00,
	0x00, 0xc2, 0xc0,
};

#endif
