These files, and several snippets of other files, are generated by Dawn
(Chromium's WebGPU library):
- [Generator](https://source.chromium.org/chromium/chromium/src/+/main:third_party/dawn/generator/)
- [Generator input](https://source.chromium.org/chromium/chromium/src/+/main:third_party/dawn/dawn.json)
- [Generator output](https://source.chromium.org/chromium/chromium/src/+/main:out/Debug/gen/third_party/dawn/emscripten-bits/)

The C header is mostly the same as the "upstream"
[`webgpu.h`](https://github.com/webgpu-native/webgpu-headers/blob/main/webgpu.h),
but native-specific elements are not included.

The C++ files are **currently** Dawn-specific, but included in Emscripten for
better compatibility with Dawn: it has roughly the same API as Dawn's copy, but
is included here because it is strongly tied to an exact `webgpu.h` revision.

Dawn additionally autogenerates two "snippets" that are used in Emscripten:
- `library_webgpu_enum_tables.js`, which is pasted into [`library_webgpu.js`](../../../src/library_webgpu.js)
- `webgpu_struct_info.json`, which is pasted into [`struct_info.json`](../../../src/struct_info.json).

Once that's done, you need to update the auto-generated files with the commands below:

```
./tools/gen_struct_info.py
./tools/gen_struct_info.py --wasm64
./tools/gen_sig_info.py
```

## Testing

There is a `browser.test_webgpu_basic_rendering` with minimal WebGPU API testing that can be handy to test manually before making a contribution.

```
test/runner browser.test_webgpu_basic_rendering
```

You may need to specify extra browser cmd args to assign the WebGPU supported browser, which is needed if you work on linux where WebGPU is not enabled by default in chrome at present.

```
test/runner browser.test_webgpu_basic_rendering --browser="google-chrome-unstable --enable-unsafe-webgpu --enable-features=Vulkan,UseSkiaRenderer"
```

Alternatively you can test your emscripten updates by building the source file, and then serve (e.g. use node http-server) and view in browser to make sure things work fine.

```
emcc test/webgpu_basic_rendering.cpp -sUSE_WEBGPU -o path/to/index.html
```
