/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.java;

import io.cucumber.core.backend.HookDefinition;
import io.cucumber.core.backend.Lookup;
import io.cucumber.core.backend.TestCaseState;
import io.cucumber.java.AbstractGlueDefinition;
import io.cucumber.java.After;
import io.cucumber.java.AfterStep;
import io.cucumber.java.Before;
import io.cucumber.java.BeforeStep;
import io.cucumber.java.InvalidMethodSignatureException;
import io.cucumber.java.Scenario;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Objects;

final class JavaHookDefinition
extends AbstractGlueDefinition
implements HookDefinition {
    private final String tagExpression;
    private final int order;

    JavaHookDefinition(Method method, String tagExpression, int order, Lookup lookup) {
        super(JavaHookDefinition.requireValidMethod(method), lookup);
        this.tagExpression = Objects.requireNonNull(tagExpression, "tag-expression may not be null");
        this.order = order;
    }

    private static Method requireValidMethod(Method method) {
        Class<?> parameterType;
        Class<?>[] parameterTypes = method.getParameterTypes();
        if (parameterTypes.length > 1) {
            throw JavaHookDefinition.createInvalidSignatureException(method);
        }
        if (parameterTypes.length == 1 && !Object.class.equals(parameterType = parameterTypes[0]) && !Scenario.class.equals(parameterType)) {
            throw JavaHookDefinition.createInvalidSignatureException(method);
        }
        Type returnType = method.getGenericReturnType();
        if (!Void.class.equals((Object)returnType) && !Void.TYPE.equals(returnType)) {
            throw JavaHookDefinition.createInvalidSignatureException(method);
        }
        return method;
    }

    private static InvalidMethodSignatureException createInvalidSignatureException(Method method) {
        return InvalidMethodSignatureException.builder(method).addAnnotation(Before.class).addAnnotation(After.class).addAnnotation(BeforeStep.class).addAnnotation(AfterStep.class).addSignature("public void before_or_after(io.cucumber.java.Scenario scenario)").addSignature("public void before_or_after()").build();
    }

    public void execute(TestCaseState state) {
        Object[] args = this.method.getParameterTypes().length == 1 ? new Object[]{new Scenario(state)} : new Object[]{};
        this.invokeMethod(args);
    }

    public String getTagExpression() {
        return this.tagExpression;
    }

    public int getOrder() {
        return this.order;
    }
}

