/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.networking;

import java.util.HashMap;
import java.util.Map;
import javax.xml.stream.XMLStreamException;
import net.sf.freecol.common.io.FreeColXMLReader;
import net.sf.freecol.common.networking.Message;
import net.sf.freecol.common.networking.TrivialMessage;

public class AttributeMessage
extends TrivialMessage {
    public static final String TAG = "attribute";
    protected final Map<String, String> attributes = new HashMap<String, String>();
    private boolean mergeable = false;

    public AttributeMessage(String type) {
        super(type);
        this.attributes.clear();
    }

    public AttributeMessage(String type, String ... attributes) {
        this(type);
        this.setStringAttributes(attributes);
    }

    protected AttributeMessage(String type, Map<String, String> attributeMap) {
        this(type);
        this.setStringAttributeMap(attributeMap);
    }

    protected AttributeMessage(String type, FreeColXMLReader xr, String ... attributes) throws XMLStreamException {
        this(type, xr.getAttributeMap(attributes));
        xr.closeTag(type);
    }

    @Override
    protected boolean hasAttribute(String key) {
        return this.attributes.containsKey(key);
    }

    @Override
    protected String getStringAttribute(String key) {
        return this.attributes.get(key);
    }

    @Override
    protected void setStringAttribute(String key, String value) {
        if (key != null && value != null) {
            this.attributes.put(key, value);
        }
    }

    @Override
    protected Map<String, String> getStringAttributeMap() {
        return this.attributes;
    }

    @Override
    public Message.MessagePriority getPriority() {
        return Message.MessagePriority.ATTRIBUTE;
    }

    @Override
    public boolean canMerge() {
        return this.mergeable;
    }

    public AttributeMessage setMergeable(boolean mergeable) {
        this.mergeable = mergeable;
        return this;
    }
}

