/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.server.ai.mission;

import java.util.logging.Logger;
import javax.xml.stream.XMLStreamException;
import net.sf.freecol.common.io.FreeColXMLReader;
import net.sf.freecol.common.io.FreeColXMLWriter;
import net.sf.freecol.common.model.Colony;
import net.sf.freecol.common.model.Direction;
import net.sf.freecol.common.model.FreeColGameObject;
import net.sf.freecol.common.model.IndianSettlement;
import net.sf.freecol.common.model.Location;
import net.sf.freecol.common.model.PathNode;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.Settlement;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.model.pathfinding.CostDecider;
import net.sf.freecol.common.model.pathfinding.CostDeciders;
import net.sf.freecol.common.model.pathfinding.GoalDecider;
import net.sf.freecol.common.model.pathfinding.GoalDeciders;
import net.sf.freecol.common.util.LogBuilder;
import net.sf.freecol.server.ai.AIMain;
import net.sf.freecol.server.ai.AIMessage;
import net.sf.freecol.server.ai.AIUnit;
import net.sf.freecol.server.ai.mission.Mission;

public final class MissionaryMission
extends Mission {
    private static final Logger logger = Logger.getLogger(MissionaryMission.class.getName());
    public static final String TAG = "missionaryMission";
    private static final String tag = "AI missionary";
    private Location target;
    private static final String TARGET_TAG = "target";

    public MissionaryMission(AIMain aiMain, AIUnit aiUnit, Location target) {
        super(aiMain, aiUnit);
        this.setTarget(target);
    }

    public MissionaryMission(AIMain aiMain, AIUnit aiUnit, FreeColXMLReader xr) throws XMLStreamException {
        super(aiMain, aiUnit);
        this.readFromXML(xr);
    }

    private static Location extractTarget(AIUnit aiUnit, PathNode path) {
        Settlement settlement;
        if (path == null) {
            return null;
        }
        Location loc = path.getLastNode().getLocation();
        Settlement settlement2 = settlement = loc == null ? null : loc.getSettlement();
        return settlement instanceof IndianSettlement && MissionaryMission.invalidIndianSettlementReason(aiUnit, (IndianSettlement)settlement) == null ? (IndianSettlement)settlement : (settlement instanceof Colony && MissionaryMission.invalidColonyReason(aiUnit, (Colony)settlement) == null ? (Colony)settlement : null);
    }

    public static int scorePath(AIUnit aiUnit, PathNode path) {
        Location loc = MissionaryMission.extractTarget(aiUnit, path);
        return loc instanceof IndianSettlement ? 1000 / (path.getTotalTurns() + 1) : Integer.MIN_VALUE;
    }

    private static GoalDecider getGoalDecider(final AIUnit aiUnit, boolean deferOK) {
        GoalDecider gd = new GoalDecider(){
            private PathNode bestPath = null;
            private int bestValue = Integer.MIN_VALUE;

            @Override
            public PathNode getGoal() {
                return this.bestPath;
            }

            @Override
            public boolean hasSubGoals() {
                return true;
            }

            @Override
            public boolean check(Unit u, PathNode path) {
                int value;
                if (path.getLastNode().getLocation().getSettlement() instanceof IndianSettlement && this.bestValue < (value = MissionaryMission.scorePath(aiUnit, path))) {
                    this.bestValue = value;
                    this.bestPath = path;
                    return true;
                }
                return false;
            }
        };
        return deferOK ? GoalDeciders.getComposedGoalDecider(false, gd, GoalDeciders.getOurClosestSettlementGoalDecider()) : gd;
    }

    private static PathNode findTargetPath(AIUnit aiUnit, int range, boolean deferOK) {
        if (MissionaryMission.invalidAIUnitReason(aiUnit) != null) {
            return null;
        }
        Unit unit = aiUnit.getUnit();
        Location start = unit.getPathStartLocation();
        Unit carrier = unit.getCarrier();
        GoalDecider gd = MissionaryMission.getGoalDecider(aiUnit, deferOK);
        CostDecider standardCd = CostDeciders.avoidSettlementsAndBlockingUnits();
        return unit.search(start, gd, standardCd, range, carrier);
    }

    public static Location findMissionTarget(AIUnit aiUnit, int range, boolean deferOK) {
        PathNode path = MissionaryMission.findTargetPath(aiUnit, range, deferOK);
        return path == null ? null : MissionaryMission.extractTarget(aiUnit, path);
    }

    public static String prepare(AIUnit aiUnit) {
        String reason = MissionaryMission.invalidUnitReason(aiUnit);
        if (reason == null) {
            Unit unit = aiUnit.getUnit();
            if (!unit.hasAbility("model.ability.establishMission") && ((FreeColGameObject)((Object)unit.getLocation())).hasAbility("model.ability.dressMissionary")) {
                aiUnit.equipForRole(unit.getSpecification().getMissionaryRole());
            }
            reason = unit.hasAbility("model.ability.establishMission") ? null : "unit-can-not-establish-mission";
        }
        return reason;
    }

    private static String invalidUnitReason(AIUnit aiUnit) {
        String reason = MissionaryMission.invalidAIUnitReason(aiUnit);
        if (reason != null) {
            return reason;
        }
        Unit unit = aiUnit.getUnit();
        return !unit.isPerson() ? "unit-not-a-person" : (unit.getSkillLevel() >= -1 && !unit.hasAbility("model.ability.expertMissionary") ? "unit-is-not-subskilled-or-expertMissionary" : (unit.isInEurope() || unit.isAtSea() ? (!unit.getOwner().hasSettlements() ? "unit-off-map-but-missing-initial-settlement" : null) : (unit.isInMission() ? "unit-is-already-at-mission" : null)));
    }

    private static String invalidColonyReason(AIUnit aiUnit, Colony colony) {
        return MissionaryMission.invalidTargetReason(colony, aiUnit.getUnit().getOwner());
    }

    private static String invalidIndianSettlementReason(AIUnit aiUnit, IndianSettlement is) {
        String reason = MissionaryMission.invalidTargetReason(is);
        if (reason != null) {
            return reason;
        }
        Player owner = aiUnit.getUnit().getOwner();
        return !owner.hasContacted(is.getOwner()) ? "target-is-uncontacted" : (is.getOwner().atWarWith(owner) ? "target-at-war" : (is.hasMissionary(owner) ? "target-has-our-mission" : null));
    }

    public static String invalidMissionReason(AIUnit aiUnit) {
        return MissionaryMission.invalidUnitReason(aiUnit);
    }

    public static String invalidMissionReason(AIUnit aiUnit, Location loc) {
        String reason = MissionaryMission.invalidMissionReason(aiUnit);
        return reason != null ? reason : (loc instanceof IndianSettlement ? MissionaryMission.invalidIndianSettlementReason(aiUnit, (IndianSettlement)loc) : (loc instanceof Colony ? MissionaryMission.invalidColonyReason(aiUnit, (Colony)loc) : "target-invalid"));
    }

    @Override
    public int getBaseTransportPriority() {
        return 100;
    }

    @Override
    public Location getTarget() {
        return this.target;
    }

    @Override
    public void setTarget(Location target) {
        if (target == null || target instanceof Settlement) {
            this.target = target;
        }
    }

    @Override
    public Location findTarget() {
        return MissionaryMission.findMissionTarget(this.getAIUnit(), 20, true);
    }

    @Override
    public String invalidReason() {
        return MissionaryMission.invalidMissionReason(this.getAIUnit(), this.getTarget());
    }

    @Override
    public Mission doMission(LogBuilder lb) {
        lb.add(tag);
        String reason = this.invalidReason();
        if (MissionaryMission.isTargetReason(reason)) {
            return this.retargetMission(reason, lb);
        }
        if (reason != null) {
            return this.lbFail(lb, false, reason);
        }
        AIUnit aiUnit = this.getAIUnit();
        Unit unit = this.getUnit();
        Unit.MoveType mt = this.travelToTarget(this.getTarget(), CostDeciders.avoidSettlementsAndBlockingUnits(), lb);
        switch (mt) {
            case MOVE: {
                this.lbAt(lb);
                Location completed = this.getTarget();
                Location newTarget = MissionaryMission.findMissionTarget(aiUnit, 20, false);
                if (newTarget == null || newTarget == completed) {
                    return this.lbFail(lb, false, "retarget failed");
                }
                this.setTarget(newTarget);
                return this.lbRetarget(lb);
            }
            case MOVE_HIGH_SEAS: 
            case MOVE_NO_MOVES: 
            case MOVE_ILLEGAL: {
                return this.lbWait(lb, new Object[0]);
            }
            case MOVE_NO_REPAIR: {
                return this.lbFail(lb, false, "aiUnit-died");
            }
            case MOVE_NO_ACCESS_EMBARK: 
            case MOVE_NO_TILE: {
                return this;
            }
            case ENTER_INDIAN_SETTLEMENT_WITH_MISSIONARY: {
                break;
            }
            default: {
                return this.lbMove(lb, mt);
            }
        }
        this.lbAt(lb);
        Direction d = unit.getTile().getDirection(this.getTarget().getTile());
        assert (d != null);
        IndianSettlement is = (IndianSettlement)this.getTarget();
        AIMessage.askEstablishMission(aiUnit, d, is.hasMissionary());
        return is.hasMissionary(unit.getOwner()) && unit.isInMission() ? this.lbDone(lb, false, "established") : this.lbFail(lb, false, "establish");
    }

    @Override
    protected void writeAttributes(FreeColXMLWriter xw) throws XMLStreamException {
        super.writeAttributes(xw);
        if (this.target != null) {
            xw.writeAttribute(TARGET_TAG, this.target.getId());
        }
    }

    @Override
    protected void readAttributes(FreeColXMLReader xr) throws XMLStreamException {
        super.readAttributes(xr);
        this.target = xr.getLocationAttribute(this.getGame(), TARGET_TAG, false);
    }

    @Override
    public String getXMLTagName() {
        return TAG;
    }
}

