/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.save;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Iterator;
import java.util.TimeZone;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriter;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import tim.prune.App;
import tim.prune.GenericFunction;
import tim.prune.I18nManager;
import tim.prune.UpdateMessageBroker;
import tim.prune.config.ColourUtils;
import tim.prune.config.Config;
import tim.prune.config.TimezoneHelper;
import tim.prune.data.DataPoint;
import tim.prune.data.Field;
import tim.prune.data.Timestamp;
import tim.prune.data.Track;
import tim.prune.data.TrackInfo;
import tim.prune.data.UnitSetLibrary;
import tim.prune.gui.DialogCloser;
import tim.prune.gui.ImageUtils;
import tim.prune.gui.WholeNumberField;
import tim.prune.gui.colour.ColourChooser;
import tim.prune.gui.colour.ColourPatch;
import tim.prune.load.GenericFileFilter;
import tim.prune.save.PointTypeSelector;
import tim.prune.save.xml.XmlUtils;

public class KmlExporter
extends GenericFunction
implements Runnable {
    private final TrackInfo _trackInfo;
    private final Track _track;
    private JDialog _dialog = null;
    private JTextField _descriptionField = null;
    private PointTypeSelector _pointTypeSelector = null;
    private JRadioButton _gxExtensionsRadio = null;
    private JCheckBox _altitudesCheckbox = null;
    private JCheckBox _kmzCheckbox = null;
    private JCheckBox _exportImagesCheckbox = null;
    private JLabel _imageSizeLabel = null;
    private WholeNumberField _imageSizeField = null;
    private ColourPatch _colourPatch = null;
    private JLabel _progressLabel = null;
    private JProgressBar _progressBar = null;
    private Dimension[] _imageDimensions = null;
    private JFileChooser _fileChooser = null;
    private File _exportFile = null;
    private JButton _okButton = null;
    private boolean _cancelPressed = false;
    private ColourChooser _colourChooser = null;
    private static final String KML_FILENAME_IN_KMZ = "doc.kml";
    private static final int DEFAULT_THUMBNAIL_WIDTH = 240;
    private static final Color DEFAULT_TRACK_COLOUR = new Color(204, 0, 0);

    public KmlExporter(App app) {
        super(app);
        this._trackInfo = app.getTrackInfo();
        this._track = this._trackInfo.getTrack();
    }

    @Override
    public String getNameKey() {
        return "function.exportkml";
    }

    @Override
    public void begin() {
        if (this._dialog == null) {
            this._dialog = new JDialog(this._parentFrame, this.getName(), true);
            this._dialog.setLocationRelativeTo(this._parentFrame);
            this._dialog.setDefaultCloseOperation(2);
            this._dialog.getContentPane().add(this.makeDialogComponents());
            this._dialog.pack();
            this._colourChooser = new ColourChooser(this._dialog);
        }
        this._imageSizeField.setValue(Config.getConfigInt("prune.kmzimagewidth"));
        this.enableCheckboxes();
        this._descriptionField.setEnabled(true);
        this._okButton.setEnabled(true);
        this._progressLabel.setText("");
        this._progressBar.setVisible(false);
        this._dialog.setVisible(true);
    }

    private Component makeDialogComponents() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 5));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 1));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new FlowLayout());
        jPanel3.add(new JLabel(I18nManager.getText("dialog.exportkml.text")));
        this._descriptionField = new JTextField(20);
        this._descriptionField.addKeyListener(new DialogCloser(this._dialog));
        jPanel3.add(this._descriptionField);
        jPanel3.setAlignmentX(0.5f);
        jPanel2.add(jPanel3);
        jPanel.add((Component)jPanel2, "Center");
        this._pointTypeSelector = new PointTypeSelector();
        this._pointTypeSelector.setAlignmentX(0.5f);
        jPanel2.add(this._pointTypeSelector);
        Color color = ColourUtils.colourFromHex(Config.getConfigString("prune.kmltrackcolour"));
        if (color == null) {
            color = DEFAULT_TRACK_COLOUR;
        }
        this._colourPatch = new ColourPatch(color);
        this._colourPatch.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                KmlExporter.this._colourChooser.showDialog(KmlExporter.this._colourPatch.getBackground());
                KmlExporter.this._colourPatch.setColour(KmlExporter.this._colourChooser.getChosenColour());
            }
        });
        JPanel jPanel4 = new JPanel();
        jPanel4.add(new JLabel(I18nManager.getText("dialog.exportkml.trackcolour")));
        jPanel4.add(this._colourPatch);
        jPanel2.add(jPanel4);
        JRadioButton jRadioButton = new JRadioButton(I18nManager.getText("dialog.exportkml.standardkml"));
        this._gxExtensionsRadio = new JRadioButton(I18nManager.getText("dialog.exportkml.extendedkml"));
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(jRadioButton);
        buttonGroup.add(this._gxExtensionsRadio);
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout(new FlowLayout(1, 10, 1));
        jPanel5.add(jRadioButton);
        jPanel5.add(this._gxExtensionsRadio);
        jRadioButton.setSelected(true);
        jPanel2.add(jPanel5);
        this._altitudesCheckbox = new JCheckBox(I18nManager.getText("dialog.exportkml.altitude"));
        this._altitudesCheckbox.setHorizontalTextPosition(2);
        this._altitudesCheckbox.setAlignmentX(0.5f);
        jPanel2.add(this._altitudesCheckbox);
        this._kmzCheckbox = new JCheckBox(I18nManager.getText("dialog.exportkml.kmz"));
        this._kmzCheckbox.setHorizontalTextPosition(2);
        this._kmzCheckbox.setAlignmentX(0.5f);
        this._kmzCheckbox.addActionListener(actionEvent -> this.enableCheckboxes());
        jPanel2.add(this._kmzCheckbox);
        this._exportImagesCheckbox = new JCheckBox(I18nManager.getText("dialog.exportkml.exportimages"));
        this._exportImagesCheckbox.setHorizontalTextPosition(2);
        this._exportImagesCheckbox.setAlignmentX(0.5f);
        this._exportImagesCheckbox.addActionListener(actionEvent -> this.enableImageSizeFields());
        jPanel2.add(this._exportImagesCheckbox);
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout(new FlowLayout(1));
        this._imageSizeLabel = new JLabel(I18nManager.getText("dialog.exportkml.imagesize"));
        this._imageSizeLabel.setAlignmentX(1.0f);
        jPanel6.add(this._imageSizeLabel);
        this._imageSizeField = new WholeNumberField(4);
        jPanel6.add(this._imageSizeField);
        jPanel2.add(jPanel6);
        jPanel2.add(Box.createVerticalStrut(10));
        this._progressLabel = new JLabel("...");
        this._progressLabel.setAlignmentX(0.5f);
        jPanel2.add(this._progressLabel);
        this._progressBar = new JProgressBar(0, 100);
        this._progressBar.setVisible(false);
        this._progressBar.setAlignmentX(0.5f);
        jPanel2.add(this._progressBar);
        jPanel2.add(Box.createVerticalStrut(10));
        JPanel jPanel7 = new JPanel();
        jPanel7.setLayout(new FlowLayout(2));
        this._okButton = new JButton(I18nManager.getText("button.ok"));
        ActionListener actionListener = actionEvent -> this.startExport();
        this._okButton.addActionListener(actionListener);
        this._descriptionField.addActionListener(actionListener);
        jPanel7.add(this._okButton);
        JButton jButton = new JButton(I18nManager.getText("button.cancel"));
        jButton.addActionListener(actionEvent -> {
            this._cancelPressed = true;
            this._dialog.dispose();
        });
        jPanel7.add(jButton);
        jPanel.add((Component)jPanel7, "South");
        return jPanel;
    }

    private void enableCheckboxes() {
        boolean bl;
        this._pointTypeSelector.init(this._trackInfo);
        boolean bl2 = this._track.hasData(Field.ALTITUDE);
        if (!bl2) {
            this._altitudesCheckbox.setSelected(false);
        }
        this._exportImagesCheckbox.setSelected((bl = this._trackInfo.getPhotoList().hasAny()) && this._kmzCheckbox.isSelected());
        this._exportImagesCheckbox.setEnabled(bl && this._kmzCheckbox.isSelected());
        this.enableImageSizeFields();
    }

    private void enableImageSizeFields() {
        boolean bl = this._exportImagesCheckbox.isEnabled() && this._exportImagesCheckbox.isSelected();
        this._imageSizeField.setEnabled(bl);
        this._imageSizeLabel.setEnabled(bl);
    }

    private boolean useGxExtensions() {
        return this._gxExtensionsRadio.isSelected();
    }

    private void startExport() {
        String string;
        if (!this._pointTypeSelector.getAnythingSelected()) {
            JOptionPane.showMessageDialog(this._parentFrame, I18nManager.getText("dialog.save.notypesselected"), I18nManager.getText("dialog.saveoptions.title"), 2);
            return;
        }
        if (this._fileChooser == null) {
            this._fileChooser = new JFileChooser();
            this._fileChooser.setDialogType(1);
            this._fileChooser.setFileFilter(new GenericFileFilter("filetype.kmlkmz", new String[]{"kml", "kmz"}));
            string = Config.getConfigString("prune.trackdirectory");
            if (string != null) {
                this._fileChooser.setCurrentDirectory(new File(string));
            }
        }
        string = null;
        String string2 = null;
        if (this._kmzCheckbox.isSelected()) {
            string = ".kmz";
            string2 = ".kml";
        } else {
            string = ".kml";
            string2 = ".kmz";
        }
        this._fileChooser.setAcceptAllFileFilterUsed(false);
        boolean bl = false;
        do {
            Object[] objectArray;
            bl = false;
            if (this._fileChooser.showSaveDialog(this._parentFrame) != 0) continue;
            File file = this._fileChooser.getSelectedFile();
            if (file.getName().toLowerCase().endsWith(string2)) {
                objectArray = file.getAbsolutePath();
                file = new File(String.valueOf(objectArray.substring(0, objectArray.length() - string2.length())) + string);
            } else if (!file.getName().toLowerCase().endsWith(string)) {
                file = new File(String.valueOf(file.getAbsolutePath()) + string);
            }
            objectArray = new Object[]{I18nManager.getText("button.overwrite"), I18nManager.getText("button.cancel")};
            if (!file.exists() || JOptionPane.showOptionDialog(this._parentFrame, I18nManager.getText("dialog.save.overwrite.text"), I18nManager.getText("dialog.save.overwrite.title"), 0, 2, null, objectArray, objectArray[1]) == 0) {
                this._exportFile = file;
                this._cancelPressed = false;
                new Thread(this).start();
                continue;
            }
            bl = true;
        } while (bl);
    }

    @Override
    public void run() {
        this._okButton.setEnabled(false);
        this._descriptionField.setEnabled(false);
        this._progressLabel.setText(I18nManager.getText("confirm.running"));
        this._progressBar.setVisible(true);
        this._progressBar.setValue(0);
        boolean bl = this._kmzCheckbox.isSelected();
        boolean bl2 = bl && this._exportImagesCheckbox.isSelected();
        this._progressBar.setMaximum(bl2 ? this.getNumPhotosToExport() : 1);
        this._imageDimensions = new Dimension[this._track.getNumPoints()];
        OutputStreamWriter outputStreamWriter = null;
        ZipOutputStream zipOutputStream = null;
        try {
            if (!this._kmzCheckbox.isSelected()) {
                outputStreamWriter = new OutputStreamWriter(new FileOutputStream(this._exportFile));
            } else {
                zipOutputStream = new ZipOutputStream(new FileOutputStream(this._exportFile));
                if (bl2) {
                    int n = this._imageSizeField.getValue();
                    if (n < 240) {
                        n = 240;
                    }
                    Config.setConfigInt("prune.kmzimagewidth", n);
                    this.exportThumbnails(zipOutputStream, n);
                }
                outputStreamWriter = new OutputStreamWriter(zipOutputStream);
                ZipEntry zipEntry = new ZipEntry(KML_FILENAME_IN_KMZ);
                zipOutputStream.putNextEntry(zipEntry);
            }
            int n = this.exportData(outputStreamWriter, bl2);
            Config.setConfigString("prune.kmltrackcolour", ColourUtils.makeHexCode(this._colourPatch.getBackground()));
            this._progressBar.setValue(1);
            if (zipOutputStream != null) {
                outputStreamWriter.flush();
                zipOutputStream.closeEntry();
            }
            outputStreamWriter.close();
            this._imageDimensions = null;
            Config.setConfigString("prune.trackdirectory", this._exportFile.getParentFile().getAbsolutePath());
            this._app.addRecentFile(this._exportFile, true);
            UpdateMessageBroker.informSubscribers();
            UpdateMessageBroker.informSubscribers(String.valueOf(I18nManager.getText("confirm.save.ok1")) + " " + n + " " + I18nManager.getText("confirm.save.ok2") + " " + this._exportFile.getAbsolutePath());
            this._dialog.dispose();
            return;
        }
        catch (IOException iOException) {
            try {
                if (outputStreamWriter != null) {
                    outputStreamWriter.close();
                }
            }
            catch (IOException iOException2) {}
            JOptionPane.showMessageDialog(this._parentFrame, String.valueOf(I18nManager.getText("error.save.failed")) + " : " + iOException.getMessage(), I18nManager.getText("error.save.dialogtitle"), 0);
            this.startExport();
            return;
        }
    }

    private int exportData(OutputStreamWriter outputStreamWriter, boolean bl) throws IOException {
        boolean bl2;
        boolean bl3 = this._pointTypeSelector.getTrackpointsSelected();
        boolean bl4 = this._pointTypeSelector.getWaypointsSelected();
        boolean bl5 = this._pointTypeSelector.getPhotopointsSelected();
        boolean bl6 = this._pointTypeSelector.getAudiopointsSelected();
        boolean bl7 = this._pointTypeSelector.getJustSelection();
        if (this.useGxExtensions()) {
            outputStreamWriter.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<kml xmlns=\"http://earth.google.com/kml/2.2\" xmlns:gx=\"http://www.google.com/kml/ext/2.2\">\n");
        } else {
            outputStreamWriter.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<kml xmlns=\"http://earth.google.com/kml/2.1\">\n");
        }
        outputStreamWriter.write("<Folder>\n\t<name>");
        if (this._descriptionField != null && this._descriptionField.getText() != null && !this._descriptionField.getText().equals("")) {
            outputStreamWriter.write(XmlUtils.fixCdata(this._descriptionField.getText()));
        } else {
            outputStreamWriter.write("Export from GpsPrune");
        }
        outputStreamWriter.write("</name>\n");
        int n = -1;
        int n2 = -1;
        if (bl7) {
            n = this._trackInfo.getSelection().getStart();
            n2 = this._trackInfo.getSelection().getEnd();
        }
        boolean bl8 = this._altitudesCheckbox.isSelected();
        int n3 = 0;
        DataPoint dataPoint = null;
        boolean bl9 = false;
        boolean bl10 = false;
        boolean bl11 = false;
        int n4 = this._track.getNumPoints();
        int n5 = 0;
        int n6 = 0;
        n3 = 0;
        while (n3 < n4) {
            dataPoint = this._track.getPoint(n3);
            boolean bl12 = bl2 = !bl7 || n3 >= n && n3 <= n2;
            if (dataPoint.isWaypoint()) {
                if (bl4 && bl2) {
                    this.exportWaypoint(dataPoint, outputStreamWriter, bl8);
                    ++n5;
                }
            } else if (!dataPoint.hasMedia()) {
                bl9 = true;
            }
            if (dataPoint.getPhoto() != null && dataPoint.getPhoto().isValid() && bl5 && bl2) {
                if (!bl10) {
                    outputStreamWriter.write("<Style id=\"camera_icon\"><IconStyle><Icon><href>http://maps.google.com/mapfiles/kml/pal4/icon46.png</href></Icon></IconStyle></Style>");
                    bl10 = true;
                }
                this.exportPhotoPoint(dataPoint, outputStreamWriter, bl, n3, ++n6, bl8);
                ++n5;
            }
            if (dataPoint.getAudio() != null && bl6 && bl2) {
                if (!bl11) {
                    outputStreamWriter.write("<Style id=\"audio_icon\"><IconStyle><color>ff00ffff</color><Icon><href>http://maps.google.com/mapfiles/kml/shapes/star.png</href></Icon></IconStyle></Style>");
                    bl11 = true;
                }
                this.exportAudioPoint(dataPoint, outputStreamWriter, bl8);
                ++n5;
            }
            ++n3;
        }
        if (bl9 && bl3) {
            bl2 = this._gxExtensionsRadio.isSelected();
            n5 = bl2 ? (n5 += this.writeGxTrack(outputStreamWriter, bl8, n, n2)) : (n5 += this.writeStandardTrack(outputStreamWriter, bl8, n, n2));
        }
        outputStreamWriter.write("</Folder>\n</kml>\n");
        return n5;
    }

    private int writeStandardTrack(OutputStreamWriter outputStreamWriter, boolean bl, int n, int n2) throws IOException {
        int n3 = 0;
        String string = "\t<Placemark>\n\t\t<name>track</name>\n\t\t<Style>\n\t\t\t<LineStyle>\n\t\t\t\t<color>cc" + KmlExporter.reverse(ColourUtils.makeHexCode(this._colourPatch.getBackground())) + "</color>\n" + "\t\t\t\t<width>4</width>\n\t\t\t</LineStyle>\n" + "\t\t</Style>\n\t\t<LineString>\n";
        string = bl ? String.valueOf(string) + "\t\t\t<extrude>1</extrude>\n\t\t\t<altitudeMode>absolute</altitudeMode>\n" : String.valueOf(string) + "\t\t\t<altitudeMode>clampToGround</altitudeMode>\n";
        string = String.valueOf(string) + "\t\t\t<coordinates>";
        String string2 = "\t\t\t</coordinates>\n\t\t</LineString>\n\t</Placemark>";
        boolean bl2 = this._pointTypeSelector.getJustSelection();
        outputStreamWriter.write(string);
        boolean bl3 = true;
        int n4 = this._track.getNumPoints();
        int n5 = 0;
        while (n5 < n4) {
            boolean bl4;
            DataPoint dataPoint = this._track.getPoint(n5);
            boolean bl5 = bl4 = !bl2 || n5 >= n && n5 <= n2;
            if (!dataPoint.isWaypoint() && bl4 && !dataPoint.hasMedia()) {
                if (dataPoint.getSegmentStart() && !bl3) {
                    outputStreamWriter.write(string2);
                    outputStreamWriter.write(string);
                }
                if (dataPoint.getPhoto() == null) {
                    this.exportTrackpoint(dataPoint, outputStreamWriter);
                    ++n3;
                    bl3 = false;
                }
            }
            ++n5;
        }
        outputStreamWriter.write(string2);
        return n3;
    }

    private int writeGxTrack(OutputStreamWriter outputStreamWriter, boolean bl, int n, int n2) throws IOException {
        int n3 = 0;
        String string = "\t<Placemark>\n\t\t<name>track</name>\n\t\t<Style>\n\t\t\t<LineStyle>\n\t\t\t\t<color>cc" + KmlExporter.reverse(ColourUtils.makeHexCode(this._colourPatch.getBackground())) + "</color>\n" + "\t\t\t\t<width>4</width>\n\t\t\t</LineStyle>\n" + "\t\t</Style>\n\t\t<gx:Track>\n";
        string = bl ? String.valueOf(string) + "\t\t\t<extrude>1</extrude>\n\t\t\t<altitudeMode>absolute</altitudeMode>\n" : String.valueOf(string) + "\t\t\t<altitudeMode>clampToGround</altitudeMode>\n";
        String string2 = "\n\t\t</gx:Track>\n\t</Placemark>\n";
        boolean bl2 = this._pointTypeSelector.getJustSelection();
        outputStreamWriter.write(string);
        StringBuilder stringBuilder = new StringBuilder();
        StringBuilder stringBuilder2 = new StringBuilder();
        boolean bl3 = true;
        int n4 = this._track.getNumPoints();
        int n5 = 0;
        while (n5 < n4) {
            boolean bl4;
            DataPoint dataPoint = this._track.getPoint(n5);
            boolean bl5 = bl4 = !bl2 || n5 >= n && n5 <= n2;
            if (!dataPoint.isWaypoint() && bl4) {
                if (dataPoint.getSegmentStart() && !bl3) {
                    outputStreamWriter.write(stringBuilder.toString());
                    outputStreamWriter.write(10);
                    outputStreamWriter.write(stringBuilder2.toString());
                    outputStreamWriter.write(10);
                    outputStreamWriter.write(string2);
                    stringBuilder.setLength(0);
                    stringBuilder2.setLength(0);
                    outputStreamWriter.write(string);
                }
                if (dataPoint.getPhoto() == null) {
                    stringBuilder.append("<when>");
                    if (dataPoint.hasTimestamp()) {
                        stringBuilder.append(dataPoint.getTimestamp().getText(Timestamp.Format.ISO8601, null));
                    }
                    stringBuilder.append("</when>\n");
                    stringBuilder2.append("<gx:coord>");
                    stringBuilder2.append(dataPoint.getLongitude().output(17)).append(' ');
                    stringBuilder2.append(dataPoint.getLatitude().output(17)).append(' ');
                    if (dataPoint.hasAltitude()) {
                        stringBuilder2.append(dataPoint.getAltitude().getStringValue(UnitSetLibrary.UNITS_METRES));
                    } else {
                        stringBuilder2.append('0');
                    }
                    stringBuilder2.append("</gx:coord>\n");
                    ++n3;
                    bl3 = false;
                }
            }
            ++n5;
        }
        outputStreamWriter.write(stringBuilder.toString());
        outputStreamWriter.write(10);
        outputStreamWriter.write(stringBuilder2.toString());
        outputStreamWriter.write(10);
        outputStreamWriter.write(string2);
        return n3;
    }

    private static String reverse(String string) {
        return String.valueOf(string.substring(4, 6)) + string.substring(2, 4) + string.substring(0, 2);
    }

    private void exportWaypoint(DataPoint dataPoint, Writer writer, boolean bl) throws IOException {
        String string = dataPoint.getWaypointName().trim();
        this.exportNamedPoint(dataPoint, writer, string, dataPoint.getFieldValue(Field.DESCRIPTION), null, bl);
    }

    private void exportAudioPoint(DataPoint dataPoint, Writer writer, boolean bl) throws IOException {
        String string = dataPoint.getAudio().getName();
        String string2 = null;
        if (dataPoint.getAudio().getFile() != null) {
            string2 = dataPoint.getAudio().getFile().getAbsolutePath();
        }
        this.exportNamedPoint(dataPoint, writer, string, string2, "audio_icon", bl);
    }

    private void exportPhotoPoint(DataPoint dataPoint, Writer writer, boolean bl, int n, int n2, boolean bl2) throws IOException {
        String string = dataPoint.getPhoto().getName();
        String string2 = null;
        if (bl) {
            Dimension dimension = this._imageDimensions[n];
            string2 = "<![CDATA[<br/><table border='0'><tr><td><center><img src='images/image" + n2 + ".jpg' width='" + dimension.width + "' height='" + dimension.height + "'></center></td></tr>" + "<tr><td><center>" + string + KmlExporter.wrapInBrackets(KmlExporter.getPhotoTimeString(dataPoint)) + "</center></td></tr>" + KmlExporter.wrapInTableRow(KmlExporter.getPointCaption(dataPoint)) + "</table>]]>";
        }
        this.exportNamedPoint(dataPoint, writer, string, string2, "camera_icon", bl2);
    }

    private void exportNamedPoint(DataPoint dataPoint, Writer writer, String string, String string2, String string3, boolean bl) throws IOException {
        writer.write("\t<Placemark>\n\t\t<name>");
        writer.write(XmlUtils.fixCdata(string));
        writer.write("</name>\n");
        if (string2 != null) {
            writer.write("\t\t<description>");
            writer.write(XmlUtils.fixCdata(string2));
            writer.write("</description>\n");
        }
        if (string3 != null) {
            writer.write("<styleUrl>#");
            writer.write(string3);
            writer.write("</styleUrl>\n");
        }
        writer.write("\t\t<Point>\n");
        if (bl && dataPoint.hasAltitude()) {
            writer.write("\t\t\t<altitudeMode>absolute</altitudeMode>\n");
        } else {
            writer.write("\t\t\t<altitudeMode>clampToGround</altitudeMode>\n");
        }
        writer.write("\t\t\t<coordinates>");
        writer.write(dataPoint.getLongitude().output(17));
        writer.write(44);
        writer.write(dataPoint.getLatitude().output(17));
        writer.write(44);
        if (dataPoint.hasAltitude()) {
            writer.write(dataPoint.getAltitude().getStringValue(UnitSetLibrary.UNITS_METRES));
        } else {
            writer.write(48);
        }
        writer.write("</coordinates>\n\t\t</Point>\n\t</Placemark>\n");
    }

    private void exportTrackpoint(DataPoint dataPoint, Writer writer) throws IOException {
        writer.write(dataPoint.getLongitude().output(17));
        writer.write(44);
        writer.write(dataPoint.getLatitude().output(17));
        writer.write(44);
        if (dataPoint.hasAltitude()) {
            writer.write(dataPoint.getAltitude().getStringValue(UnitSetLibrary.UNITS_METRES));
        } else {
            writer.write(48);
        }
        writer.write(10);
    }

    private void exportThumbnails(ZipOutputStream zipOutputStream, int n) throws IOException {
        Iterator<ImageWriter> iterator = ImageIO.getImageWritersByFormatName("jpg");
        if (iterator == null || !iterator.hasNext()) {
            throw new IOException("no JPEG writer found");
        }
        ImageWriter imageWriter = iterator.next();
        boolean bl = this._pointTypeSelector.getJustSelection();
        int n2 = -1;
        int n3 = -1;
        if (bl) {
            n2 = this._trackInfo.getSelection().getStart();
            n3 = this._trackInfo.getSelection().getEnd();
        }
        int n4 = this._track.getNumPoints();
        DataPoint dataPoint = null;
        int n5 = 0;
        int n6 = 0;
        while (n6 < n4 && !this._cancelPressed) {
            dataPoint = this._track.getPoint(n6);
            if (dataPoint.getPhoto() != null && dataPoint.getPhoto().isValid() && (!bl || n6 >= n2 && n6 <= n3)) {
                ZipEntry zipEntry = new ZipEntry("images/image" + ++n5 + ".jpg");
                zipOutputStream.putNextEntry(zipEntry);
                ImageIcon imageIcon = dataPoint.getPhoto().createImageIcon();
                BufferedImage bufferedImage = ImageUtils.rotateImage(imageIcon.getImage(), n, n, dataPoint.getPhoto().getRotationDegrees());
                this._imageDimensions[n6] = new Dimension(bufferedImage.getWidth(), bufferedImage.getHeight());
                imageWriter.setOutput(ImageIO.createImageOutputStream(zipOutputStream));
                imageWriter.write(bufferedImage);
                zipOutputStream.closeEntry();
                this._progressBar.setValue(n5 + 1);
            }
            ++n6;
        }
    }

    private int getNumPhotosToExport() {
        int n = this._track.getNumPoints();
        int n2 = 0;
        DataPoint dataPoint = null;
        int n3 = 0;
        while (n3 < n) {
            dataPoint = this._track.getPoint(n3);
            if (dataPoint.getPhoto() != null) {
                ++n2;
            }
            ++n3;
        }
        return n2;
    }

    private static String getPhotoTimeString(DataPoint dataPoint) {
        TimeZone timeZone = TimezoneHelper.getSelectedTimezone();
        if (dataPoint.hasTimestamp()) {
            return dataPoint.getTimestamp().getTimeText(timeZone);
        }
        if (dataPoint.getPhoto().hasTimestamp()) {
            return dataPoint.getPhoto().getTimestamp().getTimeText(timeZone);
        }
        return null;
    }

    private static String wrapInBrackets(String string) {
        if (string == null || string.isBlank()) {
            return "";
        }
        return " (" + string + ")";
    }

    private static String getPointCaption(DataPoint dataPoint) {
        String string = dataPoint.getFieldValue(Field.DESCRIPTION);
        if (string != null && !string.isBlank()) {
            return string;
        }
        return dataPoint.getFieldValue(Field.COMMENT);
    }

    private static String wrapInTableRow(String string) {
        if (string == null || string.isBlank()) {
            return "";
        }
        return "<tr><td>" + string + "</td></tr>";
    }
}

