/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.compile.incremental.classpath;

import com.google.common.collect.ImmutableSet;
import java.io.Closeable;
import java.io.File;
import java.io.InputStream;
import java.util.Set;
import org.gradle.api.file.FileTreeElement;
import org.gradle.api.file.FileVisitDetails;
import org.gradle.api.file.FileVisitor;
import org.gradle.api.internal.file.FileOperations;
import org.gradle.api.internal.tasks.compile.incremental.analyzer.ClassDependenciesAnalyzer;
import org.gradle.api.internal.tasks.compile.incremental.classpath.ClassSetAnalyzer;
import org.gradle.api.internal.tasks.compile.incremental.deps.ClassAnalysis;
import org.gradle.api.internal.tasks.compile.incremental.deps.ClassDependentsAccumulator;
import org.gradle.api.internal.tasks.compile.incremental.deps.ClassSetAnalysisData;
import org.gradle.internal.FileUtils;
import org.gradle.internal.IoActions;
import org.gradle.internal.hash.FileHasher;
import org.gradle.internal.hash.HashCode;
import org.gradle.internal.hash.StreamHasher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultClassSetAnalyzer
implements ClassSetAnalyzer {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultClassSetAnalyzer.class);
    private final FileHasher fileHasher;
    private final StreamHasher hasher;
    private final ClassDependenciesAnalyzer analyzer;
    private final FileOperations fileOperations;

    public DefaultClassSetAnalyzer(FileHasher fileHasher, StreamHasher streamHasher, ClassDependenciesAnalyzer analyzer, FileOperations fileOperations) {
        this.fileHasher = fileHasher;
        this.hasher = streamHasher;
        this.analyzer = analyzer;
        this.fileOperations = fileOperations;
    }

    @Override
    public ClassSetAnalysisData analyzeClasspathEntry(File classpathEntry) {
        return this.analyze(classpathEntry, true);
    }

    @Override
    public ClassSetAnalysisData analyzeOutputFolder(File outputFolder) {
        return this.analyze(outputFolder, false);
    }

    private ClassSetAnalysisData analyze(File classSet, boolean abiOnly) {
        ClassDependentsAccumulator accumulator;
        block2: {
            accumulator = new ClassDependentsAccumulator();
            try {
                this.visit(classSet, accumulator, abiOnly);
            }
            catch (Exception e) {
                accumulator.fullRebuildNeeded(classSet + " could not be analyzed for incremental compilation. See the debug log for more details");
                if (!LOGGER.isDebugEnabled()) break block2;
                LOGGER.debug("Could not analyze " + classSet + " for incremental compilation", (Throwable)e);
            }
        }
        return accumulator.getAnalysis();
    }

    private void visit(File classpathEntry, ClassDependentsAccumulator accumulator, boolean abiOnly) {
        if (FileUtils.hasExtension((File)classpathEntry, (String)".jar")) {
            this.fileOperations.zipTree((Object)classpathEntry).visit((FileVisitor)new JarEntryVisitor(accumulator, abiOnly));
        }
        if (classpathEntry.isDirectory()) {
            this.fileOperations.fileTree((Object)classpathEntry).visit((FileVisitor)new DirectoryEntryVisitor(accumulator, abiOnly));
        }
    }

    private class DirectoryEntryVisitor
    extends EntryVisitor {
        public DirectoryEntryVisitor(ClassDependentsAccumulator accumulator, boolean abiOnly) {
            super(accumulator, abiOnly);
        }

        @Override
        protected HashCode getHashCode(FileVisitDetails fileDetails) {
            return DefaultClassSetAnalyzer.this.fileHasher.hash(fileDetails.getFile(), fileDetails.getSize(), fileDetails.getLastModified());
        }
    }

    private class JarEntryVisitor
    extends EntryVisitor {
        public JarEntryVisitor(ClassDependentsAccumulator accumulator, boolean abiOnly) {
            super(accumulator, abiOnly);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected HashCode getHashCode(FileVisitDetails fileDetails) {
            InputStream inputStream = fileDetails.open();
            try {
                HashCode hashCode = DefaultClassSetAnalyzer.this.hasher.hash(inputStream);
                return hashCode;
            }
            finally {
                IoActions.closeQuietly((Closeable)inputStream);
            }
        }
    }

    private abstract class EntryVisitor
    implements FileVisitor {
        private final ClassDependentsAccumulator accumulator;
        private final boolean abiOnly;

        public EntryVisitor(ClassDependentsAccumulator accumulator, boolean abiOnly) {
            this.accumulator = accumulator;
            this.abiOnly = abiOnly;
        }

        public void visitDir(FileVisitDetails dirDetails) {
        }

        public void visitFile(FileVisitDetails fileDetails) {
            block3: {
                if (!fileDetails.getName().endsWith(".class")) {
                    return;
                }
                HashCode classFileHash = this.getHashCode(fileDetails);
                try {
                    ClassAnalysis analysis = this.maybeStripToAbi(DefaultClassSetAnalyzer.this.analyzer.getClassAnalysis(classFileHash, (FileTreeElement)fileDetails));
                    this.accumulator.addClass(analysis, classFileHash);
                }
                catch (Exception e) {
                    this.accumulator.fullRebuildNeeded(fileDetails.getName() + " could not be analyzed for incremental compilation. See the debug log for more details");
                    if (!LOGGER.isDebugEnabled()) break block3;
                    LOGGER.debug("Could not analyze " + fileDetails.getName() + " for incremental compilation", (Throwable)e);
                }
            }
        }

        private ClassAnalysis maybeStripToAbi(ClassAnalysis analysis) {
            if (this.abiOnly) {
                return new ClassAnalysis(analysis.getClassName(), (Set<String>)ImmutableSet.of(), analysis.getAccessibleClassDependencies(), analysis.getDependencyToAllReason(), analysis.getConstants());
            }
            return analysis;
        }

        protected abstract HashCode getHashCode(FileVisitDetails var1);
    }
}

