/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.snapshot.impl;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Interner;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.FileSystemLoopException;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Deque;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import java.util.function.Predicate;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import org.gradle.internal.file.FileMetadata;
import org.gradle.internal.file.FileType;
import org.gradle.internal.file.impl.DefaultFileMetadata;
import org.gradle.internal.hash.FileHasher;
import org.gradle.internal.hash.HashCode;
import org.gradle.internal.snapshot.DirectorySnapshot;
import org.gradle.internal.snapshot.DirectorySnapshotBuilder;
import org.gradle.internal.snapshot.FileSystemLeafSnapshot;
import org.gradle.internal.snapshot.FileSystemLocationSnapshot;
import org.gradle.internal.snapshot.MissingFileSnapshot;
import org.gradle.internal.snapshot.RegularFileSnapshot;
import org.gradle.internal.snapshot.RelativePathTracker;
import org.gradle.internal.snapshot.SnapshottingFilter;
import org.gradle.internal.snapshot.impl.DirectorySnapshotterStatistics;
import org.gradle.internal.snapshot.impl.FilteredTrackingMerkleDirectorySnapshotBuilder;

public class DirectorySnapshotter {
    private static final EnumSet<FileVisitOption> DONT_FOLLOW_SYMLINKS = EnumSet.noneOf(FileVisitOption.class);
    private static final SymbolicLinkMapping EMPTY_SYMBOLIC_LINK_MAPPING = new SymbolicLinkMapping(){

        @Override
        public String remapAbsolutePath(Path path) {
            return path.toString();
        }

        @Override
        public SymbolicLinkMapping withNewMapping(String source, String target, RelativePathTracker currentPathTracker) {
            return new DefaultSymbolicLinkMapping(source, target, currentPathTracker.getSegments());
        }

        @Override
        public Iterable<String> getRemappedSegments(Iterable<String> segments) {
            return segments;
        }
    };
    private final FileHasher hasher;
    private final Interner<String> stringInterner;
    private final DefaultExcludes defaultExcludes;
    private final DirectorySnapshotterStatistics.Collector collector;

    public DirectorySnapshotter(FileHasher hasher, Interner<String> stringInterner, Collection<String> defaultExcludes, DirectorySnapshotterStatistics.Collector collector) {
        this.hasher = hasher;
        this.stringInterner = stringInterner;
        this.defaultExcludes = new DefaultExcludes(defaultExcludes);
        this.collector = collector;
    }

    public FileSystemLocationSnapshot snapshot(String absolutePath, @Nullable SnapshottingFilter.DirectoryWalkerPredicate predicate, Consumer<FileSystemLocationSnapshot> unfilteredSnapshotConsumer) {
        try {
            AtomicBoolean hasBeenFiltered = new AtomicBoolean();
            Path rootPath = Paths.get(absolutePath, new String[0]);
            PathVisitor visitor = new PathVisitor(predicate, hasBeenFiltered, this.hasher, this.stringInterner, this.defaultExcludes, this.collector, EMPTY_SYMBOLIC_LINK_MAPPING, unfilteredSnapshotConsumer);
            Files.walkFileTree(rootPath, DONT_FOLLOW_SYMLINKS, Integer.MAX_VALUE, visitor);
            FileSystemLocationSnapshot result = visitor.getResult();
            if (!hasBeenFiltered.get()) {
                unfilteredSnapshotConsumer.accept(result);
            }
            return result;
        }
        catch (IOException e) {
            throw new UncheckedIOException(String.format("Could not list contents of directory '%s'.", absolutePath), e);
        }
    }

    private static class PathVisitor
    extends DirectorySnapshotterStatistics.CollectingFileVisitor {
        private final RelativePathTracker pathTracker = new RelativePathTracker();
        private final FilteredTrackingMerkleDirectorySnapshotBuilder builder;
        private final SnapshottingFilter.DirectoryWalkerPredicate predicate;
        private final AtomicBoolean hasBeenFiltered;
        private final FileHasher hasher;
        private final Interner<String> stringInterner;
        private final DefaultExcludes defaultExcludes;
        private final SymbolicLinkMapping symbolicLinkMapping;
        private final Deque<String> parentDirectories = new ArrayDeque<String>();
        private final Set<FileSystemLocationSnapshot> filteredDirectorySnapshots = new HashSet<FileSystemLocationSnapshot>();
        private final Consumer<FileSystemLocationSnapshot> unfilteredSnapshotConsumer;

        public PathVisitor(@Nullable SnapshottingFilter.DirectoryWalkerPredicate predicate, AtomicBoolean hasBeenFiltered, FileHasher hasher, Interner<String> stringInterner, DefaultExcludes defaultExcludes, DirectorySnapshotterStatistics.Collector statisticsCollector, SymbolicLinkMapping symbolicLinkMapping, Consumer<FileSystemLocationSnapshot> unfilteredSnapshotConsumer) {
            super(statisticsCollector);
            this.builder = FilteredTrackingMerkleDirectorySnapshotBuilder.sortingRequired(this::consumeUnfilteredSnapshot);
            this.predicate = predicate;
            this.hasBeenFiltered = hasBeenFiltered;
            this.hasher = hasher;
            this.stringInterner = stringInterner;
            this.defaultExcludes = defaultExcludes;
            this.symbolicLinkMapping = symbolicLinkMapping;
            this.unfilteredSnapshotConsumer = unfilteredSnapshotConsumer;
        }

        private void consumeUnfilteredSnapshot(FileSystemLocationSnapshot snapshot) {
            if (snapshot.getType() == FileType.Directory) {
                if (!this.filteredDirectorySnapshots.contains(snapshot)) {
                    this.unfilteredSnapshotConsumer.accept(snapshot);
                }
            } else {
                this.unfilteredSnapshotConsumer.accept(snapshot);
            }
        }

        @Override
        protected FileVisitResult doPreVisitDirectory(Path dir, BasicFileAttributes attrs) {
            String fileName = this.getInternedFileName(dir);
            this.pathTracker.enter(fileName);
            if (this.shouldVisitDirectory(dir, fileName)) {
                this.builder.enterDirectory(FileMetadata.AccessType.DIRECT, this.intern(this.symbolicLinkMapping.remapAbsolutePath(dir)), fileName, DirectorySnapshotBuilder.EmptyDirectoryHandlingStrategy.INCLUDE_EMPTY_DIRS);
                this.parentDirectories.addFirst(dir.toString());
                return FileVisitResult.CONTINUE;
            }
            this.pathTracker.leave();
            return FileVisitResult.SKIP_SUBTREE;
        }

        @Override
        protected FileVisitResult doPostVisitDirectory(Path dir, IOException exc) {
            this.pathTracker.leave();
            if (this.isNotFileSystemLoopException(exc)) {
                throw new UncheckedIOException(String.format("Could not read directory path '%s'.", dir), exc);
            }
            boolean currentLevelComplete = this.builder.isCurrentLevelUnfiltered();
            FileSystemLocationSnapshot currentLevel = this.builder.leaveDirectory();
            if (!currentLevelComplete) {
                this.filteredDirectorySnapshots.add(currentLevel);
            }
            this.parentDirectories.removeFirst();
            return FileVisitResult.CONTINUE;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected FileVisitResult doVisitFile(Path file, BasicFileAttributes attrs) {
            String internedFileName = this.getInternedFileName(file);
            this.pathTracker.enter(internedFileName);
            try {
                if (attrs.isSymbolicLink()) {
                    BasicFileAttributes targetAttributes = this.readAttributesOfSymlinkTarget(file, attrs);
                    if (targetAttributes.isDirectory()) {
                        AtomicBoolean symlinkHasBeenFiltered = new AtomicBoolean(false);
                        DirectorySnapshot targetSnapshot = this.followSymlink(file, internedFileName, symlinkHasBeenFiltered);
                        if (targetSnapshot != null) {
                            DirectorySnapshot directorySnapshotAccessedViaSymlink = new DirectorySnapshot(targetSnapshot.getAbsolutePath(), internedFileName, FileMetadata.AccessType.VIA_SYMLINK, targetSnapshot.getHash(), (List<FileSystemLocationSnapshot>)targetSnapshot.getChildren());
                            this.builder.visitDirectory(directorySnapshotAccessedViaSymlink);
                            boolean symlinkFiltered = symlinkHasBeenFiltered.get();
                            if (symlinkFiltered) {
                                this.filteredDirectorySnapshots.add(directorySnapshotAccessedViaSymlink);
                                this.builder.markCurrentLevelAsFiltered();
                                this.hasBeenFiltered.set(true);
                            }
                        }
                    } else {
                        this.visitResolvedFile(file, targetAttributes, FileMetadata.AccessType.VIA_SYMLINK);
                    }
                } else {
                    this.visitResolvedFile(file, attrs, FileMetadata.AccessType.DIRECT);
                }
                FileVisitResult fileVisitResult = FileVisitResult.CONTINUE;
                return fileVisitResult;
            }
            finally {
                this.pathTracker.leave();
            }
        }

        @Nullable
        private DirectorySnapshot followSymlink(Path file, String internedFileName, AtomicBoolean symlinkHasBeenFiltered) {
            try {
                Path targetDir = file.toRealPath(new LinkOption[0]);
                String targetDirString = targetDir.toString();
                if (!this.introducesCycle(targetDirString) && this.shouldVisitDirectory(targetDir, internedFileName)) {
                    PathVisitor subtreeVisitor = new PathVisitor(this.predicate, symlinkHasBeenFiltered, this.hasher, this.stringInterner, this.defaultExcludes, this.collector, this.symbolicLinkMapping.withNewMapping(file.toString(), targetDirString, this.pathTracker), this.unfilteredSnapshotConsumer);
                    Files.walkFileTree(targetDir, EnumSet.noneOf(FileVisitOption.class), Integer.MAX_VALUE, subtreeVisitor);
                    return (DirectorySnapshot)subtreeVisitor.getResult();
                }
                return null;
            }
            catch (IOException e) {
                throw new UncheckedIOException(String.format("Could not list contents of directory '%s'.", file), e);
            }
        }

        private boolean introducesCycle(String targetDirString) {
            return this.parentDirectories.contains(targetDirString);
        }

        private void visitResolvedFile(Path file, BasicFileAttributes targetAttributes, FileMetadata.AccessType accessType) {
            String internedName = this.intern(file.getFileName().toString());
            if (this.shouldVisitFile(file, internedName)) {
                this.builder.visitLeafElement(this.snapshotFile(file, internedName, targetAttributes, accessType));
            }
        }

        private boolean shouldVisitDirectory(Path dir, String internedName) {
            return this.pathTracker.isRoot() || this.shouldVisit(dir, internedName, true);
        }

        private boolean shouldVisitFile(Path file, String internedName) {
            return this.shouldVisit(file, internedName, false);
        }

        private BasicFileAttributes readAttributesOfSymlinkTarget(Path symlink, BasicFileAttributes symlinkAttributes) {
            try {
                return Files.readAttributes(symlink, BasicFileAttributes.class, new LinkOption[0]);
            }
            catch (IOException ioe) {
                return symlinkAttributes;
            }
        }

        private FileSystemLeafSnapshot snapshotFile(Path absoluteFilePath, String internedName, BasicFileAttributes attrs, FileMetadata.AccessType accessType) {
            String internedRemappedAbsoluteFilePath = this.intern(this.symbolicLinkMapping.remapAbsolutePath(absoluteFilePath));
            if (attrs.isSymbolicLink()) {
                return new MissingFileSnapshot(internedRemappedAbsoluteFilePath, internedName, accessType);
            }
            if (!attrs.isRegularFile()) {
                throw new UncheckedIOException(new IOException(String.format("Cannot snapshot %s: not a regular file", internedRemappedAbsoluteFilePath)));
            }
            long lastModified = attrs.lastModifiedTime().toMillis();
            long fileLength = attrs.size();
            FileMetadata metadata = DefaultFileMetadata.file((long)lastModified, (long)fileLength, (FileMetadata.AccessType)accessType);
            HashCode hash = this.hasher.hash(absoluteFilePath.toFile(), fileLength, lastModified);
            return new RegularFileSnapshot(internedRemappedAbsoluteFilePath, internedName, hash, metadata);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected FileVisitResult doVisitFileFailed(Path file, IOException exc) {
            String internedFileName = this.getInternedFileName(file);
            this.pathTracker.enter(internedFileName);
            try {
                boolean isDirectory;
                if (this.isNotFileSystemLoopException(exc) && this.shouldVisit(file, internedFileName, isDirectory = Files.isDirectory(file, new LinkOption[0]))) {
                    throw new UncheckedIOException(exc);
                }
                FileVisitResult fileVisitResult = FileVisitResult.CONTINUE;
                return fileVisitResult;
            }
            finally {
                this.pathTracker.leave();
            }
        }

        private boolean isNotFileSystemLoopException(@Nullable IOException e) {
            return e != null && !(e instanceof FileSystemLoopException);
        }

        private String intern(String string) {
            return (String)this.stringInterner.intern((Object)string);
        }

        private boolean shouldVisit(Path path, String internedName, boolean isDirectory) {
            if (isDirectory ? this.defaultExcludes.excludeDir(internedName) : this.defaultExcludes.excludeFile(internedName)) {
                return false;
            }
            if (this.predicate == null) {
                return true;
            }
            boolean allowed = this.predicate.test(path, internedName, isDirectory, this.symbolicLinkMapping.getRemappedSegments(this.pathTracker.getSegments()));
            if (!allowed) {
                this.builder.markCurrentLevelAsFiltered();
                this.hasBeenFiltered.set(true);
            }
            return allowed;
        }

        private String getInternedFileName(Path dir) {
            Path fileName = dir.getFileName();
            return fileName == null ? "" : this.intern(fileName.toString());
        }

        public FileSystemLocationSnapshot getResult() {
            return this.builder.getResult();
        }
    }

    @VisibleForTesting
    static class DefaultExcludes {
        private final ImmutableSet<String> excludeFileNames;
        private final ImmutableSet<String> excludedDirNames;
        private final Predicate<String> excludedFileNameSpec;

        public DefaultExcludes(Collection<String> defaultExcludes) {
            ArrayList excludeFiles = Lists.newArrayList();
            ArrayList excludeDirs = Lists.newArrayList();
            ArrayList excludeFileSpecs = Lists.newArrayList();
            for (String defaultExclude : defaultExcludes) {
                if (defaultExclude.startsWith("**/")) {
                    defaultExclude = defaultExclude.substring(3);
                }
                int length = defaultExclude.length();
                if (defaultExclude.endsWith("/**")) {
                    excludeDirs.add(defaultExclude.substring(0, length - 3));
                    continue;
                }
                int firstStar = defaultExclude.indexOf(42);
                if (firstStar == -1) {
                    excludeFiles.add(defaultExclude);
                    continue;
                }
                StartMatcher start = firstStar == 0 ? it -> true : new StartMatcher(defaultExclude.substring(0, firstStar));
                EndMatcher end = firstStar == length - 1 ? it -> true : new EndMatcher(defaultExclude.substring(firstStar + 1, length));
                excludeFileSpecs.add(start.and(end));
            }
            this.excludeFileNames = ImmutableSet.copyOf((Collection)excludeFiles);
            this.excludedFileNameSpec = excludeFileSpecs.stream().reduce(it -> false, Predicate::or);
            this.excludedDirNames = ImmutableSet.copyOf((Collection)excludeDirs);
        }

        public boolean excludeDir(String name) {
            return this.excludedDirNames.contains((Object)name);
        }

        public boolean excludeFile(String name) {
            return this.excludeFileNames.contains((Object)name) || this.excludedFileNameSpec.test(name);
        }

        private static class StartMatcher
        implements Predicate<String> {
            private final String start;

            public StartMatcher(String start) {
                this.start = start;
            }

            @Override
            public boolean test(String element) {
                return element.startsWith(this.start);
            }
        }

        private static class EndMatcher
        implements Predicate<String> {
            private final String end;

            public EndMatcher(String end) {
                this.end = end;
            }

            @Override
            public boolean test(String element) {
                return element.endsWith(this.end);
            }
        }
    }

    private static class DefaultSymbolicLinkMapping
    implements SymbolicLinkMapping {
        private final String sourcePath;
        private final String targetPath;
        private final Iterable<String> prefixRelativePath;

        public DefaultSymbolicLinkMapping(String sourcePath, String targetPath, Iterable<String> prefixRelativePath) {
            this.sourcePath = sourcePath;
            this.targetPath = targetPath;
            this.prefixRelativePath = prefixRelativePath;
        }

        @Override
        public String remapAbsolutePath(Path dir) {
            return this.remapAbsolutePath(dir.toString());
        }

        public String remapAbsolutePath(String absolutePath) {
            if (absolutePath.equals(this.targetPath)) {
                return this.sourcePath;
            }
            if (absolutePath.startsWith(this.targetPath) && absolutePath.charAt(this.targetPath.length()) == File.separatorChar) {
                return this.sourcePath + File.separatorChar + absolutePath.substring(this.targetPath.length() + 1);
            }
            throw new IllegalArgumentException("Cannot remap path '" + absolutePath + "' which does not have '" + this.targetPath + "' as a prefix");
        }

        @Override
        public SymbolicLinkMapping withNewMapping(String source, String target, RelativePathTracker currentPathTracker) {
            return new DefaultSymbolicLinkMapping(this.remapAbsolutePath(source), target, this.getRemappedSegments(currentPathTracker.getSegments()));
        }

        @Override
        public Iterable<String> getRemappedSegments(Iterable<String> segments) {
            return Iterables.concat(this.prefixRelativePath, segments);
        }
    }

    private static interface SymbolicLinkMapping {
        public String remapAbsolutePath(Path var1);

        @CheckReturnValue
        public SymbolicLinkMapping withNewMapping(String var1, String var2, RelativePathTracker var3);

        public Iterable<String> getRemappedSegments(Iterable<String> var1);
    }
}

