/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.component;

import java.util.Collection;
import java.util.stream.Collectors;
import org.gradle.api.artifacts.ModuleVersionIdentifier;
import org.gradle.api.capabilities.Capability;
import org.gradle.internal.component.external.model.ImmutableCapability;
import org.gradle.internal.component.model.ComponentGraphResolveMetadata;

class CapabilitiesSupport {
    CapabilitiesSupport() {
    }

    private static String displayName(Capability c) {
        String version = c.getVersion();
        if (version != null) {
            return c.getGroup() + ":" + c.getName() + ":" + c.getVersion();
        }
        return c.getGroup() + ":" + c.getName();
    }

    static String sortedCapabilityList(ComponentGraphResolveMetadata target, Collection<? extends Capability> capabilities) {
        if (capabilities.isEmpty()) {
            ModuleVersionIdentifier mvi = target.getModuleVersionId();
            return CapabilitiesSupport.displayName(new ImmutableCapability(mvi.getGroup(), mvi.getName(), mvi.getVersion()));
        }
        return capabilities.stream().map(CapabilitiesSupport::displayName).sorted().collect(Collectors.joining(" and "));
    }

    static String prettifyCapabilities(ComponentGraphResolveMetadata targetComponent, Collection<? extends Capability> capabilities) {
        StringBuilder sb = new StringBuilder("capabilit");
        if (capabilities.size() > 1) {
            sb.append("ies ");
            sb.append(CapabilitiesSupport.sortedCapabilityList(targetComponent, capabilities));
        } else {
            sb.append("y ").append(CapabilitiesSupport.sortedCapabilityList(targetComponent, capabilities));
        }
        return sb.toString();
    }
}

