/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.problems;

import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.gradle.problems.Problem;
import org.gradle.problems.Solution;

public class BaseProblem<ID extends Enum<ID>, SEVERITY extends Enum<SEVERITY>, CONTEXT>
implements Problem<ID, SEVERITY, CONTEXT> {
    private final ID id;
    private final SEVERITY severity;
    private final CONTEXT context;
    private final Supplier<String> shortDescription;
    private final Supplier<String> longDescription;
    private final Supplier<String> reason;
    private final Supplier<String> docUrl;
    private final List<Supplier<Solution>> solutions;

    public BaseProblem(ID id, SEVERITY severity, CONTEXT context, Supplier<String> shortDescription, Supplier<String> longDescription, Supplier<String> reason, Supplier<String> docUrl, List<Supplier<Solution>> solutions) {
        this.id = id;
        this.severity = severity;
        this.context = Objects.requireNonNull(context, "context must not be null");
        this.shortDescription = Objects.requireNonNull(shortDescription, "short description supplier must not be null");
        this.longDescription = Objects.requireNonNull(longDescription, "long description supplier must not be null");
        this.reason = Objects.requireNonNull(reason, "reason supplier must not be null");
        this.docUrl = Objects.requireNonNull(docUrl, "documentation link supplier must not be null");
        this.solutions = Objects.requireNonNull(solutions, "solutions must not be null");
    }

    @Override
    public SEVERITY getSeverity() {
        return this.severity;
    }

    @Override
    public CONTEXT getWhere() {
        return this.context;
    }

    @Override
    public Optional<String> getWhy() {
        return Optional.ofNullable(this.reason.get());
    }

    @Override
    public Optional<String> getDocumentationLink() {
        return Optional.ofNullable(this.docUrl.get());
    }

    @Override
    public ID getId() {
        return this.id;
    }

    @Override
    public String getShortDescription() {
        return this.shortDescription.get();
    }

    @Override
    public Optional<String> getLongDescription() {
        return Optional.ofNullable(this.longDescription.get());
    }

    @Override
    public List<Solution> getPossibleSolutions() {
        return this.solutions.stream().map(Supplier::get).collect(Collectors.toList());
    }
}

