/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks;

import org.gradle.api.NonNullApi;
import org.gradle.api.internal.tasks.AbstractTaskFilePropertyRegistration;
import org.gradle.api.internal.tasks.StaticValue;
import org.gradle.api.internal.tasks.TaskInputFilePropertyBuilderInternal;
import org.gradle.api.internal.tasks.TaskInputFilePropertyRegistration;
import org.gradle.api.internal.tasks.properties.FileParameterUtils;
import org.gradle.api.internal.tasks.properties.InputFilePropertyType;
import org.gradle.api.tasks.FileNormalizer;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.TaskInputFilePropertyBuilder;
import org.gradle.internal.fingerprint.AbsolutePathInputNormalizer;
import org.gradle.internal.fingerprint.DirectorySensitivity;
import org.gradle.internal.fingerprint.LineEndingSensitivity;

@NonNullApi
public class DefaultTaskInputFilePropertyRegistration
extends AbstractTaskFilePropertyRegistration
implements TaskInputFilePropertyRegistration {
    private final InputFilePropertyType filePropertyType;
    private boolean skipWhenEmpty;
    private DirectorySensitivity directorySensitivity = DirectorySensitivity.UNSPECIFIED;
    private LineEndingSensitivity lineEndingSensitivity = LineEndingSensitivity.DEFAULT;
    private Class<? extends FileNormalizer> normalizer = AbsolutePathInputNormalizer.class;

    public DefaultTaskInputFilePropertyRegistration(StaticValue value, InputFilePropertyType filePropertyType) {
        super(value);
        this.filePropertyType = filePropertyType;
    }

    @Override
    public InputFilePropertyType getFilePropertyType() {
        return this.filePropertyType;
    }

    @Override
    public TaskInputFilePropertyBuilderInternal withPropertyName(String propertyName) {
        this.setPropertyName(propertyName);
        return this;
    }

    @Override
    public boolean isSkipWhenEmpty() {
        return this.skipWhenEmpty;
    }

    @Override
    public TaskInputFilePropertyBuilderInternal skipWhenEmpty(boolean skipWhenEmpty) {
        this.skipWhenEmpty = skipWhenEmpty;
        return this;
    }

    @Override
    public TaskInputFilePropertyBuilderInternal skipWhenEmpty() {
        return this.skipWhenEmpty(true);
    }

    @Override
    public TaskInputFilePropertyBuilderInternal optional(boolean optional) {
        this.setOptional(optional);
        return this;
    }

    @Override
    public TaskInputFilePropertyBuilderInternal optional() {
        return this.optional(true);
    }

    @Override
    public TaskInputFilePropertyBuilderInternal withPathSensitivity(PathSensitivity sensitivity) {
        return this.withNormalizer((Class)FileParameterUtils.determineNormalizerForPathSensitivity(sensitivity));
    }

    @Override
    public TaskInputFilePropertyBuilderInternal withNormalizer(Class<? extends FileNormalizer> normalizer) {
        this.normalizer = normalizer;
        return this;
    }

    @Override
    public Class<? extends FileNormalizer> getNormalizer() {
        return this.normalizer;
    }

    @Override
    public DirectorySensitivity getDirectorySensitivity() {
        return this.directorySensitivity;
    }

    public TaskInputFilePropertyBuilder ignoreEmptyDirectories() {
        this.directorySensitivity = DirectorySensitivity.IGNORE_DIRECTORIES;
        return this;
    }

    public TaskInputFilePropertyBuilder ignoreEmptyDirectories(boolean ignoreDirectories) {
        this.directorySensitivity = ignoreDirectories ? DirectorySensitivity.IGNORE_DIRECTORIES : DirectorySensitivity.DEFAULT;
        return this;
    }

    @Override
    public LineEndingSensitivity getLineEndingNormalization() {
        return this.lineEndingSensitivity;
    }

    public TaskInputFilePropertyBuilder normalizeLineEndings() {
        this.lineEndingSensitivity = LineEndingSensitivity.NORMALIZE_LINE_ENDINGS;
        return this;
    }

    public TaskInputFilePropertyBuilder normalizeLineEndings(boolean ignoreLineEndings) {
        this.lineEndingSensitivity = ignoreLineEndings ? LineEndingSensitivity.NORMALIZE_LINE_ENDINGS : LineEndingSensitivity.DEFAULT;
        return this;
    }

    public String toString() {
        return this.getPropertyName() + " (" + this.getNormalizer().getSimpleName().replace("Normalizer", "") + ")";
    }
}

